DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-10
      0.00000000000000E+00  -1.22248100565334E-11   0.00000000000000E+00   1.97004156040452E-13   1.66478653341606E-22
      1.22247884334365E-08   1.22249854375927E-08  -7.89593879202815E-19  -2.50634423491826E-01  -2.50634423491821E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.48782128770641E-12   0.00000000000000E+00  -4.48782128770641E-12
      3.69848470502354E-18  -2.50634423491833E-01  -2.46784373370042E-01   0.00000000000000E+00  -1.99541773676493E-13
     -9.83531228659138E-23  -1.22202980745312E-08  -1.22204976163050E-08  -2.90889082582073E-18
      1.17500000000000E-09
      0.00000000000000E+00  -1.24273277020760E-11   0.00000000000000E+00   2.04427057011583E-13   1.68705730272863E-22
      1.24272869204799E-08   1.24274913475371E-08  -7.88042275316296E-19  -2.51349385892031E-01  -2.51349385892026E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.74581126066389E-12   0.00000000000000E+00  -4.74581126066389E-12
      3.69528128242260E-18  -2.51349385892121E-01  -2.47435620879737E-01   0.00000000000000E+00  -2.10079473685210E-13
     -9.83784494919556E-23  -1.24225354568027E-08  -1.24227455362765E-08  -2.90723900710630E-18
      2.08625000000000E-09
      0.00000000000000E+00  -1.26296616581442E-11   0.00000000000000E+00   3.87984172256775E-14   1.70156976923671E-22
      1.26295624593690E-08   1.26296012577864E-08  -7.86445318605486E-19  -2.52123214179450E-01  -2.52123214179445E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.58741381211640E-12   0.00000000000000E+00  -4.58741381211640E-12
      3.69110100158631E-18  -2.52123214179542E-01  -2.48145673396923E-01   0.00000000000000E+00  -4.56073780771066E-14
     -9.84147762129305E-23  -1.26249682365961E-08  -1.26250138439743E-08  -2.90465568298082E-18
      3.31643750000000E-09
      0.00000000000000E+00  -1.28223519168056E-11   0.00000000000000E+00   4.12064449844626E-14   1.70761867693063E-22
      1.28223332810562E-08   1.28223744875014E-08  -7.84873672107989E-19  -2.52920928691209E-01  -2.52920928691205E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.04893211463738E-12   0.00000000000000E+00  -4.04893211463738E-12
      3.68612005591053E-18  -2.52920928691221E-01  -2.48882486566449E-01   0.00000000000000E+00  -4.83429311950736E-14
     -9.84612107310954E-23  -1.28182772124554E-08  -1.28183255553867E-08  -2.90124638380254E-18
      4.97719062500000E-09
      0.00000000000000E+00  -1.29970406069743E-11   0.00000000000000E+00   4.12554596604286E-14   1.70644479832929E-22
      1.29970415741443E-08   1.29970828296042E-08  -7.83404424976055E-19  -2.53694847298680E-01  -2.53694847298677E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.23858910089382E-12   0.00000000000000E+00  -3.23858910089382E-12
      3.68074155894063E-18  -2.53694847297923E-01  -2.49601108706041E-01   0.00000000000000E+00  -4.76392282863018E-14
     -9.85141037687728E-23  -1.29937966012749E-08  -1.29938442405033E-08  -2.89733713396458E-18
      6.97719062500000E-09
      0.00000000000000E+00  -1.31351750917344E-11   0.00000000000000E+00   2.80388318189788E-14   1.70138745880317E-22
      1.31351596327753E-08   1.31351876716073E-08  -7.82213913561145E-19  -2.54337765696697E-01  -2.54337765696694E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.39854136514044E-12   0.00000000000000E+00  -2.39854136514044E-12
      3.67594447621035E-18  -2.54337765695025E-01  -2.50200248907769E-01   0.00000000000000E+00  -3.31146067072063E-14
     -9.85631196605513E-23  -1.31327560156354E-08  -1.31327891302422E-08  -2.89373056264921E-18
      8.97719062500000E-09
      0.00000000000000E+00  -1.32283975000001E-11   0.00000000000000E+00   2.31555255255482E-15   1.69614273528346E-22
      1.32283978854339E-08   1.32284002009867E-08  -7.81397129909864E-19  -2.54785260092958E-01  -2.54785260092956E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.74215349141396E-12   0.00000000000000E+00  -1.74215349141396E-12
      3.67246016922752E-18  -2.54785260090903E-01  -2.50618162197397E-01   0.00000000000000E+00  -6.12819768235156E-15
     -9.85996515408422E-23  -1.32266519192975E-08  -1.32266580474952E-08  -2.89106303931766E-18
      1.09771906250000E-08
      0.00000000000000E+00  -1.32924132818337E-11   0.00000000000000E+00   5.38150847954105E-15   1.69173897401517E-22
      1.32924171297185E-08   1.32924225112272E-08  -7.80830177504951E-19  -2.55098453556331E-01  -2.55098453556329E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25172203458213E-12   0.00000000000000E+00  -1.25172203458213E-12
      3.66995672515836E-18  -2.55098453554109E-01  -2.50911032146545E-01   0.00000000000000E+00  -8.21535388831411E-15
     -9.86263676763180E-23  -1.32911625738386E-08  -1.32911707891926E-08  -2.88912654765340E-18
      1.29771906250000E-08
      0.00000000000000E+00  -1.33367742899050E-11   0.00000000000000E+00   2.81814678368254E-14   1.68833070232403E-22
      1.33368459667811E-08   1.33368741482491E-08  -7.80433914340726E-19  -2.55318391400055E-01  -2.55318391400054E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.93691093975870E-13   0.00000000000000E+00  -8.93691093975870E-13
      3.66816934297041E-18  -2.55318391399801E-01  -2.51116860050831E-01   0.00000000000000E+00  -3.03439978818314E-14
     -9.86456760768486E-23  -1.33359501131572E-08  -1.33359804571552E-08  -2.88773542862968E-18
      1.49771906250000E-08
      0.00000000000000E+00  -1.33679096558183E-11   0.00000000000000E+00   3.13502315230020E-15   1.68579623040616E-22
      1.33678979728514E-08   1.33679011078748E-08  -7.80155892437630E-19  -2.55473131267956E-01  -2.55473131267955E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.35614093101343E-13   0.00000000000000E+00  -6.35614093101343E-13
      3.66689811478420E-18  -2.55473131269859E-01  -2.51261735838450E-01   0.00000000000000E+00  -4.62751397188069E-15
     -9.86595674888512E-23  -1.33672608662676E-08  -1.33672654937816E-08  -2.88674222234657E-18
      1.69771906250000E-08
      0.00000000000000E+00  -1.33896768585365E-11   0.00000000000000E+00   1.41782456742343E-14   1.68394768564543E-22
      1.33896664692451E-08   1.33896806474909E-08  -7.79960314265995E-19  -2.55582154071324E-01  -2.55582154071324E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.51000302542807E-13   0.00000000000000E+00  -4.51000302542807E-13
      3.66599611417912E-18  -2.55582154075488E-01  -2.51363842398979E-01   0.00000000000000E+00  -1.53092522787534E-14
     -9.86694736748840E-23  -1.33892143379360E-08  -1.33892296471884E-08  -2.88603579991312E-18
      1.89771906250000E-08
      0.00000000000000E+00  -1.34050149296502E-11   0.00000000000000E+00   9.21337297025993E-16   1.68261746663236E-22
      1.34049783204836E-08   1.34049792418211E-08  -7.79822563206266E-19  -2.55659016335648E-01  -2.55659016335648E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.19514579210317E-13   0.00000000000000E+00  -3.19514579210317E-13
      3.66535708502070E-18  -2.55659016343231E-01  -2.51435839324502E-01   0.00000000000000E+00  -1.68212241526763E-15
     -9.86765494858345E-23  -1.34046580451194E-08  -1.34046597272419E-08  -2.88553452181443E-18
      2.09771906250000E-08
      0.00000000000000E+00  -1.34157607639034E-11   0.00000000000000E+00   3.40909104237432E-15   1.68166536983589E-22
      1.34157557138291E-08   1.34157591229203E-08  -7.79725436888377E-19  -2.55713239557044E-01  -2.55713239557043E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.26146906099329E-13   0.00000000000000E+00  -2.26146906099329E-13
      3.66490479120850E-18  -2.55713239567639E-01  -2.51486637760555E-01   0.00000000000000E+00  -3.96703561738352E-15
     -9.86815674126699E-23  -1.34155290089785E-08  -1.34155329760142E-08  -2.88517935432012E-18
      2.29771906250000E-08
      0.00000000000000E+00  -1.34233838770917E-11   0.00000000000000E+00   3.19447770605242E-16   1.68098762549117E-22
      1.34233533804318E-08   1.34233536998798E-08  -7.79656923352307E-19  -2.55751502367931E-01  -2.55751502367931E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59957442271395E-13   0.00000000000000E+00  -1.59957442271395E-13
      3.66458487632396E-18  -2.55751502380774E-01  -2.51522486112815E-01   0.00000000000000E+00  -7.03330413862430E-16
     -9.86851336458911E-23  -1.34231930391070E-08  -1.34231937424375E-08  -2.88492795297165E-18
      2.49771906250000E-08
      0.00000000000000E+00  -1.34287108718497E-11   0.00000000000000E+00   8.93601027898744E-16   1.68050607430527E-22
      1.34287107415344E-08   1.34287116351356E-08  -7.79608572212317E-19  -2.55778510405492E-01  -2.55778510405492E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13093598763032E-13   0.00000000000000E+00  -1.13093598763032E-13
      3.66435868912643E-18  -2.55778510418110E-01  -2.51547791572393E-01   0.00000000000000E+00  -1.17016524982556E-15
     -9.86876582863475E-23  -1.34285973713715E-08  -1.34285985415368E-08  -2.88475011691411E-18
      2.69771906250000E-08
      0.00000000000000E+00  -1.34325683508124E-11   0.00000000000000E+00   7.17534182660123E-16   1.68016480524411E-22
      1.34324908520443E-08   1.34324915695786E-08  -7.79574442960578E-19  -2.55797576984609E-01  -2.55797576984609E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.99357486558468E-14   0.00000000000000E+00  -7.99357486558468E-14
      3.66419881762912E-18  -2.55797576992640E-01  -2.51565656794353E-01   0.00000000000000E+00  -9.18053081269861E-16
     -9.86894477329307E-23  -1.34324107157768E-08  -1.34324116338299E-08  -2.88462437466854E-18
      2.89771906250000E-08
      0.00000000000000E+00  -1.34351400034542E-11   0.00000000000000E+00   2.53456538009789E-16   1.67992291540309E-22
      1.34351587244549E-08   1.34351589779116E-08  -7.79550348562146E-19  -2.55811038641596E-01  -2.55811038641596E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.64883942330248E-14   0.00000000000000E+00  -5.64883942330248E-14
      3.66408584084065E-18  -2.55811038639230E-01  -2.51578270552940E-01   0.00000000000000E+00  -3.92023470158299E-16
     -9.86907133757300E-23  -1.34351020974938E-08  -1.34351024895174E-08  -2.88453549227851E-18
      3.09771906250000E-08
      0.00000000000000E+00  -1.34369768981984E-11   0.00000000000000E+00   2.01161722816768E-16   1.67975182386023E-22
      1.34370418298634E-08   1.34370420310253E-08  -7.79533336456007E-19  -2.55820544030795E-01  -2.55820544030795E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.99131893248114E-14   0.00000000000000E+00  -3.99131893248114E-14
      3.66400601446200E-18  -2.55820544011259E-01  -2.51587177438946E-01   0.00000000000000E+00  -2.99655345515653E-16
     -9.86916091435434E-23  -1.34370018181805E-08  -1.34370021178359E-08  -2.88447267800599E-18
      3.29771906250000E-08
      0.00000000000000E+00  -1.34383545692565E-11   0.00000000000000E+00   9.32085193258744E-16   1.67963089787473E-22
      1.34383711144661E-08   1.34383720465515E-08  -7.79521323018857E-19  -2.55827256641371E-01  -2.55827256641371E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.81988864295631E-14   0.00000000000000E+00  -2.81988864295631E-14
      3.66394961668914E-18  -2.55827256597374E-01  -2.51593467549279E-01   0.00000000000000E+00  -1.01231746316297E-15
     -9.86922424488112E-23  -1.34383428353475E-08  -1.34383438476650E-08  -2.88442829367029E-18
      3.49771906250000E-08
      0.00000000000000E+00  -1.34393648613658E-11   0.00000000000000E+00   6.14247774204825E-17   1.67954520609730E-22
      1.34393100661143E-08   1.34393101275393E-08  -7.79512840381529E-19  -2.55831996566016E-01  -2.55831996566016E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.99210838394533E-14   0.00000000000000E+00  -1.99210838394533E-14
      3.66390977452147E-18  -2.55831996495005E-01  -2.51597909027102E-01   0.00000000000000E+00  -1.11631345287660E-16
     -9.86926902097033E-23  -1.34392900948240E-08  -1.34392902064554E-08  -2.88439693413994E-18
      3.69771906250000E-08
      0.00000000000000E+00  -1.34399159297890E-11   0.00000000000000E+00   2.39569365012543E-16   1.67948472810563E-22
      1.34399727914982E-08   1.34399730310677E-08  -7.79506849824670E-19  -2.55835344097801E-01  -2.55835344097801E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.40727625584357E-14   0.00000000000000E+00  -1.40727625584357E-14
      3.66388162899635E-18  -2.55835344004815E-01  -2.51601045905304E-01   0.00000000000000E+00  -2.76696208931237E-16
     -9.86930067090369E-23  -1.34399586816089E-08  -1.34399589583052E-08  -2.88437477917168E-18
      3.89771906250000E-08
      0.00000000000000E+00  -1.34403751534750E-11   0.00000000000000E+00   2.10972491017778E-17   1.67944194270212E-22
      1.34404408903123E-08   1.34404409114097E-08  -7.79502619315879E-19  -2.55837708143140E-01  -2.55837708143140E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94073989940071E-15   0.00000000000000E+00  -9.94073989940071E-15
      3.66386174751655E-18  -2.55837708042481E-01  -2.51603261168914E-01   0.00000000000000E+00  -4.56994262829100E-17
     -9.86932303963388E-23  -1.34404309249703E-08  -1.34404309706698E-08  -2.88435912820067E-18
      4.09771906250000E-08
      0.00000000000000E+00  -1.34407425324239E-11   0.00000000000000E+00   6.36675396494363E-17   1.67941173389151E-22
      1.34407713891684E-08   1.34407714528361E-08  -7.79499631520544E-19  -2.55839377779167E-01  -2.55839377779168E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.02182182191950E-15   0.00000000000000E+00  -7.02182182191950E-15
      3.66384770387291E-18  -2.55839377697497E-01  -2.51604825782047E-01   0.00000000000000E+00  -8.14659091948151E-17
     -9.86933884650346E-23  -1.34407643495482E-08  -1.34407644310142E-08  -2.88434807235236E-18
      4.29771906250000E-08
      0.00000000000000E+00  -1.34410180666355E-11   0.00000000000000E+00   8.15098804781543E-18   1.67939037887472E-22
      1.34410048166771E-08   1.34410048248282E-08  -7.79497521445660E-19  -2.55840556938051E-01  -2.55840556938051E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.95978257255170E-15   0.00000000000000E+00  -4.95978257255170E-15
      3.66383778430776E-18  -2.55840556914793E-01  -2.51605930809458E-01   0.00000000000000E+00  -2.03174286425171E-17
     -9.86935001592279E-23  -1.34409998447281E-08  -1.34409998650456E-08  -2.88434026286210E-18
      4.49771906250000E-08
      0.00000000000000E+00  -1.34412017561099E-11   0.00000000000000E+00   1.78882671635022E-17   1.67937529758003E-22
      1.34411696498236E-08   1.34411696677120E-08  -7.79496031205845E-19  -2.55841389728054E-01  -2.55841389728054E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.50319500839174E-15   0.00000000000000E+00  -3.50319500839174E-15
      3.66383077791774E-18  -2.55841389811723E-01  -2.51606711317527E-01   0.00000000000000E+00  -2.65802649478251E-17
     -9.86935790786395E-23  -1.34411661379367E-08  -1.34411661645170E-08  -2.88433474671190E-18
      4.69771906250000E-08
      0.00000000000000E+00  -1.34412936008471E-11   0.00000000000000E+00   3.47643809674580E-18   1.67936464051617E-22
      1.34412860645735E-08   1.34412860680501E-08  -7.79494978750831E-19  -2.55841977874604E-01  -2.55841977874604E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.47427611037796E-15   0.00000000000000E+00  -2.47427611037796E-15
      3.66382582936552E-18  -2.55841978113590E-01  -2.51607262619307E-01   0.00000000000000E+00  -9.52035801944800E-18
     -9.86936348419498E-23  -1.34412835842535E-08  -1.34412835937740E-08  -2.88433085061469E-18
      4.89771906250000E-08
      0.00000000000000E+00  -1.34413854455843E-11   0.00000000000000E+00   5.47323510224251E-18   1.67935711380138E-22
      1.34413682767146E-08   1.34413682821880E-08  -7.79494235455181E-19  -2.55842393254093E-01  -2.55842393254093E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.74752409880046E-15   0.00000000000000E+00  -1.74752409880046E-15
      3.66382233431733E-18  -2.55842393681363E-01  -2.51607652057550E-01   0.00000000000000E+00  -9.76723584409405E-18
     -9.86936742424039E-23  -1.34413665248966E-08  -1.34413665346639E-08  -2.88432809886214E-18
      5.09771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   1.59166242997951E-18   1.67935179688580E-22
      1.34414263449670E-08   1.34414263465589E-08  -7.79493710470987E-19  -2.55842686630481E-01  -2.55842686630481E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23426027032422E-15   0.00000000000000E+00  -1.23426027032422E-15
      3.66381986579678E-18  -2.55842687242041E-01  -2.51607927162387E-01   0.00000000000000E+00  -4.59885343160819E-18
     -9.86937020813635E-23  -1.34414251076996E-08  -1.34414251122986E-08  -2.88432615532580E-18
      5.29771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   1.87245646514531E-18   1.67934804274513E-22
      1.34414673681954E-08   1.34414673700680E-08  -7.79493339593866E-19  -2.55842893879960E-01  -2.55842893879960E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.71879366908143E-16   0.00000000000000E+00  -8.71879366908143E-16
      3.66381812203805E-18  -2.55842894610246E-01  -2.51608121492243E-01   0.00000000000000E+00  -4.00493477246191E-18
     -9.86937217465520E-23  -1.34414664941836E-08  -1.34414664981886E-08  -2.88432478244418E-18
      5.49771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   7.59092158908547E-19   1.67934539270042E-22
      1.34414963670002E-08   1.34414963677594E-08  -7.79493077453592E-19  -2.55843040354021E-01  -2.55843040354021E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.16152047816367E-16   0.00000000000000E+00  -6.16152047816367E-16
      3.66381688973395E-18  -2.55843041053426E-01  -2.51608258718914E-01   0.00000000000000E+00  -2.25519116218067E-18
     -9.86937356295120E-23  -1.34414957493521E-08  -1.34414957516074E-08  -2.88432381228036E-18
      5.69771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   7.17077755874294E-19   1.67934352338650E-22
      1.34415168864418E-08   1.34415168871591E-08  -7.79492891986735E-19  -2.55843143969770E-01  -2.55843143969770E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.35824023225720E-16   0.00000000000000E+00  -4.35824023225720E-16
      3.66381601808591E-18  -2.55843144393353E-01  -2.51608355537473E-01   0.00000000000000E+00  -1.77710701506941E-18
     -9.86937454156423E-23  -1.34415164495578E-08  -1.34415164513351E-08  -2.88432312609917E-18
      5.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.71832861990426E-19   1.67934220555907E-22
      1.34415314289020E-08   1.34415314292740E-08  -7.79492760561039E-19  -2.55843217376760E-01  -2.55843217376760E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.08764565418011E-16   0.00000000000000E+00  -3.08764565418011E-16
      3.66381540055678E-18  -2.55843217195296E-01  -2.51608423717847E-01   0.00000000000000E+00  -1.11069234163340E-18
     -9.86937522945728E-23  -1.34415311193986E-08  -1.34415311205094E-08  -2.88432263999574E-18
      6.09771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.11743834606392E-19   1.67934127674363E-22
      1.34415417536846E-08   1.34415417539965E-08  -7.79492667247409E-19  -2.55843269482835E-01  -2.55843269482835E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.19252891313223E-16   0.00000000000000E+00  -2.19252891313223E-16
      3.66381496205099E-18  -2.55843268328630E-01  -2.51608471570202E-01   0.00000000000000E+00  -8.26648422073230E-19
     -9.86937571074947E-23  -1.34415415339169E-08  -1.34415415347437E-08  -2.88432229480359E-18
      6.29771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.85172084935276E-19   1.67934062100401E-22
      1.34415490892999E-08   1.34415490894852E-08  -7.79492600910812E-19  -2.55843306521964E-01  -2.55843306521964E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.56054129379443E-16   0.00000000000000E+00  -1.56054129379443E-16
      3.66381464994273E-18  -2.55843304079114E-01  -2.51608504989721E-01   0.00000000000000E+00  -5.41507186454181E-19
     -9.86937604550881E-23  -1.34415489328895E-08  -1.34415489334311E-08  -2.88432204903192E-18
      6.49771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.43329594750247E-19   1.67934015521707E-22
      1.34415542823230E-08   1.34415542824665E-08  -7.79492553863648E-19  -2.55843332806726E-01  -2.55843332806726E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11079077798383E-16   0.00000000000000E+00  -1.11079077798383E-16
      3.66381442778458E-18  -2.55843328948383E-01  -2.51608528208782E-01   0.00000000000000E+00  -3.88027418159333E-19
     -9.86937627737449E-23  -1.34415541709993E-08  -1.34415541713874E-08  -2.88432187392093E-18
      6.69771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   9.07535246493154E-20   1.67933981940218E-22
      1.34415579049464E-08   1.34415579050373E-08  -7.79492520903510E-19  -2.55843351264455E-01  -2.55843351264455E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.84662933580456E-17   0.00000000000000E+00  -7.84662933580456E-17
      3.66381427085199E-18  -2.55843346226281E-01  -2.51608544335114E-01   0.00000000000000E+00  -2.64301374800901E-19
     -9.86937643909078E-23  -1.34415578263066E-08  -1.34415578265710E-08  -2.88432174994848E-18
      6.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   6.62504570546209E-20   1.67933957043121E-22
      1.34415603355739E-08   1.34415603356404E-08  -7.79492498595018E-19  -2.55843363834616E-01  -2.55843363834616E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.39875692972525E-17   0.00000000000000E+00  -5.39875692972525E-17
      3.66381416287686E-18  -2.55843358394582E-01  -2.51608555729945E-01   0.00000000000000E+00  -1.91626132221563E-19
     -9.86937655620860E-23  -1.34415602814611E-08  -1.34415602816528E-08  -2.88432166428184E-18
      7.09771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.80622363622021E-20   1.67933937809977E-22
      1.34415618241165E-08   1.34415618241547E-08  -7.79492484695423E-19  -2.55843371783293E-01  -2.55843371783293E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.46964242522760E-17   0.00000000000000E+00  -3.46964242522760E-17
      3.66381409348401E-18  -2.55843367394865E-01  -2.51608564255197E-01   0.00000000000000E+00  -1.40633854965609E-19
     -9.86937664934636E-23  -1.34415617893176E-08  -1.34415617894583E-08  -2.88432160878858E-18
      7.29771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.98614206656503E-20   1.67933922302964E-22
      1.34415625494567E-08   1.34415625494768E-08  -7.79492477650711E-19  -2.55843375975832E-01  -2.55843375975832E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.87582750996818E-17   0.00000000000000E+00  -1.87582750996818E-17
      3.66381405596746E-18  -2.55843374779268E-01  -2.51608571406072E-01   0.00000000000000E+00  -1.17378069957836E-19
     -9.86937673502798E-23  -1.34415625306010E-08  -1.34415625307185E-08  -2.88432157831675E-18
      7.49771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   2.59332361914292E-21   1.67933909573381E-22
      1.34415626732061E-08   1.34415626732089E-08  -7.79492476122448E-19  -2.55843377131114E-01  -2.55843377131114E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.39632147870716E-18   0.00000000000000E+00  -5.39632147870716E-18
      3.66381404517481E-18  -2.55843381753536E-01  -2.51608578337156E-01   0.00000000000000E+00  -1.14865216183011E-19
     -9.86937682525060E-23  -1.34415626676976E-08  -1.34415626678126E-08  -2.88432156905236E-18
      7.69771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -5.35490236731345E-21   1.67933899620666E-22
      1.34415623895330E-08   1.34415623895278E-08  -7.79492478539601E-19  -2.55843376063002E-01  -2.55843376063002E-01
      0.00000000000000E+00   0.00000000000000E+00   5.12010983630038E-18   0.00000000000000E+00   5.12010983630038E-18
      3.66381405541503E-18  -2.55843389122428E-01  -2.51608585792120E-01   0.00000000000000E+00  -1.19300201920967E-19
     -9.86937692590486E-23  -1.34415623945285E-08  -1.34415623946479E-08  -2.88432157687543E-18
      7.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -1.02891669120579E-20   1.67933893324525E-22
      1.34415619663175E-08   1.34415619663073E-08  -7.79492482711174E-19  -2.55843373892657E-01  -2.55843373892657E-01
      0.00000000000000E+00   0.00000000000000E+00   1.15350115322250E-17   0.00000000000000E+00   1.15350115322250E-17
      3.66381407848505E-18  -2.55843397156100E-01  -2.51608593957118E-01   0.00000000000000E+00  -1.28285391583061E-19
     -9.86937703444864E-23  -1.34415619777140E-08  -1.34415619778424E-08  -2.88432159577388E-18
      8.09771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -4.20637822569021E-21   1.67933892264675E-22
      1.34415617681474E-08   1.34415617681434E-08  -7.79492485576990E-19  -2.55843372193208E-01  -2.55843372193208E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18131218440710E-17   0.00000000000000E+00   1.18131218440710E-17
      3.66381410211130E-18  -2.55843405414103E-01  -2.51608602277476E-01   0.00000000000000E+00  -1.24816043976916E-19
     -9.86937713750249E-23  -1.34415617798316E-08  -1.34415617799565E-08  -2.88432161653431E-18
      8.29771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.17065334881057E-20   1.67933898342442E-22
      1.34415622480212E-08   1.34415622480331E-08  -7.79492483211182E-19  -2.55843373007779E-01  -2.55843373007779E-01
      0.00000000000000E+00   0.00000000000000E+00   3.59527244615240E-18   0.00000000000000E+00   3.59527244615240E-18
      3.66381410930184E-18  -2.55843412588293E-01  -2.51608609303071E-01   0.00000000000000E+00  -9.73026726607053E-20
     -9.86937720941224E-23  -1.34415622515310E-08  -1.34415622516284E-08  -2.88432162609066E-18
      8.49771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   4.12938321555910E-20   1.67933913141367E-22
      1.34415638932175E-08   1.34415638932589E-08  -7.79492471210552E-19  -2.55843378670893E-01  -2.55843378670893E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.50268089655016E-17   0.00000000000000E+00  -1.50268089655016E-17
      3.66381407924823E-18  -2.55843416452761E-01  -2.51608612655072E-01   0.00000000000000E+00  -3.34205894331578E-20
     -9.86937721315911E-23  -1.34415638781986E-08  -1.34415638782321E-08  -2.88432160803768E-18
      8.69771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   8.04094919343137E-20   1.67933937015435E-22
      1.34415671138745E-08   1.34415671139551E-08  -7.79492445583545E-19  -2.55843391369274E-01  -2.55843391369274E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.44078024058693E-17   0.00000000000000E+00  -4.44078024058693E-17
      3.66381399043262E-18  -2.55843414029498E-01  -2.51608609226365E-01   0.00000000000000E+00   7.77923931338952E-20
     -9.86937710513705E-23  -1.34415670696250E-08  -1.34415670695473E-08  -2.88432154484908E-18
      8.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.26394350241598E-19   1.67933967981972E-22
      1.34415720719180E-08   1.34415720720445E-08  -7.79492404186259E-19  -2.55843412411221E-01  -2.55843412411221E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.20179369355732E-17   0.00000000000000E+00  -8.20179369355732E-17
      3.66381382639675E-18  -2.55843402081034E-01  -2.51608595727663E-01   0.00000000000000E+00   2.31780584536021E-19
     -9.86937684510702E-23  -1.34415719902583E-08  -1.34415719900266E-08  -2.88432142221049E-18
      9.09771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.58810895480885E-19   1.67934000619597E-22
      1.34415784647667E-08   1.34415784649256E-08  -7.79492348616153E-19  -2.55843441241560E-01  -2.55843441241560E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21133703009579E-16   0.00000000000000E+00  -1.21133703009579E-16
      3.66381358412934E-18  -2.55843378011393E-01  -2.51608569656205E-01   0.00000000000000E+00   4.22080793186443E-19
     -9.86937641189548E-23  -1.34415783442139E-08  -1.34415783437919E-08  -2.88432123551319E-18
      9.29771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.72534661657224E-19   1.67934025315024E-22
      1.34415853021501E-08   1.34415853023228E-08  -7.79492286270589E-19  -2.55843474343452E-01  -2.55843474343452E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.49970776552117E-16   0.00000000000000E+00  -1.49970776552117E-16
      3.66381328418779E-18  -2.55843341181477E-01  -2.51608530681172E-01   0.00000000000000E+00   6.05970847192932E-19
     -9.86937582388164E-23  -1.34415851529579E-08  -1.34415851523520E-08  -2.88432099791720E-18
      9.49771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.34655311304834E-19   1.67934028336892E-22
      1.34415907434205E-08   1.34415907435553E-08  -7.79492232020688E-19  -2.55843504302677E-01  -2.55843504302677E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51841926736952E-16   0.00000000000000E+00  -1.51841926736952E-16
      3.66381298050393E-18  -2.55843294514483E-01  -2.51608482300424E-01   0.00000000000000E+00   7.25422844502044E-19
     -9.86937516121983E-23  -1.34415905924387E-08  -1.34415905917134E-08  -2.88432074848325E-18
      9.69771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.83201056360378E-20   1.67933993289181E-22
      1.34415920902653E-08   1.34415920903038E-08  -7.79492208691017E-19  -2.55843519449928E-01  -2.55843519449928E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07001765784194E-16   0.00000000000000E+00  -1.07001765784194E-16
      3.66381276650040E-18  -2.55843246086765E-01  -2.51608433434227E-01   0.00000000000000E+00   6.91234133827673E-19
     -9.86937458384797E-23  -1.34415919839931E-08  -1.34415919833020E-08  -2.88432055780939E-18
      9.89771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -1.41049006207883E-19   1.67933904446483E-22
      1.34415860470533E-08   1.34415860469124E-08  -7.79492245347636E-19  -2.55843504604343E-01  -2.55843504604343E-01
      0.00000000000000E+00   0.00000000000000E+00   3.22415878020260E-18   0.00000000000000E+00   3.22415878020260E-18
      3.66381277294872E-18  -2.55843210187519E-01  -2.51608399404222E-01   0.00000000000000E+00   4.06795180486304E-19
     -9.86937433671980E-23  -1.34415860505433E-08  -1.34415860501366E-08  -2.88432052760109E-18
      1.00977190625000E-07
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -3.33618830240080E-19   1.67933752228898E-22
      1.34415693541959E-08   1.34415693538625E-08  -7.79492372396092E-19  -2.55843443457266E-01  -2.55843443457266E-01
      0.00000000000000E+00   0.00000000000000E+00   1.89741431517526E-16   0.00000000000000E+00   1.89741431517526E-16
      3.66381315243158E-18  -2.55843207137745E-01  -2.51608401554946E-01   0.00000000000000E+00  -2.69290505148589E-19
     -9.86937473149018E-23  -1.34415695433345E-08  -1.34415695436039E-08  -2.88432078003549E-18
      1.02977190625000E-07
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -7.00060212661230E-19   1.67933540569393E-22
      1.34415398550305E-08   1.34415398543306E-08  -7.79492612809854E-19  -2.55843322989443E-01  -2.55843322989443E-01
      0.00000000000000E+00   0.00000000000000E+00   4.46754037510988E-16   0.00000000000000E+00   4.46754037510988E-16
      3.66381404593966E-18  -2.55843261054061E-01  -2.51608464684334E-01   0.00000000000000E+00  -1.19991328152049E-18
     -9.86937609403526E-23  -1.34415402998847E-08  -1.34415403010847E-08  -2.88432143312980E-18
      1.04977190625000E-07
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00  -8.19539642871813E-19   1.67933295159036E-22
      1.34414979606881E-08   1.34414979598687E-08  -7.79492969560892E-19  -2.55843139945128E-01  -2.55843139945128E-01
      0.00000000000000E+00   0.00000000000000E+00   7.41870407727586E-16   0.00000000000000E+00   7.41870407727586E-16
      3.66381552968047E-18  -2.55843394826416E-01  -2.51608611563012E-01   0.00000000000000E+00  -2.68346081793917E-18
     -9.86937867053374E-23  -1.34414986990556E-08  -1.34414987017391E-08  -2.88432256011958E-18
      1.06977190625000E-07
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00  -1.21105652609837E-18   1.67933070541950E-22
      1.34414483260516E-08   1.34414483248407E-08  -7.79493410598120E-19  -2.55842908741171E-01  -2.55842908741171E-01
      0.00000000000000E+00   0.00000000000000E+00   1.00774193139246E-15   0.00000000000000E+00   1.00774193139246E-15
      3.66381754516434E-18  -2.55843621953146E-01  -2.51608854243965E-01   0.00000000000000E+00  -3.88838883384872E-18
     -9.86938249276967E-23  -1.34414493286942E-08  -1.34414493325827E-08  -2.88432413456622E-18
      1.08977190625000E-07
      0.00000000000000E+00  -1.34413854455843E-11   0.00000000000000E+00  -1.08885575206178E-18   1.67932953009409E-22
      1.34414013491830E-08   1.34414013480943E-08  -7.79493854433646E-19  -2.55842669300789E-01  -2.55842669300789E-01
      0.00000000000000E+00   0.00000000000000E+00   1.13896778306617E-15   0.00000000000000E+00   1.13896778306617E-15
      3.66381982309990E-18  -2.55843935629207E-01  -2.51609182679337E-01   0.00000000000000E+00  -5.11620686274642E-18
     -9.86938721737312E-23  -1.34414024819458E-08  -1.34414024870621E-08  -2.88432596866626E-18
      1.10977190625000E-07
      0.00000000000000E+00  -1.34413854455843E-11   0.00000000000000E+00  -6.55218391915274E-19   1.67933055379794E-22
      1.34413738936993E-08   1.34413738930442E-08  -7.79494161372924E-19  -2.55842492254856E-01  -2.55842492254856E-01
      0.00000000000000E+00   0.00000000000000E+00   9.98970997983177E-16   0.00000000000000E+00   9.98970997983177E-16
      3.66382182104190E-18  -2.55844296637887E-01  -2.51609552382375E-01   0.00000000000000E+00  -5.44936116252157E-18
     -9.86939197128444E-23  -1.34413748865658E-08  -1.34413748920152E-08  -2.88432765966897E-18
      1.12977190625000E-07
      0.00000000000000E+00  -1.34413854455843E-11   0.00000000000000E+00   9.13243118859406E-19   1.67933499660521E-22
      1.34413884546109E-08   1.34413884555243E-08  -7.79494137149885E-19  -2.55842478002969E-01  -2.55842478002969E-01
      0.00000000000000E+00   0.00000000000000E+00   4.41655972783280E-16   0.00000000000000E+00   4.41655972783280E-16
      3.66382270435385E-18  -2.55844623067961E-01  -2.51609874400556E-01   0.00000000000000E+00  -4.89700883568550E-18
     -9.86939525808169E-23  -1.34413888922832E-08  -1.34413888971803E-08  -2.88432856720396E-18
      1.14977190625000E-07
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   2.70629047854408E-18   1.67934384562227E-22
      1.34414699414134E-08   1.34414699441198E-08  -7.79493556543188E-19  -2.55842745609547E-01  -2.55842745609547E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.48653313298745E-16   0.00000000000000E+00  -6.48653313298745E-16
      3.66382140704722E-18  -2.55844786423499E-01  -2.51610012426361E-01   0.00000000000000E+00  -1.81549478852907E-18
     -9.86939499683348E-23  -1.34414692936509E-08  -1.34414692954665E-08  -2.88432785050403E-18
      1.16977190625000E-07
      0.00000000000000E+00  -1.34416609797960E-11   0.00000000000000E+00   1.04805205441248E-17   1.67935737620741E-22
      1.34416394255734E-08   1.34416394360541E-08  -7.79492213467040E-19  -2.55843407940342E-01  -2.55843407940342E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.29891222299401E-15   0.00000000000000E+00  -2.29891222299401E-15
      3.66381680922277E-18  -2.55844619865222E-01  -2.51609792990159E-01   0.00000000000000E+00  -1.59331023292792E-18
     -9.86938877514644E-23  -1.34416371355485E-08  -1.34416371371419E-08  -2.88432459575573E-18
      1.18977190625000E-07
      0.00000000000000E+00  -1.34419365140076E-11   0.00000000000000E+00   8.46107310631282E-18   1.67937456274310E-22
      1.34419047238332E-08   1.34419047322944E-08  -7.79490000225868E-19  -2.55844531270938E-01  -2.55844531270938E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.37633605288223E-15   0.00000000000000E+00  -4.37633605288223E-15
      3.66380805655067E-18  -2.55843944469737E-01  -2.51609034663932E-01   0.00000000000000E+00   1.12512131626358E-17
     -9.86937438600534E-23  -1.34419003672095E-08  -1.34419003559583E-08  -2.88431805632480E-18
      1.20977190625000E-07
      0.00000000000000E+00  -1.34422120482192E-11   0.00000000000000E+00   2.10656921207846E-17   1.67939249250255E-22
      1.34422485598791E-08   1.34422485809450E-08  -7.79487011053323E-19  -2.55846081382298E-01  -2.55846081382298E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.51839194800009E-15   0.00000000000000E+00  -6.51839194800009E-15
      3.66379501976677E-18  -2.55842617861299E-01  -2.51607600400749E-01   0.00000000000000E+00   1.05852209558825E-17
     -9.86935067614257E-23  -1.34422420731381E-08  -1.34422420625530E-08  -2.88430800871345E-18
      1.22977190625000E-07
      0.00000000000000E+00  -1.34426712719052E-11   0.00000000000000E+00   9.64010812095310E-18   1.67940596484428E-22
      1.34426164617499E-08   1.34426164713902E-08  -7.79483654096381E-19  -2.55847863782826E-01  -2.55847863782826E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.08700333135420E-15   0.00000000000000E+00  -8.08700333135420E-15
      3.66377884576011E-18  -2.55840605310333E-01  -2.51605472431990E-01   0.00000000000000E+00   3.26677483180647E-17
     -9.86931865598586E-23  -1.34426084170545E-08  -1.34426083843869E-08  -2.88429519166372E-18
      1.24977190625000E-07
      0.00000000000000E+00  -1.34429468061169E-11   0.00000000000000E+00   7.79487423836840E-18   1.67940754651113E-22
      1.34429079266978E-08   1.34429079344928E-08  -7.79480741966426E-19  -2.55849473045951E-01  -2.55849473045951E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.17810643000356E-15   0.00000000000000E+00  -8.17810643000356E-15
      3.66376248954725E-18  -2.55838066610761E-01  -2.51602841931228E-01   0.00000000000000E+00   3.86573145186505E-17
     -9.86928269836785E-23  -1.34428997950436E-08  -1.34428997563864E-08  -2.88428174758082E-18
      1.26977190625000E-07
      0.00000000000000E+00  -1.34429468061169E-11   0.00000000000000E+00   7.17751142162424E-18   1.67938836866403E-22
      1.34429761640038E-08   1.34429761711815E-08  -7.79479516919829E-19  -2.55850273812487E-01  -2.55850273812487E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.72333783196430E-15   0.00000000000000E+00  -5.72333783196430E-15
      3.66375104287158E-18  -2.55835441877867E-01  -2.51600194925295E-01   0.00000000000000E+00   3.20668726751051E-17
     -9.86925150970400E-23  -1.34429704799104E-08  -1.34429704478437E-08  -2.88427152595175E-18
      1.28977190625000E-07
      0.00000000000000E+00  -1.34426712719052E-11   0.00000000000000E+00   6.30734161579590E-17   1.67933995123237E-22
      1.34426423611039E-08   1.34426424241775E-08  -7.79481556584839E-19  -2.55849441844343E-01  -2.55849441844343E-01
      0.00000000000000E+00   0.00000000000000E+00   2.84702345042305E-16   0.00000000000000E+00   2.84702345042305E-16
      3.66375161227627E-18  -2.55833508300529E-01  -2.51598364622691E-01   0.00000000000000E+00  -4.90806082014449E-17
     -9.86923839811340E-23  -1.34426426597991E-08  -1.34426427088798E-08  -2.88427005569144E-18
      1.30977190625000E-07
      0.00000000000000E+00  -1.34417528245332E-11   0.00000000000000E+00   3.22679851046556E-17   1.67925717344372E-22
      1.34417302765202E-08   1.34417303087884E-08  -7.79488507007425E-19  -2.55846093910654E-01  -2.55846093910654E-01
      0.00000000000000E+00   0.00000000000000E+00   1.04286286452651E-14   0.00000000000000E+00   1.04286286452651E-14
      3.66377246953356E-18  -2.55833369114390E-01  -2.51598509602653E-01   0.00000000000000E+00  -6.62782191509104E-17
     -9.86926026616096E-23  -1.34417406711387E-08  -1.34417407374171E-08  -2.88428396252614E-18
      1.32977190625000E-07
      0.00000000000000E+00  -1.34400996192634E-11   0.00000000000000E+00   4.25753307032029E-16   1.67914229083199E-22
      1.34401241539554E-08   1.34401245797089E-08  -7.79501604159125E-19  -2.55839528768713E-01  -2.55839528768713E-01
      0.00000000000000E+00   0.00000000000000E+00   2.43799441983162E-14   0.00000000000000E+00   2.43799441983162E-14
      3.66382122942196E-18  -2.55836331054100E-01  -2.51601973173788E-01   0.00000000000000E+00  -5.33341212726721E-16
     -9.86933474060979E-23  -1.34401484263118E-08  -1.34401489596531E-08  -2.88431962526283E-18
      1.34977190625000E-07
      0.00000000000000E+00  -1.34378953455704E-11   0.00000000000000E+00   4.48713659808410E-17   1.67900933868397E-22
      1.34378488190234E-08   1.34378488638950E-08  -7.79520993189928E-19  -2.55829577956553E-01  -2.55829577956553E-01
      0.00000000000000E+00   0.00000000000000E+00   4.03643420708293E-14   0.00000000000000E+00   4.03643420708293E-14
      3.66390195810610E-18  -2.55843629484766E-01  -2.51609983439525E-01   0.00000000000000E+00  -2.38154725266901E-16
     -9.86947505415826E-23  -1.34378889900822E-08  -1.34378892282370E-08  -2.88438096491617E-18
      1.36977190625000E-07
      0.00000000000000E+00  -1.34351400034542E-11   0.00000000000000E+00   5.37992369728276E-16   1.67888808434714E-22
      1.34351591705465E-08   1.34351597085390E-08  -7.79544911481028E-19  -2.55817035923748E-01  -2.55817035923748E-01
      0.00000000000000E+00   0.00000000000000E+00   5.47112802847637E-14   0.00000000000000E+00   5.47112802847637E-14
      3.66401138066667E-18  -2.55855985790972E-01  -2.51623182631430E-01   0.00000000000000E+00  -8.30994673348085E-16
     -9.86968273996002E-23  -1.34352135888246E-08  -1.34352144198193E-08  -2.88446646918564E-18
      1.38977190625000E-07
      0.00000000000000E+00  -1.34325683508124E-11   0.00000000000000E+00  -6.18587165425452E-17   1.67882538708534E-22
      1.34326228420090E-08   1.34326227801504E-08  -7.79568910517577E-19  -2.55804083117842E-01  -2.55804083117842E-01
      0.00000000000000E+00   0.00000000000000E+00   6.16857814202394E-14   0.00000000000000E+00   6.16857814202394E-14
      3.66413475222951E-18  -2.55873013304018E-01  -2.51641007049973E-01   0.00000000000000E+00  -2.78165078036508E-16
     -9.86993888514256E-23  -1.34326841877667E-08  -1.34326844659318E-08  -2.88456584171193E-18
      1.40977190625000E-07
      0.00000000000000E+00  -1.34311906797543E-11   0.00000000000000E+00  -3.39432538740210E-17   1.67888255744920E-22
      1.34311560102340E-08   1.34311559762909E-08  -7.79585386958071E-19  -2.55794565004312E-01  -2.55794565004312E-01
      0.00000000000000E+00   0.00000000000000E+00   5.38809627722927E-14   0.00000000000000E+00   5.38809627722927E-14
      3.66424251415506E-18  -2.55892564753056E-01  -2.51661023104207E-01   0.00000000000000E+00  -2.96561005672629E-16
     -9.87019584277275E-23  -1.34312095606925E-08  -1.34312098572536E-08  -2.88465712719699E-18
      1.42977190625000E-07
      0.00000000000000E+00  -1.34320172823892E-11   0.00000000000000E+00   6.91035773832570E-16   1.67912570801749E-22
      1.34319788683305E-08   1.34319795593664E-08  -7.79583789400780E-19  -2.55793935970659E-01  -2.55793935970659E-01
      0.00000000000000E+00   0.00000000000000E+00   2.33906322334678E-14   0.00000000000000E+00   2.33906322334678E-14
      3.66428929541952E-18  -2.55910177403734E-01  -2.51678386115683E-01   0.00000000000000E+00  -9.04358677442398E-16
     -9.87037218904738E-23  -1.34320020456399E-08  -1.34320029499986E-08  -2.88470550601875E-18
      1.44977190625000E-07
      0.00000000000000E+00  -1.34364258297751E-11   0.00000000000000E+00   5.41731861917235E-16   1.67960798606491E-22
      1.34364397308161E-08   1.34364402725481E-08  -7.79551922132954E-19  -2.55808645817861E-01  -2.55808645817861E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.60030595342153E-14   0.00000000000000E+00  -3.60030595342153E-14
      3.66421728930046E-18  -2.55918867451423E-01  -2.51685689435990E-01   0.00000000000000E+00  -4.93672701342355E-16
     -9.87035498591500E-23  -1.34364037758158E-08  -1.34364042694886E-08  -2.88466536716750E-18
      1.46977190625000E-07
      0.00000000000000E+00  -1.34457021482331E-11   0.00000000000000E+00   4.64708330712893E-16   1.68034345316702E-22
      1.34456753413824E-08   1.34456758060909E-08  -7.79478677328106E-19  -2.55844783039931E-01  -2.55844783039931E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25672835460353E-13   0.00000000000000E+00  -1.25672835460353E-13
      3.66396594362954E-18  -2.55909583465120E-01  -2.51673523919847E-01   0.00000000000000E+00   2.21957228290956E-17
     -9.87001362929277E-23  -1.34455501554511E-08  -1.34455501332554E-08  -2.88448726630143E-18
      1.48977190625000E-07
      0.00000000000000E+00  -1.34601217719747E-11   0.00000000000000E+00   2.22126021104853E-15   1.68127504466465E-22
      1.34601010225038E-08   1.34601032437641E-08  -7.79358343283151E-19  -2.55905877158221E-01  -2.55905877158221E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.38296477493246E-13   0.00000000000000E+00  -2.38296477493246E-13
      3.66348935067455E-18  -2.55872635265423E-01  -2.51632066225458E-01   0.00000000000000E+00  -1.16498342712021E-15
     -9.86922878901016E-23  -1.34598637823031E-08  -1.34598649472866E-08  -2.88413100739140E-18
      1.50977190625000E-07
      0.00000000000000E+00  -1.34787662536278E-11   0.00000000000000E+00   4.64057929538476E-16   1.68224296141040E-22
      1.34787713833309E-08   1.34787718473890E-08  -7.79196216954952E-19  -2.55989976804298E-01  -2.55989976804298E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.54094238290708E-13   0.00000000000000E+00  -3.54094238290708E-13
      3.66278116219797E-18  -2.55800330503713E-01  -2.51553915630099E-01   0.00000000000000E+00   1.26914703186184E-15
     -9.86793958221944E-23  -1.34784190222976E-08  -1.34784177531507E-08  -2.88358494524302E-18
      1.51477190625000E-07
      0.00000000000000E+00  -1.34837258694370E-11   0.00000000000000E+00   4.88235352132958E-16   1.68248418442407E-22
      1.34836856240231E-08   1.34836861122586E-08  -7.79153204800641E-19  -2.56012384322656E-01  -2.56012384322656E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.82894270551321E-13   0.00000000000000E+00  -3.82894270551321E-13
      3.66258971506269E-18  -2.55779933983520E-01  -2.51531979893338E-01   0.00000000000000E+00   1.41157620563137E-15
     -9.86758493112936E-23  -1.34833046295642E-08  -1.34833032179881E-08  -2.88343651026205E-18
      1.52152190625000E-07
      0.00000000000000E+00  -1.34907060694648E-11   0.00000000000000E+00   5.15616202417598E-16   1.68279980043816E-22
      1.34906913102679E-08   1.34906918258842E-08  -7.79091130556794E-19  -2.56044924122524E-01  -2.56044924122524E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.20385436050773E-13   0.00000000000000E+00  -4.20385436050773E-13
      3.66230595489336E-18  -2.55747951026252E-01  -2.51497801522018E-01   0.00000000000000E+00   1.60989690767503E-15
     -9.86704684382906E-23  -1.34902730503450E-08  -1.34902714404482E-08  -2.88321482433656E-18
      1.53063440625000E-07
      0.00000000000000E+00  -1.35005334563460E-11   0.00000000000000E+00   5.59519874627879E-16   1.68318045848843E-22
      1.35005527392124E-08   1.35005532987325E-08  -7.79002040898585E-19  -2.56092074479139E-01  -2.56092074479139E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.65160157398051E-13   0.00000000000000E+00  -4.65160157398051E-13
      3.66188207769993E-18  -2.55696376765156E-01  -2.51443134403468E-01   0.00000000000000E+00   1.85279627395626E-15
     -9.86621600875337E-23  -1.35000899913713E-08  -1.35000881385751E-08  -2.88288003680134E-18
      1.54293628125000E-07
      0.00000000000000E+00  -1.35135754090294E-11   0.00000000000000E+00   5.22419203526049E-16   1.68352467402599E-22
      1.35135679285126E-08   1.35135684509320E-08  -7.78880164724304E-19  -2.56157672690066E-01  -2.56157672690065E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.04342463628166E-13   0.00000000000000E+00  -5.04342463628166E-13
      3.66126164190545E-18  -2.55611973546294E-01  -2.51354642929532E-01   0.00000000000000E+00   2.19848995913505E-15
     -9.86493641270325E-23  -1.35130663069582E-08  -1.35130641084683E-08  -2.88238147718115E-18
      1.55954381250000E-07
      0.00000000000000E+00  -1.35267092064501E-11   0.00000000000000E+00   4.75586816700950E-16   1.68340508513147E-22
      1.35266693909567E-08   1.35266698665437E-08  -7.78744640423751E-19  -2.56233739325007E-01  -2.56233739325006E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.84961841802161E-13   0.00000000000000E+00  -4.84961841802161E-13
      3.66045624001117E-18  -2.55478680968937E-01  -2.51217216450752E-01   0.00000000000000E+00   2.36632768193588E-15
     -9.86310626141159E-23  -1.35261872710295E-08  -1.35261849047019E-08  -2.88171159958743E-18
      1.57954381250000E-07
      0.00000000000000E+00  -1.35263418275013E-11   0.00000000000000E+00  -7.25295007181185E-18   1.68186608365784E-22
      1.35263440483742E-08   1.35263440411214E-08  -7.78705127983352E-19  -2.56265284036670E-01  -2.56265284036669E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90431447075726E-13   0.00000000000000E+00  -2.90431447075726E-13
      3.65987537711702E-18  -2.55321672693850E-01  -2.51060249344437E-01   0.00000000000000E+00   2.17809939620606E-15
     -9.86135268818551E-23  -1.35260557877736E-08  -1.35260536096743E-08  -2.88117024913367E-18
      1.59954381250000E-07
      0.00000000000000E+00  -1.34986965616018E-11   0.00000000000000E+00  -6.86107654257755E-16   1.67844151262790E-22
      1.34986749194765E-08   1.34986742333690E-08  -7.78889179875371E-19  -2.56184345995261E-01  -2.56184345995262E-01
      0.00000000000000E+00   0.00000000000000E+00   1.33985867122743E-13   0.00000000000000E+00   1.33985867122743E-13
      3.66014334885127E-18  -2.55220868905920E-01  -2.50968029268839E-01   0.00000000000000E+00   1.01759589906072E-15
     -9.86092882234616E-23  -1.34988092368320E-08  -1.34988082192362E-08  -2.88125416897590E-18
      1.61954381250000E-07
      0.00000000000000E+00  -1.34333031087101E-11   0.00000000000000E+00   6.08322213718409E-15   1.67288672118629E-22
      1.34333348094020E-08   1.34333408926243E-08  -7.79396167042742E-19  -2.55937228525089E-01  -2.55937228525090E-01
      0.00000000000000E+00   0.00000000000000E+00   8.15074214392307E-13   0.00000000000000E+00   8.15074214392307E-13
      3.66177349728005E-18  -2.55247936749491E-01  -2.51015468636355E-01   0.00000000000000E+00  -9.07072514712137E-15
     -9.86290811422206E-23  -1.34341468961134E-08  -1.34341559668387E-08  -2.88237733023731E-18
      1.63954381250000E-07
      0.00000000000000E+00  -1.33249263188052E-11   0.00000000000000E+00   7.51171392543208E-14   1.66544747377932E-22
      1.33249233136091E-08   1.33249984307486E-08  -7.80292853029594E-19  -2.55485193416081E-01  -2.55485193416083E-01
      0.00000000000000E+00   0.00000000000000E+00   1.71621932067421E-12   0.00000000000000E+00   1.71621932067421E-12
      3.66520593592140E-18  -2.55483667290454E-01  -2.51285071470685E-01   0.00000000000000E+00  -8.34665185890354E-14
     -9.86834138083412E-23  -1.33266311835505E-08  -1.33267146500692E-08  -2.88491308289181E-18
      1.65954381250000E-07
      0.00000000000000E+00  -1.31782502734848E-11   0.00000000000000E+00   1.86644367406745E-14   1.65713655393170E-22
      1.31782099764410E-08   1.31782286408779E-08  -7.81568607493484E-19  -2.54827620062536E-01  -2.54827620062539E-01
      0.00000000000000E+00   0.00000000000000E+00   2.70384798688002E-12   0.00000000000000E+00   2.70384798688002E-12
      3.67061363189516E-18  -2.55998185882192E-01  -2.51845502693361E-01   0.00000000000000E+00  -3.20074477086516E-14
     -9.87794146245556E-23  -1.31809004814169E-08  -1.31809324888648E-08  -2.88904502440168E-18
      1.67954381250000E-07
      0.00000000000000E+00  -1.30132052807228E-11   0.00000000000000E+00   1.21198671717232E-13   1.64997181369067E-22
      1.30131787576543E-08   1.30132999563262E-08  -7.83081978588143E-19  -2.54030090200384E-01  -2.54030090200388E-01
      0.00000000000000E+00   0.00000000000000E+00   3.52108743609872E-12   0.00000000000000E+00   3.52108743609872E-12
      3.67765580676736E-18  -2.56821798495392E-01  -2.52720852772911E-01   0.00000000000000E+00  -1.41910590828673E-13
     -9.89148332755555E-23  -1.30166791331714E-08  -1.30168210437623E-08  -2.89457382817922E-18
      1.69954381250000E-07
      0.00000000000000E+00  -1.28692845775186E-11   0.00000000000000E+00  -3.26892043950043E-15   1.64712567295893E-22
      1.28692873198184E-08   1.28692840508982E-08  -7.84512933484826E-19  -2.53250656334814E-01  -2.53250656334818E-01
      0.00000000000000E+00   0.00000000000000E+00   3.78504564290761E-12   0.00000000000000E+00   3.78504564290761E-12
      3.68522589805317E-18  -2.57908154215583E-01  -2.53852460251743E-01   0.00000000000000E+00  -1.82485684224729E-14
     -9.90751198046713E-23  -1.28730508479726E-08  -1.28730690965411E-08  -2.90071296456835E-18
      1.71954381250000E-07
      0.00000000000000E+00  -1.28054524851594E-11   0.00000000000000E+00   3.43465088257703E-14   1.65267226558351E-22
      1.28054478330771E-08   1.28054821795861E-08  -7.85341228471519E-19  -2.52753632856817E-01  -2.52753632856820E-01
      0.00000000000000E+00   0.00000000000000E+00   3.02347181353940E-12   0.00000000000000E+00   3.02347181353940E-12
      3.69127284168025E-18  -2.59098129827484E-01  -2.55062789477639E-01   0.00000000000000E+00  -5.63304820080381E-14
     -9.92252898416277E-23  -1.28084493209176E-08  -1.28085056513997E-08  -2.90593161320873E-18
      1.73954381250000E-07
      0.00000000000000E+00  -1.28963787749949E-11   0.00000000000000E+00   1.95575158634751E-13   1.67085322060403E-22
      1.28963783288358E-08   1.28965739039946E-08  -7.84882912832546E-19  -2.52894722612951E-01  -2.52894722612952E-01
      0.00000000000000E+00   0.00000000000000E+00   7.72596867154640E-13   0.00000000000000E+00   7.72596867154640E-13
      3.69281803541456E-18  -2.60091366462717E-01  -2.56028086746225E-01   0.00000000000000E+00  -2.07631521440466E-13
     -9.93116215781419E-23  -1.28971388693402E-08  -1.28973465008617E-08  -2.90793512258201E-18
      1.75954381250000E-07
      0.00000000000000E+00  -1.32228868157676E-11   0.00000000000000E+00   8.09828724031151E-15   1.70447110476992E-22
      1.32228307188756E-08   1.32228388171630E-08  -7.82410451525131E-19  -2.54063407435591E-01  -2.54063407435588E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.27081725561906E-12   0.00000000000000E+00  -3.27081725561906E-12
      3.68627640090332E-18  -2.60437088079406E-01  -2.56272230296100E-01   0.00000000000000E+00   2.61976942995405E-16
     -9.92643149639309E-23  -1.32195682618843E-08  -1.32195679999074E-08  -2.90386594937819E-18
      1.77954381250000E-07
      0.00000000000000E+00  -1.38536764709089E-11   0.00000000000000E+00   9.54786203076796E-13   1.75255738877343E-22
      1.38537307989473E-08   1.38546855851506E-08  -7.77363830229770E-19  -2.56576218693015E-01  -2.56576218693006E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.04529642495032E-12   0.00000000000000E+00  -9.04529642495032E-12
      3.66818580805342E-18  -2.59559409718430E-01  -2.55197598438975E-01   0.00000000000000E+00  -9.28381554233349E-13
     -9.90048343487124E-23  -1.38447119071713E-08  -1.38456402887256E-08  -2.89082197782365E-18
      1.79954381250000E-07
      0.00000000000000E+00  -1.48198831063321E-11   0.00000000000000E+00   2.37893964601828E-14   1.80804426347641E-22
      1.48198399272925E-08   1.48198637166892E-08  -7.69628884091545E-19  -2.60531993194954E-01  -2.60531993194938E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59262254204316E-11   0.00000000000000E+00  -1.59262254204316E-11
      3.63633335721256E-18  -2.56832913451150E-01  -2.52168886768895E-01   0.00000000000000E+00   4.97376013063974E-14
     -9.84691575130430E-23  -1.48039872288699E-08  -1.48039374912687E-08  -2.86670447312102E-18
      1.81954381250000E-07
      0.00000000000000E+00  -1.60664917244499E-11   0.00000000000000E+00   3.09434082932884E-14   1.85680541741174E-22
      1.60664800695560E-08   1.60665110129644E-08  -7.59790512566484E-19  -2.65671244807931E-01  -2.65671244807909E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.25947753770197E-11   0.00000000000000E+00  -2.25947753770197E-11
      3.59114380645852E-18  -2.51748329977600E-01  -2.46693633959723E-01   0.00000000000000E+00   8.02784609262735E-14
     -9.76180568343814E-23  -1.60439965160482E-08  -1.60439162375874E-08  -2.83135329389204E-18
      1.83954381250000E-07
      0.00000000000000E+00  -1.73957606060544E-11   0.00000000000000E+00   3.30656934104420E-14   1.87975579239790E-22
      1.73957111101873E-08   1.73957441758809E-08  -7.49337445340363E-19  -2.71261582362237E-01  -2.71261582362210E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.70007097461001E-11   0.00000000000000E+00  -2.70007097461001E-11
      3.53714238696632E-18  -2.44187429327847E-01  -2.38715327510457E-01   0.00000000000000E+00   1.06747816116536E-13
     -9.64852436155119E-23  -1.73688502139508E-08  -1.73687434661348E-08  -2.78780494162596E-18
      1.85954381250000E-07
      0.00000000000000E+00  -1.84012767890024E-11   0.00000000000000E+00   2.49781974377805E-14   1.85732978963866E-22
      1.84012213533413E-08   1.84012463315389E-08  -7.40817124288817E-19  -2.76014367855734E-01  -2.76014367855707E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.63758561394425E-11   0.00000000000000E+00  -2.63758561394425E-11
      3.48439067468744E-18  -2.34819609986036E-01  -2.29030507664988E-01   0.00000000000000E+00   1.20513685103006E-13
     -9.52209046415711E-23  -1.83749909890844E-08  -1.83748704753994E-08  -2.74357355039862E-18
      1.87954381250000E-07
      0.00000000000000E+00  -1.84566591655385E-11   0.00000000000000E+00   1.41992440880787E-15   1.77429113305665E-22
      1.84566725405707E-08   1.84566739604953E-08  -7.38003697834482E-19  -2.78002870179259E-01  -2.78002870179241E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.72836911150366E-11   0.00000000000000E+00  -1.72836911150366E-11
      3.44982329245736E-18  -2.25514095775069E-01  -2.19704653869311E-01   0.00000000000000E+00   1.11725382622058E-13
     -9.41464765770931E-23  -1.84395019947628E-08  -1.84393902693803E-08  -2.71181959462288E-18
      1.89954381250000E-07
      0.00000000000000E+00  -1.68745417224017E-11   0.00000000000000E+00  -3.91563970704619E-14   1.61999361362949E-22
      1.68745811186868E-08   1.68745419622899E-08  -7.45962211042967E-19  -2.74621238929520E-01  -2.74621238929524E-01
      0.00000000000000E+00   0.00000000000000E+00   3.85258807769046E-12   0.00000000000000E+00   3.85258807769046E-12
      3.45752846861274E-18  -2.19435583732443E-01  -2.14117939988891E-01   0.00000000000000E+00   6.83812880052309E-14
     -9.37671264419084E-23  -1.68784629316555E-08  -1.68783945503676E-08  -2.71156625756978E-18
      1.91954381250000E-07
      0.00000000000000E+00  -1.33582659584115E-11   0.00000000000000E+00  -5.03434360479930E-14   1.37728389851081E-22
      1.33583313125163E-08   1.33582809690804E-08  -7.70609091318594E-19  -2.62768508589115E-01  -2.62768508589154E-01
      0.00000000000000E+00   0.00000000000000E+00   3.87637214552617E-11   0.00000000000000E+00   3.87637214552617E-11
      3.53505591152327E-18  -2.20259336446744E-01  -2.16038534381002E-01   0.00000000000000E+00  -6.72112874753478E-14
     -9.46899589322525E-23  -1.33969774792480E-08  -1.33970446905356E-08  -2.76444682020467E-18
      1.93954381250000E-07
      0.00000000000000E+00  -8.57508388938073E-12   0.00000000000000E+00  -1.15665928965771E-13   1.01240433187271E-22
      8.57519611404069E-09   8.57508044811183E-09  -8.17534434986432E-19  -2.39450809440968E-01  -2.39450809441052E-01
      0.00000000000000E+00   0.00000000000000E+00   8.39973543346379E-11   0.00000000000000E+00   8.39973543346379E-11
      3.70305062019254E-18  -2.30289443478886E-01  -2.27561370176391E-01   0.00000000000000E+00  -2.22025068219466E-13
     -9.74170472610117E-23  -8.65885577737815E-09  -8.65907780244646E-09  -2.88551618520611E-18
      1.95954381250000E-07
      0.00000000000000E+00  -4.13898308225719E-12   0.00000000000000E+00  -1.10853726583013E-13   5.21317560408011E-23
      4.13905781149426E-09   4.13894695776773E-09  -8.90496964183469E-19  -2.02859537953854E-01  -2.02859537953983E-01
      0.00000000000000E+00   0.00000000000000E+00   1.29114919569752E-10   0.00000000000000E+00   1.29114919569752E-10
      3.96128045933205E-18  -2.48655236078158E-01  -2.47310582262757E-01   0.00000000000000E+00  -5.26378801627542E-13
     -1.01896025452221E-22  -4.26753549853574E-09  -4.26806187733747E-09  -3.07078349514858E-18
      1.97954381250000E-07
      0.00000000000000E+00  -1.41312312667501E-12   0.00000000000000E+00  -7.21867924991408E-14   1.41927842068121E-24
      1.41320217186126E-09   1.41312998506876E-09  -9.89722474120930E-19  -1.53764028553463E-01  -1.53764028553624E-01
      0.00000000000000E+00   0.00000000000000E+00   1.61273611161506E-10   0.00000000000000E+00   1.61273611161506E-10
      4.28382768165506E-18  -2.71876355171661E-01  -2.71380345693650E-01   0.00000000000000E+00  -9.20697796834601E-13
     -1.08142719576682E-22  -1.57348289843333E-09  -1.57440359623027E-09  -3.29410520753413E-18
      1.99954381250000E-07
      0.00000000000000E+00  -3.45519901374716E-13   0.00000000000000E+00  -2.96831370314749E-14  -3.05174814450974E-23
      3.45532996245947E-10   3.45503313108885E-10  -1.10466795265322E-18  -9.81007319320037E-02  -9.81007319321744E-02
      0.00000000000000E+00   0.00000000000000E+00   1.70706488133405E-10   0.00000000000000E+00   1.70706488133405E-10
      4.62524065792187E-18  -2.96671415954625E-01  -2.96508788517186E-01   0.00000000000000E+00  -1.27852527140627E-12
     -1.15232571546191E-22  -5.14931275970769E-10  -5.16209801242291E-10  -3.52057270526865E-18
      2.01954381250000E-07
      0.00000000000000E+00  -9.46919240609601E-14   0.00000000000000E+00  -9.20111397864258E-15  -4.00490462127223E-23
      9.47158488762577E-11   9.47066477622390E-11  -1.19734367762626E-18  -5.37253428738088E-02  -5.37253428739500E-02
      0.00000000000000E+00   0.00000000000000E+00   1.41253663540296E-10   0.00000000000000E+00   1.41253663540296E-10
      4.90774798500246E-18  -3.21494401864059E-01  -3.21420065052902E-01   0.00000000000000E+00  -1.26439079718886E-12
     -1.21584451228626E-22  -2.34695920505224E-10  -2.35960311302534E-10  -3.71040430737620E-18
      2.03954381250000E-07
      0.00000000000000E+00  -6.87917081684375E-14   0.00000000000000E+00  -1.98636538059891E-15  -4.08906426524228E-23
      6.87704530061902E-11   6.87684666407687E-11  -1.24558377454165E-18  -3.13831330736452E-02  -3.13831330737377E-02
      0.00000000000000E+00   0.00000000000000E+00   9.24703221151323E-11   0.00000000000000E+00   9.24703221151323E-11
      5.09268862923272E-18  -3.45939478355489E-01  -3.45888682356751E-01   0.00000000000000E+00  -8.77380264978501E-13
     -1.25728815907344E-22  -1.60361408490798E-10  -1.61238788755902E-10  -3.84710485469107E-18
      2.05954381250000E-07
      0.00000000000000E+00  -8.43134687565096E-14   0.00000000000000E+00  -3.27676503481540E-16  -3.78864128200026E-23
      8.43046394459622E-11   8.43043117694208E-11  -1.26344150203194E-18  -2.35195071478756E-02  -2.35195071479336E-02
      0.00000000000000E+00   0.00000000000000E+00   5.80055668369363E-11   0.00000000000000E+00   5.80055668369363E-11
      5.20869976290660E-18  -3.69916872757389E-01  -3.69872040528991E-01   0.00000000000000E+00  -5.87309343312213E-13
     -1.28400515307186E-22  -1.41722569262916E-10  -1.42309878606357E-10  -3.94525826087466E-18
      2.07954381250000E-07
      0.00000000000000E+00  -1.15173300458239E-13   0.00000000000000E+00   1.20839734929917E-15  -2.96981346388015E-23
      1.15204900618262E-10   1.15206109015581E-10  -1.26232601881146E-18  -2.39338053962195E-02  -2.39338053962551E-02
      0.00000000000000E+00   0.00000000000000E+00   3.55571723837570E-11   0.00000000000000E+00   3.55571723837570E-11
      5.27981410767411E-18  -3.93468384423677E-01  -3.93420889935453E-01   0.00000000000000E+00  -4.31322725307743E-13
     -1.30312782519270E-22  -1.50331958673899E-10  -1.50763281399337E-10  -4.01748808886265E-18
      2.09954381250000E-07
      0.00000000000000E+00  -1.82862871780186E-13   0.00000000000000E+00   2.72378546708914E-15  -7.85297967156514E-24
      1.82888822136733E-10   1.82891545922192E-10  -1.24077023114950E-18  -3.29120400296233E-02  -3.29120400296366E-02
      0.00000000000000E+00   0.00000000000000E+00   1.32447001875853E-11   0.00000000000000E+00   1.32447001875853E-11
      5.30630350804928E-18  -4.16533329497352E-01  -4.16471542103159E-01   0.00000000000000E+00  -2.36362944691939E-13
     -1.31335331075174E-22  -1.95899883164954E-10  -1.96136246109778E-10  -4.06553327689978E-18
      2.11954381250000E-07
      0.00000000000000E+00  -3.63797004079013E-13   0.00000000000000E+00   6.24043780241470E-15   5.00288204792245E-23
      3.63754122611196E-10   3.63760363049049E-10  -1.19065923446264E-18  -5.34513138412230E-02  -5.34513138412073E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.57644369963958E-11   0.00000000000000E+00  -1.57644369963958E-11
      5.27477463405649E-18  -4.38868922382193E-01  -4.38759296446993E-01   0.00000000000000E+00   6.27030107159029E-14
     -1.31032786111736E-22  -3.48058629063237E-10  -3.47995926052653E-10  -4.08411539959386E-18
      2.13954381250000E-07
      0.00000000000000E+00  -7.88119689977787E-13   0.00000000000000E+00   1.28048262586325E-14   1.48295262568055E-22
      7.88081835852460E-10   7.88094640678867E-10  -1.12113110616322E-18  -8.10547663010223E-02  -8.10547663009831E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.92000352724956E-11   0.00000000000000E+00  -3.92000352724956E-11
      5.19637456351150E-18  -4.59987278858578E-01  -4.59751361083844E-01   0.00000000000000E+00   2.09467140249739E-13
     -1.30071058569309E-22  -7.49104072546492E-10  -7.48894605406372E-10  -4.07524345734828E-18
      2.15954381250000E-07
      0.00000000000000E+00  -1.64842934340069E-12   0.00000000000000E+00   2.29533183103953E-14   2.47504080554529E-22
      1.64842078404054E-09   1.64844373735910E-09  -1.04857818454276E-18  -1.10098437721686E-01  -1.10098437721633E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.36902462696634E-11   0.00000000000000E+00  -5.36902462696634E-11
      5.08899407097217E-18  -4.79043751472137E-01  -4.78541367707258E-01   0.00000000000000E+00   1.91876849665059E-13
     -1.29162086940106E-22  -1.59494536793897E-09  -1.59475349108944E-09  -4.04041588642941E-18
      2.17954381250000E-07
      0.00000000000000E+00  -3.20427919169619E-12   0.00000000000000E+00   3.98492231529361E-14   3.16966697732074E-22
      3.20419858126572E-09   3.20423843048919E-09  -9.81328555640491E-19  -1.38878265829295E-01  -1.38878265829228E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.66213495731156E-11   0.00000000000000E+00  -6.66213495731156E-11
      4.95575137182594E-18  -4.94725867598038E-01  -4.93737442780134E-01   0.00000000000000E+00   1.50646844248417E-13
     -1.28392125829914E-22  -3.13776772776019E-09  -3.13761708091607E-09  -3.97442281618545E-18
      2.19954381250000E-07
      0.00000000000000E+00  -5.72321295434982E-12   0.00000000000000E+00   6.33981584191104E-14   3.60361618664367E-22
      5.72311342765989E-09   5.72317682581867E-09  -9.21321673058104E-19  -1.67166896133798E-01  -1.67166896133716E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.15215129317016E-11   0.00000000000000E+00  -8.15215129317016E-11
      4.79270834596254E-18  -5.05235697203942E-01  -5.03458433438999E-01   0.00000000000000E+00   1.37537879787890E-13
     -1.27615704166167E-22  -5.64179285076663E-09  -5.64165531288697E-09  -3.87138667290443E-18
      2.21954381250000E-07
      0.00000000000000E+00  -9.40444186636470E-12   0.00000000000000E+00   9.19101631944691E-14   3.85368077349219E-22
      9.40438662385341E-09   9.40447853401699E-09  -8.67521904962244E-19  -1.94902688655239E-01  -1.94902688655141E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.75326960470405E-11   0.00000000000000E+00  -9.75326960470405E-11
      4.59764295386846E-18  -5.08421883676863E-01  -5.05489947384652E-01   0.00000000000000E+00   1.77330245613480E-13
     -1.26574489493945E-22  -9.30712316821543E-09  -9.30694583796994E-09  -3.73012104890621E-18
      2.23954381250000E-07
      0.00000000000000E+00  -1.44027243099355E-11   0.00000000000000E+00   1.24304882599710E-13   3.94770023115001E-22
      1.44025667782771E-08   1.44026910831601E-08  -8.17908957337987E-19  -2.22071374244682E-01  -2.22071374244570E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12481023598844E-10   0.00000000000000E+00  -1.12481023598844E-10
      4.37268090667077E-18  -5.01868267414378E-01  -4.97366438872883E-01   0.00000000000000E+00   2.99219371927553E-13
     -1.24860475475843E-22  -1.42905092789331E-08  -1.42902100595613E-08  -3.55477194933278E-18
      2.25954381250000E-07
      0.00000000000000E+00  -2.09042295673819E-11   0.00000000000000E+00   1.61394670456858E-13   3.88394300792047E-22
      2.09040306926601E-08   2.09041920873309E-08  -7.70652957994577E-19  -2.48678950398178E-01  -2.48678950398053E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24941478138042E-10   0.00000000000000E+00  -1.24941478138042E-10
      4.12279795039469E-18  -4.82834556644549E-01  -4.76288421985275E-01   0.00000000000000E+00   5.13893383475883E-13
     -1.21963750204175E-22  -2.07797645025763E-08  -2.07792506091929E-08  -3.35214499240011E-18
      2.27954381250000E-07
      0.00000000000000E+00  -2.91281910264183E-11   0.00000000000000E+00   2.04028182726598E-13   3.64454329245993E-22
      2.91279930833884E-08   2.91281971115715E-08  -7.24472088942185E-19  -2.74737267187367E-01  -2.74737267187232E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.35013638724053E-10   0.00000000000000E+00  -1.35013638724053E-10
      3.85277067294658E-18  -4.48194080325346E-01  -4.39060145580907E-01   0.00000000000000E+00   7.86941579522282E-13
     -1.17435427817679E-22  -2.89939704144269E-08  -2.89931834728475E-08  -3.12829858400440E-18
      2.29954381250000E-07
      0.00000000000000E+00  -3.91899656769772E-11   0.00000000000000E+00   2.49692125714609E-13   3.22354625371319E-22
      3.91897397726336E-08   3.91899894647596E-08  -6.78619398079619E-19  -3.00258125133386E-01  -3.00258125133242E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.43713003271694E-10   0.00000000000000E+00  -1.43713003271694E-10
      3.56534466640319E-18  -3.94635592452451E-01  -3.82334297684449E-01   0.00000000000000E+00   1.04466366895053E-12
     -1.10991749409917E-22  -3.90473211251568E-08  -3.90462764614879E-08  -2.88672526832358E-18
      2.31954381250000E-07
      0.00000000000000E+00  -5.07550549861490E-11   0.00000000000000E+00   2.87295752524508E-13   2.72500311758255E-22
      5.07547262940079E-08   5.07550135897607E-08  -6.32820641593949E-19  -3.25251192798739E-01  -3.25251192798587E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.52431796469551E-10   0.00000000000000E+00  -1.52431796469551E-10
      3.26048107346409E-18  -3.19574301219001E-01  -3.03631862342684E-01   0.00000000000000E+00   1.18894837058312E-12
     -1.02216860213389E-22  -5.06037707416616E-08  -5.06025817932911E-08  -2.62766043187014E-18
      2.33954381250000E-07
      0.00000000000000E+00  -6.17755050036802E-11   0.00000000000000E+00   2.74235802694225E-13   2.22415371632481E-22
      6.17752133368808E-08   6.17754875726837E-08  -5.87519841091636E-19  -3.49714890749338E-01  -3.49714890749171E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.67004818041391E-10   0.00000000000000E+00  -1.67004818041391E-10
      2.92647143738131E-18  -2.24516590254646E-01  -2.05106256614249E-01   0.00000000000000E+00   1.03735319750507E-12
     -9.06116266235567E-23  -6.16095201078397E-08  -6.16084827546423E-08  -2.33895159628967E-18
      2.35954381250000E-07
      0.00000000000000E+00  -6.76857138429845E-11   0.00000000000000E+00   1.47488410923312E-13   1.29732909093748E-22
      6.76855550243198E-08   6.76857025127309E-08  -5.43439714536066E-19  -3.73640013538788E-01  -3.73640013538597E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.91444285379535E-10   0.00000000000000E+00  -1.91444285379535E-10
      2.54358286662224E-18  -1.19778057706022E-01  -9.85130157506228E-02   0.00000000000000E+00   6.81978699683111E-13
     -7.81224885803174E-23  -6.74949402060510E-08  -6.74942582273514E-08  -2.00014315208617E-18
      2.37954381250000E-07
      0.00000000000000E+00  -5.20310539201732E-11   0.00000000000000E+00  -3.88434626172067E-13   4.01630023202125E-23
      5.20313949536302E-08   5.20310065190041E-08  -4.94176792186264E-19  -3.97116465630140E-01  -3.97116465629964E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.75257400729030E-10   0.00000000000000E+00  -1.75257400729030E-10
      2.19306806516418E-18  -4.75722086263194E-02  -3.12341860088982E-02   0.00000000000000E+00   7.35710052565943E-13
     -3.57295139785915E-23  -5.18564848283276E-08  -5.18557491182751E-08  -1.69889127297791E-18
      2.39954381250000E-07
      0.00000000000000E+00  -2.94716903435744E-11   0.00000000000000E+00  -5.58192942861031E-13   1.31972787847928E-23
      2.94722424540101E-08   2.94716842610673E-08  -4.36758050634361E-19  -4.20227293661315E-01  -4.20227293661194E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21060750514331E-10   0.00000000000000E+00  -1.21060750514331E-10
      1.95094656413552E-18  -2.07095459699304E-02  -1.14621165126362E-02   0.00000000000000E+00   6.70977031576634E-13
     -1.34431922251055E-23  -2.93512944875845E-08  -2.93506235105530E-08  -1.51418851350115E-18
      2.41954381250000E-07
      0.00000000000000E+00  -2.01824217776680E-11   0.00000000000000E+00  -2.28174576489279E-13   6.61695516653390E-24
      2.01826430871845E-08   2.01824149126080E-08  -3.80044521065011E-19  -4.42911940909673E-01  -4.42911940909572E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01391598761867E-10   0.00000000000000E+00  -1.01391598761867E-10
      1.74816336661178E-18  -1.24547467876757E-02  -6.12785948396237E-03   0.00000000000000E+00   2.87040073285036E-13
     -7.27047584503860E-24  -2.00813103539195E-08  -2.00810233138462E-08  -1.36811884554677E-18
      2.43954381250000E-07
      0.00000000000000E+00  -1.73539712506250E-11   0.00000000000000E+00  -6.94203588788426E-14   4.62928288076920E-24
      1.73540274837675E-08   1.73539580634086E-08  -3.25721306154666E-19  -4.65145254019537E-01  -4.65145254019438E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.87944941557269E-11   0.00000000000000E+00  -9.87944941557269E-11
      1.55057437830033E-18  -9.85982235519274E-03  -4.42326748716047E-03   0.00000000000000E+00   1.12790608016618E-13
     -5.15741744755689E-24  -1.72552763598609E-08  -1.72551635692529E-08  -1.22485307214566E-18
      2.45954381250000E-07
      0.00000000000000E+00  -1.65492276632126E-11   0.00000000000000E+00  -1.95121007934811E-14   3.78525604967543E-24
      1.65492682525677E-08   1.65492487404669E-08  -2.73891313135267E-19  -4.86927202700122E-01  -4.86927202700021E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00640342098700E-10   0.00000000000000E+00  -1.00640342098700E-10
      1.34929369410293E-18  -8.87460371197182E-03  -3.69216483487433E-03   0.00000000000000E+00   5.57123738777670E-14
     -4.18283964679096E-24  -1.64486641107421E-08  -1.64486083983682E-08  -1.07540238096766E-18
      2.47954381250000E-07
      0.00000000000000E+00  -1.63034511464453E-11   0.00000000000000E+00  -5.75092382440470E-15   3.30450365427593E-24
      1.63034621536814E-08   1.63034564027576E-08  -2.24527279882315E-19  -5.08264911966706E-01  -5.08264911966603E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03163039743121E-10   0.00000000000000E+00  -1.03163039743121E-10
      1.14296761461669E-18  -8.38169834710955E-03  -3.27749242626576E-03   0.00000000000000E+00   3.72750583512162E-14
     -3.59289220550370E-24  -1.62003306380728E-08  -1.62002933630145E-08  -9.18440334734371E-19
      2.49954381250000E-07
      0.00000000000000E+00  -1.62112390302889E-11   0.00000000000000E+00  -1.99230489348473E-15   2.97938981804966E-24
      1.62112701087370E-08   1.62112681164321E-08  -1.77546999804216E-19  -5.29166661525038E-01  -5.29166661524933E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05364997132099E-10   0.00000000000000E+00  -1.05364997132099E-10
      9.32237620352488E-19  -8.07418831122840E-03  -2.99971896397348E-03   0.00000000000000E+00   2.99857798645964E-14
     -3.17913188673158E-24  -1.61059331050799E-08  -1.61059031193000E-08  -7.54690620548273E-19
      2.51954381250000E-07
      0.00000000000000E+00  -1.61664187985317E-11   0.00000000000000E+00  -8.50646921797732E-16   2.73954086340229E-24
      1.61664008462284E-08   1.61663999955815E-08  -1.32822998129812E-19  -5.49638283945818E-01  -5.49638283945711E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07009763542655E-10   0.00000000000000E+00  -1.07009763542655E-10
      7.18218093267179E-19  -7.85725721950395E-03  -2.79744067291281E-03   0.00000000000000E+00   2.60253978651997E-14
     -2.86855917753837E-24  -1.60594162574367E-08  -1.60593902320388E-08  -5.85395095137366E-19
      2.53954381250000E-07
      0.00000000000000E+00  -1.61396001352671E-11   0.00000000000000E+00  -4.26377575624504E-16   2.55388655507990E-24
      1.61396251674471E-08   1.61396247410695E-08  -9.02375769845729E-20  -5.69666540367213E-01  -5.69666540367105E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07985590167620E-10   0.00000000000000E+00  -1.07985590167620E-10
      5.02246912931937E-19  -7.69404139158469E-03  -2.64296649089834E-03   0.00000000000000E+00   2.32831830328823E-14
     -2.62668720974543E-24  -1.60316624340849E-08  -1.60316391509019E-08  -4.12009335947365E-19
      2.55954381250000E-07
      0.00000000000000E+00  -1.61204045851907E-11   0.00000000000000E+00  -2.58930645478298E-16   2.40641170305282E-24
      1.61204121365493E-08   1.61204118776187E-08  -5.00036980019098E-20  -5.89070440326388E-01  -5.89070440326281E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07398217142842E-10   0.00000000000000E+00  -1.07398217142842E-10
      2.87450478646254E-19  -7.56668947297296E-03  -2.52148122316087E-03   0.00000000000000E+00   2.09894378886074E-14
     -2.43477311562215E-24  -1.60130346499137E-08  -1.60130136604759E-08  -2.37446780644345E-19
      2.57954381250000E-07
      0.00000000000000E+00  -1.61031377745957E-11   0.00000000000000E+00  -2.34941941128482E-16   2.28846976958685E-24
      1.61031252844614E-08   1.61031250495194E-08  -1.28606576541925E-20  -6.07393015711494E-01  -6.07393015711390E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03658102222354E-10   0.00000000000000E+00  -1.03658102222354E-10
      8.01342742015466E-20  -7.46521856324555E-03  -2.42427712501467E-03   0.00000000000000E+00   1.86692902610459E-14
     -2.28225186911344E-24  -1.59994856165873E-08  -1.59994669472971E-08  -6.72736165473543E-20
      2.59954381250000E-07
      0.00000000000000E+00  -1.60753088192218E-11   0.00000000000000E+00  -5.36649024435839E-16   2.20366092615613E-24
      1.60753386616559E-08   1.60753381250068E-08   1.99707284216115E-20  -6.23901000643230E-01  -6.23901000643135E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.50162460896964E-11   0.00000000000000E+00  -9.50162460896964E-11
     -1.09898217977847E-19  -7.40055049637235E-03  -2.36564002081112E-03   0.00000000000000E+00   1.62154125315301E-14
     -2.17469682774072E-24  -1.59803380943297E-08  -1.59803218789172E-08   8.99274895562357E-20
      2.61954381250000E-07
      0.00000000000000E+00  -1.60454592796293E-11   0.00000000000000E+00  -6.06939442591521E-16   2.14426562669013E-24
      1.60454343653959E-08   1.60454337584564E-08   4.64295481342128E-20  -6.37412095243096E-01  -6.37412095243017E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.88175388759579E-11   0.00000000000000E+00  -7.88175388759579E-11
     -2.67533295729762E-19  -7.36180490997998E-03  -2.33121185990116E-03   0.00000000000000E+00   1.27319934654709E-14
     -2.10131917080781E-24  -1.59666289515739E-08  -1.59666162195804E-08   2.21103747595549E-19
      2.63954381250000E-07
      0.00000000000000E+00  -1.60110175031765E-11   0.00000000000000E+00  -7.65982950788287E-16   2.10583925286503E-24
      1.60110050390621E-08   1.60110042730791E-08   6.35343507473534E-20  -6.46242836689895E-01  -6.46242836689844E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.20071349877091E-11   0.00000000000000E+00  -5.20071349877091E-11
     -3.71547565705181E-19  -7.33668048135930E-03  -2.30848744980664E-03   0.00000000000000E+00   8.08764912140615E-15
     -2.05631273939844E-24  -1.59590052257405E-08  -1.59589971380914E-08   3.08013214957827E-19
      2.65954381250000E-07
      0.00000000000000E+00  -1.59635337740402E-11   0.00000000000000E+00  -1.15129598027656E-15   2.09195148757280E-24
      1.59635543509549E-08   1.59635531996590E-08   6.75477532317990E-20  -6.48323427863211E-01  -6.48323427863199E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23253098781294E-11   0.00000000000000E+00  -1.23253098781294E-11
     -3.96198185461439E-19  -7.32526710618909E-03  -2.29952180094767E-03   0.00000000000000E+00   2.03421262276718E-15
     -2.04509980361200E-24  -1.59512299239934E-08  -1.59512278897808E-08   3.28650432229641E-19
      2.67954381250000E-07
      0.00000000000000E+00  -1.59001609053670E-11   0.00000000000000E+00  -1.63063538563363E-15   2.10976011062451E-24
      1.59001365056204E-08   1.59001348749850E-08   5.40072790216295E-20  -6.41307688394242E-01  -6.41307688394284E-01
      0.00000000000000E+00   0.00000000000000E+00   4.13731252511403E-11   0.00000000000000E+00   4.13731252511403E-11
     -3.13451934959159E-19  -7.33119523079272E-03  -2.30851276379235E-03   0.00000000000000E+00  -5.98745882704114E-15
     -2.07820398322041E-24  -1.59415020127773E-08  -1.59415080002362E-08   2.59444655937530E-19
      2.69954381250000E-07
      0.00000000000000E+00  -1.58183272445151E-11   0.00000000000000E+00  -2.61472262467431E-15   2.17296372072516E-24
      1.58182881787934E-08   1.58182855640708E-08   1.72431280500934E-20  -6.22504132148669E-01  -6.22504132148779E-01
      0.00000000000000E+00   0.00000000000000E+00   1.09746913613891E-10   0.00000000000000E+00   1.09746913613891E-10
     -9.39581077313778E-20  -7.36156037331973E-03  -2.34312461064007E-03   0.00000000000000E+00  -1.64426183450643E-14
     -2.17693804386546E-24  -1.59280160350664E-08  -1.59280324776847E-08   7.67149796812839E-20
      2.71954381250000E-07
      0.00000000000000E+00  -1.56898364571618E-11   0.00000000000000E+00  -7.32681860354143E-15   2.33725013214338E-24
      1.56897783339089E-08   1.56897710070903E-08  -5.06993759155608E-20  -5.88707160437551E-01  -5.88707160437743E-01
      0.00000000000000E+00   0.00000000000000E+00   1.92528703455003E-10   0.00000000000000E+00   1.92528703455003E-10
      2.91099299178628E-19  -7.47901489799399E-03  -2.47498937202995E-03   0.00000000000000E+00  -2.81716813394267E-14
     -2.42916085067450E-24  -1.58822715388640E-08  -1.58822997105453E-08  -2.40399923263067E-19
      2.73954381249999E-07
      0.00000000000000E+00  -1.54942990116470E-11   0.00000000000000E+00  -2.71597994278918E-13   2.72539567669601E-24
      1.54942571236115E-08   1.54939855256172E-08  -1.61805065173013E-19  -5.36270191413469E-01  -5.36270191413753E-01
      0.00000000000000E+00   0.00000000000000E+00   2.83491882845985E-10   0.00000000000000E+00   2.83491882845985E-10
      8.58083064870597E-19  -7.79691498683508E-03  -2.82583764862962E-03   0.00000000000000E+00   2.10042806015025E-13
     -3.06620623748650E-24  -1.57776874512692E-08  -1.57774774084632E-08  -6.96277999697585E-19
      2.75954381249999E-07
      0.00000000000000E+00  -1.50536279625253E-11   0.00000000000000E+00  -1.32595906090323E-14   3.89972865814785E-24
      1.50535675805902E-08   1.50535543209996E-08  -3.33210379630224E-19  -4.61934669791389E-01  -4.61934669791748E-01
      0.00000000000000E+00   0.00000000000000E+00   3.59129702311395E-10   0.00000000000000E+00   3.59129702311395E-10
      1.57634246949339E-18  -8.82044446224038E-03  -3.96439631173733E-03   0.00000000000000E+00  -9.78154818408590E-14
     -5.24500535457858E-24  -1.54125862078291E-08  -1.54126840233110E-08  -1.24313208986316E-18
      2.77954381249999E-07
      0.00000000000000E+00  -1.26239672844373E-11   0.00000000000000E+00  -6.21332737605983E-14   5.88279912666957E-24
      1.26239657032134E-08   1.26239035699396E-08  -5.73524773701379E-19  -3.64243998515472E-01  -3.64243998515855E-01
      0.00000000000000E+00   0.00000000000000E+00   3.82819258818665E-10   0.00000000000000E+00   3.82819258818665E-10
      2.34198098713072E-18  -1.45235430258956E-02  -1.04255586738498E-02   0.00000000000000E+00  -1.76945906442850E-13
     -2.19951640320205E-23  -1.30065458828518E-08  -1.30067228287583E-08  -1.76845621342934E-18
      2.79954381249999E-07
      0.00000000000000E+00  -3.04208138578770E-12   0.00000000000000E+00  -2.41864698089288E-13  -2.04057757558489E-23
      3.04235973329003E-09   3.04211786859192E-09  -8.34230566067264E-19  -2.46588427124660E-01  -2.46588427125060E-01
      0.00000000000000E+00   0.00000000000000E+00   3.99855130252732E-10   0.00000000000000E+00   3.99855130252732E-10
      3.14169124763618E-18  -3.87982934196195E-02  -3.77138546991563E-02   0.00000000000000E+00  -3.45306787116944E-13
     -7.79446983656342E-23  -3.44162769205746E-09  -3.44197299884465E-09  -2.30746068156892E-18
      2.81954381249999E-07
      0.00000000000000E+00  -4.70245054502537E-14   0.00000000000000E+00  -8.07573448446359E-14  -4.35577211429486E-23
      4.71481954466146E-11   4.70674381017264E-11  -1.08757216726873E-18  -1.23580432069146E-01  -1.23580432069517E-01
      0.00000000000000E+00   0.00000000000000E+00   3.70968064711478E-10   0.00000000000000E+00   3.70968064711478E-10
      3.88362737705914E-18  -6.84911502806738E-02  -6.83594439679266E-02   0.00000000000000E+00  -1.01724410039569E-12
     -9.26477416834524E-23  -4.17018258712716E-10  -4.18035502813204E-10  -2.79605520979041E-18
      2.83954381249999E-07
      0.00000000000000E+00   7.21899634451160E-14   0.00000000000000E+00  -8.65419097946406E-15  -4.60001455323933E-23
     -7.22244739195530E-11  -7.22331281105784E-11  -1.24198808885532E-18  -4.62949530688659E-02  -4.62949530691096E-02
      0.00000000000000E+00   0.00000000000000E+00   2.43708811910887E-10   0.00000000000000E+00   2.43708811910887E-10
      4.37104500088092E-18  -9.80660772475420E-02  -9.80120521573702E-02   0.00000000000000E+00  -1.13988519298566E-12
     -1.02143344170050E-22  -1.70335798607221E-10  -1.71475683800308E-10  -3.12905691202559E-18
      2.85954381249999E-07
      0.00000000000000E+00   2.59920606297301E-14   0.00000000000000E+00  -3.55134586824600E-16  -4.63855295814218E-23
     -2.59920144988019E-11  -2.59923696334351E-11  -1.29775439701220E-18  -1.97217334110857E-02  -1.97217334112157E-02
      0.00000000000000E+00   0.00000000000000E+00   1.30004578310625E-10   0.00000000000000E+00   1.30004578310625E-10
      4.63105415750216E-18  -1.27170812546210E-01  -1.27138042822808E-01   0.00000000000000E+00  -6.68333070542990E-13
     -1.06495652626791E-22  -1.03343875606542E-10  -1.04012208677191E-10  -3.33329976048997E-18
      2.86454381249999E-07
      0.00000000000000E+00   1.46951579532043E-14   0.00000000000000E+00   6.25520614866886E-16  -4.64066763223885E-23
     -1.46716863841865E-11  -1.46710608636180E-11  -1.30676715981821E-18  -1.56629643335665E-02  -1.56629643336734E-02
      0.00000000000000E+00   0.00000000000000E+00   1.06894687478390E-10   0.00000000000000E+00   1.06894687478390E-10
      4.68450150124136E-18  -1.34414529683661E-01  -1.34385474135372E-01   0.00000000000000E+00  -5.55195420767354E-13
     -1.07331541872224E-22  -9.16684311938994E-11  -9.22236266147740E-11  -3.37773434142315E-18
      2.87129381249999E-07
      0.00000000000000E+00   3.67378948830107E-15   0.00000000000000E+00   9.91671937742623E-16  -4.63574942511371E-23
     -3.71844827355455E-12  -3.71745660166316E-12  -1.31381757695013E-18  -1.27156304694156E-02  -1.27156304695032E-02
      0.00000000000000E+00   0.00000000000000E+00   8.75326408216031E-11   0.00000000000000E+00   8.75326408216031E-11
      4.74358603379595E-18  -1.44129901657026E-01  -1.44103495350339E-01   0.00000000000000E+00  -4.55332217184275E-13
     -1.08234505836749E-22  -8.33598520026456E-11  -8.38151842199382E-11  -3.42976845684581E-18
      2.88040631249999E-07
      0.00000000000000E+00  -6.79651055335698E-15   0.00000000000000E+00   1.07543882772399E-15  -4.61988013983537E-23
      6.82993597314512E-12   6.83101141192664E-12  -1.31858779383669E-18  -1.08142333986143E-02  -1.08142333986862E-02
      0.00000000000000E+00   0.00000000000000E+00   7.18865845748000E-11   0.00000000000000E+00   7.18865845748000E-11
      4.80909268398973E-18  -1.57124809099204E-01  -1.57100008912992E-01   0.00000000000000E+00  -4.08506310464233E-13
     -1.09303689359498E-22  -7.83090896761544E-11  -7.87175959867279E-11  -3.49050489015304E-18
      2.89270818749999E-07
      0.00000000000000E+00  -1.73586553322226E-14   0.00000000000000E+00   9.70237253766758E-16  -4.58201000923294E-23
      1.73565719058806E-11   1.73575421430886E-11  -1.32099125695210E-18  -9.66178110250317E-03  -9.66178110256247E-03
      0.00000000000000E+00   0.00000000000000E+00   5.92989141390113E-11   0.00000000000000E+00   5.92989141390113E-11
      4.88204146692712E-18  -1.74444692539690E-01  -1.74420541833471E-01   0.00000000000000E+00  -4.01144107076756E-13
     -1.10687197395933E-22  -7.62553121749116E-11  -7.66564562820990E-11  -3.56105020997501E-18
      2.90931571874999E-07
      0.00000000000000E+00  -2.83800237971258E-14   0.00000000000000E+00   7.66168304566187E-16  -4.48880574415872E-23
      2.83407324635242E-11   2.83414986317838E-11  -1.32099428705386E-18  -8.92809366801947E-03  -8.92809366806832E-03
      0.00000000000000E+00   0.00000000000000E+00   4.88572872820338E-11   0.00000000000000E+00   4.88572872820338E-11
      4.96318135945978E-18  -1.97423231647153E-01  -1.97398910222181E-01   0.00000000000000E+00  -4.15661672351162E-13
     -1.12567752364504E-22  -7.67831242413551E-11  -7.71987859138188E-11  -3.64218707240591E-18
      2.92931571874999E-07
      0.00000000000000E+00  -3.91258580504064E-14   0.00000000000000E+00   5.83932610850271E-16  -4.27678270536571E-23
      3.91381442622722E-11   3.91387281948403E-11  -1.31896846592528E-18  -8.43780731201254E-03  -8.43780731205328E-03
      0.00000000000000E+00   0.00000000000000E+00   4.07449743901127E-11   0.00000000000000E+00   4.07449743901127E-11
      5.04467130824000E-18  -2.24524016335637E-01  -2.24498849221024E-01   0.00000000000000E+00  -4.37201233755907E-13
     -1.14875231259240E-22  -7.94465013510819E-11  -7.98837025849527E-11  -3.72570284231472E-18
      2.94931571874999E-07
      0.00000000000000E+00  -4.85858659827817E-14   0.00000000000000E+00   4.63070724095311E-16  -3.89828953162080E-23
      4.85619372245722E-11   4.85624002952573E-11  -1.31608688188853E-18  -8.11867478047632E-03  -8.11867478051150E-03
      0.00000000000000E+00   0.00000000000000E+00   3.51848966740914E-11   0.00000000000000E+00   3.51848966740914E-11
      5.11504110158818E-18  -2.51067840598767E-01  -2.51041456486320E-01   0.00000000000000E+00  -4.57566762120172E-13
     -1.17218597526546E-22  -8.32897302071111E-11  -8.37472969693485E-11  -3.79895421969965E-18
      2.96931571874999E-07
      0.00000000000000E+00  -5.71274265430816E-14   0.00000000000000E+00   3.84058737494979E-16  -3.29144211343295E-23
      5.71001441354730E-11   5.71005281941776E-11  -1.31292908917620E-18  -7.89130581203974E-03  -7.89130581207099E-03
      0.00000000000000E+00   0.00000000000000E+00   3.12459167367808E-11   0.00000000000000E+00   3.12459167367808E-11
      5.17753293506174E-18  -2.77067341581018E-01  -2.77039508773684E-01   0.00000000000000E+00  -4.75302982994913E-13
     -1.19587627284952E-22  -8.78711419478442E-11  -8.83464449309587E-11  -3.86460384588554E-18
      2.98931571874999E-07
      0.00000000000000E+00  -6.50260739429289E-14   0.00000000000000E+00   3.32286493913884E-16  -2.40172229858143E-23
      6.50410372042381E-11   6.50413694907080E-11  -1.30977687660512E-18  -7.72038872140498E-03  -7.72038872143334E-03
      0.00000000000000E+00   0.00000000000000E+00   2.83579203402958E-11   0.00000000000000E+00   2.83579203402958E-11
      5.23424877574233E-18  -3.02529163516286E-01  -3.02499739115108E-01   0.00000000000000E+00  -4.91949615235642E-13
     -1.21978237539690E-22  -9.29073402156472E-11  -9.33992898310048E-11  -3.92447189913722E-18
      3.00931571874999E-07
      0.00000000000000E+00  -7.25573423939461E-14   0.00000000000000E+00   2.98014001815349E-16  -1.19904600188862E-23
      7.25771133537738E-11   7.25774113677636E-11  -1.30675715146881E-18  -7.58685316085976E-03  -7.58685316088591E-03
      0.00000000000000E+00   0.00000000000000E+00   2.61549670636883E-11   0.00000000000000E+00   2.61549670636883E-11
      5.28655870986972E-18  -3.27456883538692E-01  -3.27425779289963E-01   0.00000000000000E+00  -5.09023240313280E-13
     -1.24392346217989E-22  -9.82233551910140E-11  -9.87323784314517E-11  -3.97980155840090E-18
      3.02931571874999E-07
      0.00000000000000E+00  -7.98130766333407E-14   0.00000000000000E+00   2.75000271370913E-16   2.99774459446176E-24
      7.98427667053598E-11   7.98430417056342E-11  -1.30391649227386E-18  -7.47935599851921E-03  -7.47935599854361E-03
      0.00000000000000E+00   0.00000000000000E+00   2.44011560266817E-11   0.00000000000000E+00   2.44011560266817E-11
      5.33536102192307E-18  -3.51859019468077E-01  -3.51826179099999E-01   0.00000000000000E+00  -5.27931070095058E-13
     -1.26837023955887E-22  -1.03716266662094E-10  -1.04244197732315E-10  -4.03144452964921E-18
      3.04931571874999E-07
      0.00000000000000E+00  -8.69769661355278E-14   0.00000000000000E+00   2.61620275427124E-16   1.96136964937734E-23
      8.69728899685468E-11   8.69731515888418E-11  -1.30123192823209E-18  -7.40595455007309E-03  -7.40595455009599E-03
      0.00000000000000E+00   0.00000000000000E+00   2.28958925839686E-11   0.00000000000000E+00   2.28958925839686E-11
      5.38115280709101E-18  -3.75725118854819E-01  -3.75690506798306E-01   0.00000000000000E+00  -5.48604213189302E-13
     -1.29317347172560E-22  -1.09320439959492E-10  -1.09869044172810E-10  -4.07992087885892E-18
      3.06931571874999E-07
      0.00000000000000E+00  -9.40490109005074E-14   0.00000000000000E+00   2.52631721976943E-16   3.66044952303604E-23
      9.40229353505653E-11   9.40231879823239E-11  -1.29869029998344E-18  -7.36110562922760E-03  -7.36110562924921E-03
      0.00000000000000E+00   0.00000000000000E+00   2.16164123653740E-11   0.00000000000000E+00   2.16164123653740E-11
      5.42438563182176E-18  -3.99114863604665E-01  -3.99078433996796E-01   0.00000000000000E+00  -5.74208020720501E-13
     -1.31850365724868E-22  -1.15065392326845E-10  -1.15639600347697E-10  -4.12569533183832E-18
      3.08931571874999E-07
      0.00000000000000E+00  -1.01029210928279E-13   0.00000000000000E+00   2.45051360126048E-16   5.30344127752404E-23
      1.01011172438504E-10   1.01011417489917E-10  -1.29629514103420E-18  -7.32831022764370E-03  -7.32831022766427E-03
      0.00000000000000E+00   0.00000000000000E+00   2.05744408920013E-11   0.00000000000000E+00   2.05744408920013E-11
      5.46553451360576E-18  -4.22162489709839E-01  -4.22124187243834E-01   0.00000000000000E+00  -6.08274437929219E-13
     -1.34464530615155E-22  -1.20977583943856E-10  -1.21585858381919E-10  -4.16923937257156E-18
      3.09931571874999E-07
      0.00000000000000E+00  -1.04519310942165E-13   0.00000000000000E+00   2.42972631916999E-16   6.12284104837347E-23
      1.04523062666473E-10   1.04523305639166E-10  -1.29513490811778E-18  -7.31459833765758E-03  -7.31459833767759E-03
      0.00000000000000E+00   0.00000000000000E+00   2.00161410427423E-11   0.00000000000000E+00   2.00161410427423E-11
      5.48555065464851E-18  -4.33591372114380E-01  -4.33552139390636E-01   0.00000000000000E+00  -6.35000851434400E-13
     -1.35800100244922E-22  -1.23904445830339E-10  -1.24539446681909E-10  -4.19041574653073E-18
      3.11281571874999E-07
      0.00000000000000E+00  -1.09203392539749E-13   0.00000000000000E+00   2.38066974216166E-16   7.13484278616179E-23
      1.09215985732832E-10   1.09216223799878E-10  -1.29362953454458E-18  -7.30102092305876E-03  -7.30102092307808E-03
      0.00000000000000E+00   0.00000000000000E+00   1.93270722450807E-11   0.00000000000000E+00   1.93270722450807E-11
      5.51164220217937E-18  -4.48822532317682E-01  -4.48782038577963E-01   0.00000000000000E+00  -6.56972068476837E-13
     -1.37632986911534E-22  -1.27886323976344E-10  -1.28543296044958E-10  -4.21801266763478E-18
      3.13104071874999E-07
      0.00000000000000E+00  -1.15448834669861E-13   0.00000000000000E+00   2.32768026295058E-16   8.31676637564460E-23
      1.15479404257161E-10   1.15479637025270E-10  -1.29169242071028E-18  -7.29319406708518E-03  -7.29319406710362E-03
      0.00000000000000E+00   0.00000000000000E+00   1.84394937728327E-11   0.00000000000000E+00   1.84394937728327E-11
      5.54524817958035E-18  -4.69010015984616E-01  -4.68967829165891E-01   0.00000000000000E+00  -6.87216121122945E-13
     -1.40154257106435E-22  -1.33231914676840E-10  -1.33919130798103E-10  -4.25355575887008E-18
      3.15104071874999E-07
      0.00000000000000E+00  -1.22337189960426E-13   0.00000000000000E+00   2.28882115709522E-16   9.40545904562909E-23
      1.22307951192381E-10   1.22308180074590E-10  -1.28965940621983E-18  -7.30099825550270E-03  -7.30099825552019E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74932108110161E-11   0.00000000000000E+00   1.74932108110161E-11
      5.58023460120238E-18  -4.90713983825814E-01  -4.90669944492367E-01   0.00000000000000E+00  -7.24922218578910E-13
     -1.42971701352666E-22  -1.39076468666884E-10  -1.39801390885606E-10  -4.29057519498256E-18
      3.17104071874999E-07
      0.00000000000000E+00  -1.29133700513783E-13   0.00000000000000E+00   2.27206270177691E-16   1.03038679122930E-22
      1.29136286587126E-10   1.29136513793499E-10  -1.28769039192678E-18  -7.33269589867113E-03  -7.33269589868770E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65719093805144E-11   0.00000000000000E+00   1.65719093805144E-11
      5.61337841996341E-18  -5.11975867736046E-01  -5.11929968149817E-01   0.00000000000000E+00  -7.65253072155649E-13
     -1.45825452890247E-22  -1.44943170101713E-10  -1.45708423174014E-10  -4.32568802803664E-18
      3.19104071874999E-07
      0.00000000000000E+00  -1.36205745278762E-13   0.00000000000000E+00   2.34900111668925E-16   1.10486413324236E-22
      1.36172660634165E-10   1.36172895534388E-10  -1.28568260697658E-18  -7.43023547081190E-03  -7.43023547082753E-03
      0.00000000000000E+00   0.00000000000000E+00   1.56264911489196E-11   0.00000000000000E+00   1.56264911489196E-11
      5.64463140226125E-18  -5.32804746998013E-01  -5.32756929291143E-01   0.00000000000000E+00  -8.03775261736354E-13
     -1.48689431577932E-22  -1.50995611421422E-10  -1.51799386683307E-10  -4.35894879528468E-18
      3.21104071874999E-07
      0.00000000000000E+00  -1.44104392678609E-13   0.00000000000000E+00   2.72854951193762E-16   1.17104501089919E-22
      1.44122750033601E-10   1.44123022888669E-10  -1.28332045956842E-18  -7.73222531108107E-03  -7.73222531109556E-03
      0.00000000000000E+00   0.00000000000000E+00   1.44887679356733E-11   0.00000000000000E+00   1.44887679356733E-11
      5.67360893813260E-18  -5.53208786325487E-01  -5.53158823322995E-01   0.00000000000000E+00  -8.34137864491945E-13
     -1.51520654906339E-22  -1.57777652959699E-10  -1.58611790824343E-10  -4.39028847856418E-18
      3.23104071874999E-07
      0.00000000000000E+00  -1.55493140092343E-13   0.00000000000000E+00   4.17589478757496E-16   1.24620990880385E-22
      1.55541487062982E-10   1.55541904652586E-10  -1.27954596796376E-18  -8.71350598482461E-03  -8.71350598483716E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25521964026852E-11   0.00000000000000E+00   1.25521964026852E-11
      5.69871333093797E-18  -5.73192188774595E-01  -5.73139239564569E-01   0.00000000000000E+00  -8.37459977470279E-13
     -1.54226307341796E-22  -1.67256641077647E-10  -1.68094101055271E-10  -4.41916736297422E-18
      3.25104071874999E-07
      0.00000000000000E+00  -1.94802687617164E-13   0.00000000000000E+00   1.51359869587396E-15   1.46597333807881E-22
      1.94799809787455E-10   1.94801323386297E-10  -1.26564104570718E-18  -1.43448748409756E-02  -1.43448748409791E-02
      0.00000000000000E+00   0.00000000000000E+00   3.48885797200090E-12   0.00000000000000E+00   3.48885797200090E-12
      5.70569104688197E-18  -5.92723967692895E-01  -5.92661507834590E-01   0.00000000000000E+00  -6.32953185239647E-13
     -1.56185054048120E-22  -1.97657228172903E-10  -1.98290181358299E-10  -4.44005000117479E-18
      3.27104071874999E-07
      0.00000000000000E+00  -4.12291025324588E-13   0.00000000000000E+00   6.67340545805421E-15   2.35794785854798E-22
      4.12245721163087E-10   4.12252394568781E-10  -1.20855084453407E-18  -3.88543680891449E-02  -3.88543680891117E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.32223543908939E-11   0.00000000000000E+00  -3.32223543908939E-11
      5.63924633810018E-18  -6.11521890045771E-01  -6.11402499618298E-01   0.00000000000000E+00   2.99947300960836E-13
     -1.55260911992544E-22  -3.79329987478693E-10  -3.79030040177887E-10  -4.43069549356611E-18
      3.29104071874999E-07
      0.00000000000000E+00  -8.91904243022292E-13   0.00000000000000E+00   1.38986491767751E-14   3.15934248468040E-22
      8.91885629690078E-10   8.91899528339571E-10  -1.13497620806163E-18  -6.85784856701655E-02  -6.85784856701147E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.08623008252603E-11   0.00000000000000E+00  -5.08623008252603E-11
      5.53752173644966E-18  -6.29056017890423E-01  -6.28791098453911E-01   0.00000000000000E+00   5.03978049835963E-13
     -1.53668696426227E-22  -8.41541205563992E-10  -8.41037227514310E-10  -4.40254552838803E-18
      3.31104071874999E-07
      0.00000000000000E+00  -1.81668890196488E-12   0.00000000000000E+00   2.45444291442816E-14   3.64771528925133E-22
      1.81666545570638E-09   1.81669000013589E-09  -1.06151199986432E-18  -9.81575145763395E-02  -9.81575145762789E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.06076960219801E-11   0.00000000000000E+00  -6.06076960219801E-11
      5.41630634440570E-18  -6.44473579396990E-01  -6.43920424224212E-01   0.00000000000000E+00   4.34886866494711E-13
     -1.52237549481167E-22  -1.75651719098025E-09  -1.75608230411391E-09  -4.35479434454139E-18
      3.33104071874999E-07
      0.00000000000000E+00  -3.45584192690761E-12   0.00000000000000E+00   4.19137219952036E-14   4.00954442090377E-22
      3.45580617055910E-09   3.45584808428149E-09  -9.93624921783778E-19  -1.27262382016149E-01  -1.27262382016077E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.21558400792569E-11   0.00000000000000E+00  -7.21558400792569E-11
      5.27199466424718E-18  -6.56435653643885E-01  -6.55369804641712E-01   0.00000000000000E+00   3.40535773300812E-13
     -1.51055551576532E-22  -3.38403277997539E-09  -3.38369224420224E-09  -4.27836974246341E-18
      3.35104071874999E-07
      0.00000000000000E+00  -6.07102897415473E-12   0.00000000000000E+00   6.57874499670629E-14   4.29753094645632E-22
      6.07100809066986E-09   6.07107387812026E-09  -9.33080619883521E-19  -1.55808325145132E-01  -1.55808325145045E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.67129190613990E-11   0.00000000000000E+00  -8.67129190613990E-11
      5.09856882612439E-18  -6.63124564261283E-01  -6.61239505690242E-01   0.00000000000000E+00   2.53385526944857E-13
     -1.50107787162481E-22  -5.98461434458565E-09  -5.98436095905886E-09  -4.16548820624087E-18
      3.36104071874999E-07
      0.00000000000000E+00  -7.85786833652716E-12   0.00000000000000E+00   8.93110252523290E-14   4.46591841716495E-22
      7.85776199404441E-09   7.85785130507011E-09  -9.04791396603993E-19  -1.69935022171868E-01  -1.69935022171772E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.59226425916110E-11   0.00000000000000E+00  -9.59226425916110E-11
      5.00264618353278E-18  -6.64696822201857E-01  -6.62251828369996E-01   0.00000000000000E+00   2.06937537397847E-13
     -1.49689379222118E-22  -7.76213560001575E-09  -7.76192866247850E-09  -4.09785478692879E-18
      3.37454071874999E-07
      0.00000000000000E+00  -1.07484059059224E-11   0.00000000000000E+00   1.06699612818010E-13   4.58349531366365E-22
      1.07483298286408E-08   1.07484365282541E-08  -8.69308900774839E-19  -1.88738356536356E-01  -1.88738356536249E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07188815722257E-10   0.00000000000000E+00  -1.07188815722257E-10
      4.85794128230773E-18  -6.63000889019882E-01  -6.59648902234840E-01   0.00000000000000E+00   2.38251573063650E-13
     -1.49030926356750E-22  -1.06414859641048E-08  -1.06412477125319E-08  -3.98863238153289E-18
      3.39276571874999E-07
      0.00000000000000E+00  -1.55943179304660E-11   0.00000000000000E+00   1.32197936696052E-13   4.60556201711441E-22
      1.55942304319432E-08   1.55943626298804E-08  -8.24578050880590E-19  -2.13643136990264E-01  -2.13643136990145E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19741959195524E-10   0.00000000000000E+00  -1.19741959195524E-10
      4.63971156167389E-18  -6.52200683546349E-01  -6.47326145540455E-01   0.00000000000000E+00   4.68103397251336E-13
     -1.47358232347144E-22  -1.54750887740819E-08  -1.54746206706848E-08  -3.81513351079330E-18
      3.41276571874999E-07
      0.00000000000000E+00  -2.24171879234015E-11   0.00000000000000E+00   1.69357331786036E-13   4.52246991015009E-22
      2.24170342001695E-08   2.24172035575017E-08  -7.77679105349102E-19  -2.40410414080873E-01  -2.40410414080743E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.30212557862137E-10   0.00000000000000E+00  -1.30212557862137E-10
      4.37928644594962E-18  -6.27371044772187E-01  -6.20350473062452E-01   0.00000000000000E+00   9.57408022406537E-13
     -1.43582789783209E-22  -2.22879484076618E-08  -2.22869909996396E-08  -3.60160734060051E-18
      3.43276571874999E-07
      0.00000000000000E+00  -3.11517142765745E-11   0.00000000000000E+00   2.16686625174227E-13   4.33771510574959E-22
      3.11514675239038E-08   3.11516842105295E-08  -7.31780306102720E-19  -2.66628732797473E-01  -2.66628732797334E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.38178570565698E-10   0.00000000000000E+00  -1.38178570565698E-10
      4.10292930481822E-18  -5.86092926448670E-01  -5.76323159793911E-01   0.00000000000000E+00   1.58150342421111E-12
     -1.36881800625387E-22  -3.10150871433879E-08  -3.10135056399638E-08  -3.37114899871550E-18
      3.45276571874999E-07
      0.00000000000000E+00  -4.19682689775049E-11   0.00000000000000E+00   2.68269021017977E-13   4.01677645761304E-22
      4.19679984929635E-08   4.19682667619849E-08  -6.86297010357840E-19  -2.92307539562786E-01  -2.92307539562639E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.46250048051890E-10   0.00000000000000E+00  -1.46250048051890E-10
      3.81042920871444E-18  -5.24614323223487E-01  -5.11439203374131E-01   0.00000000000000E+00   2.05990644779183E-12
     -1.27029298728487E-22  -4.18240766203807E-08  -4.18220167139331E-08  -3.12413219835660E-18
      3.47276571874999E-07
      0.00000000000000E+00  -5.43865040505974E-11   0.00000000000000E+00   3.08605564131931E-13   3.42708815184981E-22
      5.43861592300092E-08   5.43864678355737E-08  -6.41255717155243E-19  -3.17450183425201E-01  -3.17450183425043E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.57665975249167E-10   0.00000000000000E+00  -1.57665975249167E-10
      3.49509725821610E-18  -4.40139890858054E-01  -4.23055611470473E-01   0.00000000000000E+00   2.10328059387567E-12
     -1.15511089692781E-22  -5.42309051409183E-08  -5.42288018603245E-08  -2.85384154106086E-18
      3.49276571874999E-07
      0.00000000000000E+00  -6.71056224827818E-11   0.00000000000000E+00   3.16662583014279E-13   2.67160534190462E-22
      6.71053065458073E-08   6.71056232083906E-08  -5.96715124643553E-19  -3.42063887732847E-01  -3.42063887732676E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.70544227293233E-10   0.00000000000000E+00  -1.70544227293233E-10
      3.15400880362964E-18  -3.32421572974954E-01  -3.11333539258184E-01   0.00000000000000E+00   1.84750003514424E-12
     -1.02994264279130E-22  -6.69369264811324E-08  -6.69350789810974E-08  -2.55729367898608E-18
      3.51276571874999E-07
      0.00000000000000E+00  -7.65974086942308E-11   0.00000000000000E+00   2.63973408699238E-13   2.01272836740691E-22
      7.65971994391173E-08   7.65974634125262E-08  -5.53000790537595E-19  -3.66148377867900E-01  -3.66148377867711E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.88719956059548E-10   0.00000000000000E+00  -1.88719956059548E-10
      2.77656889151054E-18  -2.08251762304715E-01  -1.84178355654127E-01   0.00000000000000E+00   1.29597682409662E-12
     -8.81582721476878E-23  -7.64100394332906E-08  -7.64087434564666E-08  -2.22356810097295E-18
      3.53276571874999E-07
      0.00000000000000E+00  -7.44587121436164E-11   0.00000000000000E+00  -5.28116486133943E-14   8.75665385677045E-23
      7.44587544738495E-08   7.44587016622010E-08  -5.09761056689226E-19  -3.89706561510351E-01  -3.89706561510141E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.10590959611948E-10   0.00000000000000E+00  -2.10590959611948E-10
      2.35538697228665E-18  -9.06356765618452E-02  -6.72426416723753E-02   0.00000000000000E+00   8.19132679289889E-13
     -6.65589646951341E-23  -7.42489298352684E-08  -7.42481107025892E-08  -1.84562591559742E-18
      3.55276571874999E-07
      0.00000000000000E+00  -4.44061038372043E-11   0.00000000000000E+00  -7.46117230070197E-13   2.39083478210696E-23
      4.44068265868198E-08   4.44060804695897E-08  -4.55816621347132E-19  -4.12894101402352E-01  -4.12894101402194E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.58130411133564E-10   0.00000000000000E+00  -1.58130411133564E-10
      2.03912615001952E-18  -3.38598832521399E-02  -1.99188021983090E-02   0.00000000000000E+00   9.71227986613064E-13
     -2.31885709674407E-23  -4.42489212864427E-08  -4.42479500584561E-08  -1.58330952867238E-18
      3.57276571874999E-07
      0.00000000000000E+00  -2.49855341546728E-11   0.00000000000000E+00  -4.80039522388760E-13   8.98119784333235E-24
      2.49860436908154E-08   2.49855636512930E-08  -3.98208751288730E-19  -4.35706503066075E-01  -4.35706503065964E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11634150225109E-10   0.00000000000000E+00  -1.11634150225109E-10
      1.81585784956930E-18  -1.60104945782290E-02  -8.17351905822589E-03   0.00000000000000E+00   5.59221323359717E-13
     -9.70113040535903E-24  -2.48744887223913E-08  -2.48739295010679E-08  -1.41764909828057E-18
      3.59276571874999E-07
      0.00000000000000E+00  -1.86453082557628E-11   0.00000000000000E+00  -1.56158987880145E-13   5.28038057621132E-24
      1.86454964591476E-08   1.86453403001597E-08  -3.42905931741321E-19  -4.58081976348535E-01  -4.58081976348435E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00447924387308E-10   0.00000000000000E+00  -1.00447924387308E-10
      1.61496200079468E-18  -1.08468297718175E-02  -5.00392397049573E-03   0.00000000000000E+00   2.04744358898336E-13
     -5.88085716469136E-24  -1.85450971201313E-08  -1.85448923757724E-08  -1.27205606905336E-18
      3.61276571874999E-07
      0.00000000000000E+00  -1.68828995934876E-11   0.00000000000000E+00  -4.31326328618409E-14   4.03976392201740E-24
      1.68829525138674E-08   1.68829093812346E-08  -2.90220945052889E-19  -4.80007564104723E-01  -4.80007564104623E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00257983338245E-10   0.00000000000000E+00  -1.00257983338245E-10
      1.41444603411819E-18  -9.20473218576733E-03  -3.91704810390081E-03   0.00000000000000E+00   8.15319611291060E-14
     -4.48235116017036E-24  -1.67827329298574E-08  -1.67826513978963E-08  -1.12422508906531E-18
      3.63276571874999E-07
      0.00000000000000E+00  -1.63965817099737E-11   0.00000000000000E+00  -1.16754889153059E-14   3.44452906710431E-24
      1.63965989958580E-08   1.63965873203691E-08  -2.40057623170170E-19  -5.01487392462420E-01  -5.01487392462318E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02453840194449E-10   0.00000000000000E+00  -1.02453840194449E-10
      1.20953835372930E-18  -8.53283783562761E-03  -3.39906683489042E-03   0.00000000000000E+00   4.45905144188808E-14
     -3.76649991595457E-24  -1.62941780706891E-08  -1.62941334801746E-08  -9.69480730559129E-19
      3.65276571874999E-07
      0.00000000000000E+00  -1.62438439119976E-11   0.00000000000000E+00  -3.47969496738574E-15   3.07395872979558E-24
      1.62438061502772E-08   1.62438026705822E-08  -1.92318900818035E-19  -5.22529906308402E-01  -5.22529906308297E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04744822986607E-10   0.00000000000000E+00  -1.04744822986607E-10
      1.00004870775608E-18  -8.16539826005159E-03  -3.08048375130706E-03   0.00000000000000E+00   3.25222572612323E-14
     -3.30011809619236E-24  -1.61390903698529E-08  -1.61390578475956E-08  -8.07729806938046E-19
      3.67276571874999E-07
      0.00000000000000E+00  -1.61818487143825E-11   0.00000000000000E+00  -1.26427476750328E-15   2.80988415842542E-24
      1.61818579642161E-08   1.61818566999413E-08  -1.46877238567444E-19  -5.43143763148174E-01  -5.43143763148068E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06578747231625E-10   0.00000000000000E+00  -1.06578747231625E-10
      7.86891213292833E-19  -7.92140708296957E-03  -2.85658537697225E-03   0.00000000000000E+00   2.72848844318988E-14
     -2.95979024938887E-24  -1.60753052375941E-08  -1.60752779527097E-08  -6.40013974725389E-19
      3.69276571874999E-07
      0.00000000000000E+00  -1.61491519879366E-11   0.00000000000000E+00  -5.67296412714903E-16   2.60870616154286E-24
      1.61491222226612E-08   1.61491216553648E-08  -1.03577982690492E-19  -5.63336026606763E-01  -5.63336026606655E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07858493007225E-10   0.00000000000000E+00  -1.07858493007225E-10
      5.71174227278383E-19  -7.74254415328778E-03  -2.68843760363169E-03   0.00000000000000E+00   2.41444638086837E-14
     -2.69802182674731E-24  -1.60412873068214E-08  -1.60412631623576E-08  -4.67596244587890E-19
      3.71276571874999E-07
      0.00000000000000E+00  -1.61284869220649E-11   0.00000000000000E+00  -5.29223579937292E-16   2.44938603841154E-24
      1.61285123034767E-08   1.61285117742531E-08  -6.22741300299806E-20  -5.83103522366050E-01  -5.83103522365941E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08561624253065E-10   0.00000000000000E+00  -1.08561624253065E-10
      3.54050978772253E-19  -7.60420769181405E-03  -2.55681438895012E-03   0.00000000000000E+00   2.20914645058607E-14
     -2.49027271788324E-24  -1.60199722414645E-08  -1.60199501500000E-08  -2.91776848742272E-19
      3.73276571874999E-07
      0.00000000000000E+00  -1.61135162299001E-11   0.00000000000000E+00  -1.89207890866194E-16   2.32022300085687E-24
      1.61135437776852E-08   1.61135435884773E-08  -2.30449630271627E-20  -6.02330859786970E-01  -6.02330859786862E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08112546103914E-10   0.00000000000000E+00  -1.08112546103914E-10
      1.37825886564424E-19  -7.49331640857716E-03  -2.45049622494729E-03   0.00000000000000E+00   1.99289379064271E-14
     -2.32225735993525E-24  -1.60054509713113E-08  -1.60054310423734E-08  -1.14780923537262E-19
      3.75276571874999E-07
      0.00000000000000E+00  -1.60939533008749E-11   0.00000000000000E+00  -2.43032000702128E-16   2.22049461989989E-24
      1.60939892323104E-08   1.60939889892784E-08   1.34590593610058E-20  -6.20605085808374E-01  -6.20605085808269E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04773567213449E-10   0.00000000000000E+00  -1.04773567213449E-10
     -7.17212478624729E-20  -7.41326822963985E-03  -2.37555589653576E-03   0.00000000000000E+00   1.79603096625513E-14
     -2.19397848707265E-24  -1.59892333823746E-08  -1.59892154220650E-08   5.82621885014673E-20
      3.77276571874999E-07
      0.00000000000000E+00  -1.60688796876173E-11   0.00000000000000E+00  -4.56532832282042E-16   2.14808550355654E-24
      1.60689172913674E-08   1.60689168348345E-08   4.61501056595752E-20  -6.37269739818246E-01  -6.37269739818149E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70596543675613E-11   0.00000000000000E+00  -9.70596543675613E-11
     -2.65840556597596E-19  -7.36612724860249E-03  -2.33388294359291E-03   0.00000000000000E+00   1.57761698816091E-14
     -2.10258864005731E-24  -1.59718729566368E-08  -1.59718571804670E-08   2.19690450938020E-19
      3.79276571874999E-07
      0.00000000000000E+00  -1.60473880191107E-11   0.00000000000000E+00  -3.99377859784313E-16   2.09218618168328E-24
      1.60473974074905E-08   1.60473970081127E-08   7.31757513257495E-20  -6.51256338406611E-01  -6.51256338406528E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.25141280622324E-11   0.00000000000000E+00  -8.25141280622324E-11
     -4.30868812722060E-19  -7.33144304242766E-03  -2.30139531002251E-03   0.00000000000000E+00   1.26158950086888E-14
     -2.03306079129972E-24  -1.59648954959454E-08  -1.59648828800504E-08   3.57693061396310E-19
      3.81276571874999E-07
      0.00000000000000E+00  -1.60169874110950E-11   0.00000000000000E+00  -6.66376099118813E-16   2.05388643742895E-24
      1.60169718765399E-08   1.60169712101638E-08   9.17795365431473E-20  -6.60989868255112E-01  -6.60989868255054E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.79519181478585E-11   0.00000000000000E+00  -5.79519181478585E-11
     -5.46772649017777E-19  -7.30691493202317E-03  -2.27871408322156E-03   0.00000000000000E+00   8.59627326430265E-15
     -1.98754742059302E-24  -1.59590278882892E-08  -1.59590192920160E-08   4.54993112474630E-19
      3.82276571874999E-07
      0.00000000000000E+00  -1.59964141899605E-11   0.00000000000000E+00  -9.50986391047334E-16   2.03979021364951E-24
      1.59964531041323E-08   1.59964521531459E-08   9.82281651152561E-20  -6.64382949043379E-01  -6.64382949043338E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.06037429496070E-11   0.00000000000000E+00  -4.06037429496070E-11
     -5.87376391967384E-19  -7.29735576279228E-03  -2.27015377265045E-03   0.00000000000000E+00   5.96906958754640E-15
     -1.97202413064608E-24  -1.59558543792659E-08  -1.59558484101963E-08   4.89148226852128E-19
      3.83626571874999E-07
      0.00000000000000E+00  -1.59628908608798E-11   0.00000000000000E+00  -1.10476802001682E-15   2.03122897352842E-24
      1.59628625405337E-08   1.59628614357657E-08   1.00754951117721E-19  -6.65713755539051E-01  -6.65713755539039E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18340854432269E-11   0.00000000000000E+00  -1.18340854432269E-11
     -6.03352407315741E-19  -7.29013633607035E-03  -2.26445327023381E-03   0.00000000000000E+00   1.75476835036390E-15
     -1.96528526634069E-24  -1.59510291050908E-08  -1.59510273503225E-08   5.02597456198020E-19
      3.85449071874999E-07
      0.00000000000000E+00  -1.59064981922344E-11   0.00000000000000E+00  -1.13929868546576E-15   2.04309613972734E-24
      1.59064580599659E-08   1.59064569206672E-08   9.01537985095472E-20  -6.60129515952552E-01  -6.60129515952588E-01
      0.00000000000000E+00   0.00000000000000E+00   3.66246522496931E-11   0.00000000000000E+00   3.66246522496931E-11
     -5.36603978590675E-19  -7.29322760742545E-03  -2.27004842231374E-03   0.00000000000000E+00  -5.46689596772277E-15
     -1.98848008351920E-24  -1.59430761060210E-08  -1.59430815729169E-08   4.46450180081128E-19
      3.87449071874999E-07
      0.00000000000000E+00  -1.58273280287615E-11   0.00000000000000E+00  -8.58017105459554E-16   2.09543502206672E-24
      1.58273824402695E-08   1.58273815822524E-08   5.65729513156720E-20  -6.42628679151166E-01  -6.42628679151270E-01
      0.00000000000000E+00   0.00000000000000E+00   1.03762815074904E-10   0.00000000000000E+00   1.03762815074904E-10
     -3.29078348440867E-19  -7.31814587588747E-03  -2.29872897184121E-03   0.00000000000000E+00  -1.62877813120228E-14
     -2.06964360153554E-24  -1.59311281095460E-08  -1.59311443973273E-08   2.72505397125196E-19
      3.89449071874999E-07
      0.00000000000000E+00  -1.57239108546658E-11   0.00000000000000E+00  -6.49084826757142E-16   2.21371579363946E-24
      1.57238770371843E-08   1.57238763880995E-08  -6.40940262178544E-21  -6.10593685464119E-01  -6.10593685464305E-01
      0.00000000000000E+00   0.00000000000000E+00   1.86111687078429E-10   0.00000000000000E+00   1.86111687078429E-10
      4.31450257159922E-20  -7.38227204660160E-03  -2.36952308652833E-03   0.00000000000000E+00  -3.13722914474823E-14
     -2.24948680419618E-24  -1.59099567028865E-08  -1.59099880751779E-08  -3.67356230942077E-20
      3.91449071874999E-07
      0.00000000000000E+00  -1.55403132249879E-11   0.00000000000000E+00   4.76255352852100E-16   2.51637889941405E-24
      1.55403057133136E-08   1.55403061895690E-08  -1.09864508626118E-19  -5.60337438007866E-01  -5.60337438008146E-01
      0.00000000000000E+00   0.00000000000000E+00   2.79930801417377E-10   0.00000000000000E+00   2.79930801417377E-10
      6.03006628550746E-19  -7.61898627960731E-03  -2.63452018758289E-03   0.00000000000000E+00  -5.55952362169556E-14
     -2.72560516576662E-24  -1.58201813957501E-08  -1.58202369909864E-08  -4.93142119924627E-19
      3.93449071874999E-07
      0.00000000000000E+00  -1.52145399421128E-11   0.00000000000000E+00  -2.75356013521125E-14   3.28386972366431E-24
      1.52145761102032E-08   1.52145485746019E-08  -2.70415611601746E-19  -4.88346160170009E-01  -4.88346160170374E-01
      0.00000000000000E+00   0.00000000000000E+00   3.65692869604942E-10   0.00000000000000E+00   3.65692869604942E-10
      1.33439236776063E-18  -8.31852986110842E-03  -3.40967997390522E-03   0.00000000000000E+00  -6.91104232638193E-14
     -4.18659003925420E-24  -1.55801723337836E-08  -1.55802414442068E-08  -1.06397675615888E-18
      3.95449071874999E-07
      0.00000000000000E+00  -1.37692711574152E-11   0.00000000000000E+00  -5.76973248004347E-14   5.38736407366449E-24
      1.37692789539265E-08   1.37692212566017E-08  -5.03623058132166E-19  -3.92813224412796E-01  -3.92813224413197E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00667352719494E-10   0.00000000000000E+00   4.00667352719494E-10
      2.13572707319962E-18  -1.17587533704425E-02  -7.29427946898087E-03   0.00000000000000E+00  -1.38147058544394E-13
     -1.34319957937573E-23  -1.41697504622626E-08  -1.41698886093212E-08  -1.63210401506745E-18
      3.97449071874999E-07
      0.00000000000000E+00  -5.21319912863643E-12   0.00000000000000E+00  -1.92703539513328E-13  -9.30297177656129E-24
      5.21340849274961E-09   5.21321578921009E-09  -7.72682981773603E-19  -2.75809961439653E-01  -2.75809961440061E-01
      0.00000000000000E+00   0.00000000000000E+00   4.07731375092506E-10   0.00000000000000E+00   4.07731375092506E-10
      2.95118982338463E-18  -3.18321053031680E-02  -3.00611543452847E-02   0.00000000000000E+00  -2.99942267707123E-13
     -6.83643116848509E-23  -5.62064722203482E-09  -5.62094716430260E-09  -2.17850684161103E-18
      3.99449071874999E-07
      0.00000000000000E+00  -2.16018821912103E-13   0.00000000000000E+00  -1.30060389038355E-13  -4.18246066716879E-23
      2.16126553769495E-10   2.15996493380415E-10  -1.03544165234378E-18  -1.49412989014449E-01  -1.49412989014839E-01
      0.00000000000000E+00   0.00000000000000E+00   3.89475232860102E-10   0.00000000000000E+00   3.89475232860102E-10
      3.73014028910484E-18  -6.12989345138164E-02  -6.11081742840629E-02   0.00000000000000E+00  -8.57894687738360E-13
     -8.99672527199492E-23  -6.04613831552688E-10  -6.05471726240517E-10  -2.69469863676106E-18
      4.01449071874999E-07
      0.00000000000000E+00   8.12825924286612E-14   0.00000000000000E+00  -1.39831872097063E-14  -4.57887167186610E-23
     -8.12839537445803E-11  -8.12979369318358E-11  -1.22051230185404E-18  -5.70009703002073E-02  -5.70009703004864E-02
      0.00000000000000E+00   0.00000000000000E+00   2.79124252279940E-10   0.00000000000000E+00   2.79124252279940E-10
      4.28838879366472E-18  -9.09675843880971E-02  -9.09052571937671E-02   0.00000000000000E+00  -1.21951715872390E-12
     -1.00655362626569E-22  -1.96606798189280E-10  -1.97826315348105E-10  -3.06787649181068E-18
      4.03449071874999E-07
      0.00000000000000E+00   3.49928448760677E-14   0.00000000000000E+00  -1.04251916829485E-15  -4.63740673292456E-23
     -3.50202608120004E-11  -3.50213033312150E-11  -1.29086510808362E-18  -2.29048898166597E-02  -2.29048898168075E-02
      0.00000000000000E+00   0.00000000000000E+00   1.47842295111871E-10   0.00000000000000E+00   1.47842295111871E-10
      4.58407338388846E-18  -1.20199817490339E-01  -1.20164272408185E-01   0.00000000000000E+00  -7.50976912301133E-13
     -1.05738451370717E-22  -1.12070014868248E-10  -1.12820991780655E-10  -3.29320827580483E-18
      4.05449071874999E-07
      0.00000000000000E+00   2.75534211622580E-15   0.00000000000000E+00   7.89104954713369E-16  -4.63044727906662E-23
     -2.72776806919074E-12  -2.72697896428233E-12  -1.31353652416166E-18  -1.28494851211476E-02  -1.28494851212354E-02
      0.00000000000000E+00   0.00000000000000E+00   8.78091165491202E-11   0.00000000000000E+00   8.78091165491202E-11
      4.75969161698670E-18  -1.48886052481806E-01  -1.48859247028258E-01   0.00000000000000E+00  -4.77431542415297E-13
     -1.08590365955631E-22  -8.46047060423143E-11  -8.50821375848382E-11  -3.44615509282504E-18
      4.07449071874999E-07
      0.00000000000000E+00  -1.62565184857322E-14   0.00000000000000E+00   9.06406843170283E-16  -4.58286657266261E-23
      1.62924541165130E-11   1.62933605233103E-11  -1.31980768625829E-18  -9.87678050126803E-03  -9.87678050132973E-03
      0.00000000000000E+00   0.00000000000000E+00   6.16997536504601E-11   0.00000000000000E+00   6.16997536504601E-11
      4.88309112428762E-18  -1.76992506541702E-01  -1.76967934721913E-01   0.00000000000000E+00  -4.15642236557463E-13
     -1.10930532161888E-22  -7.75774719371014E-11  -7.79931141737698E-11  -3.56328343802932E-18
      4.09449071874999E-07
      0.00000000000000E+00  -2.97576948552387E-14   0.00000000000000E+00   7.41236952938464E-16  -4.46850135234064E-23
      2.97774614134991E-11   2.97782026504074E-11  -1.32017061147035E-18  -8.83157228476551E-03  -8.83157228481377E-03
      0.00000000000000E+00   0.00000000000000E+00   4.82571671675576E-11   0.00000000000000E+00   4.82571671675576E-11
      4.97960545862273E-18  -2.04517991423739E-01  -2.04493406479427E-01   0.00000000000000E+00  -4.21627841500428E-13
     -1.13210744963159E-22  -7.76137419763515E-11  -7.80353698179652E-11  -3.65943484715238E-18
      4.11449071874999E-07
      0.00000000000000E+00  -4.06872185829343E-14   0.00000000000000E+00   5.77161263666687E-16  -4.23777482730997E-23
      4.06750984595168E-11   4.06756756207381E-11  -1.31822342166244E-18  -8.33972296061876E-03  -8.33972296065887E-03
      0.00000000000000E+00   0.00000000000000E+00   4.01079070500692E-11   0.00000000000000E+00   4.01079070500692E-11
      5.05982127272287E-18  -2.31474437616788E-01  -2.31448987050520E-01   0.00000000000000E+00  -4.41011314874540E-13
     -1.15518282726481E-22  -8.03425713558173E-11  -8.07835826708073E-11  -3.74159785106043E-18
      4.13449071874999E-07
      0.00000000000000E+00  -5.01472265153096E-14   0.00000000000000E+00   4.60043240697849E-16  -3.83129038190597E-23
      5.01386642508989E-11   5.01391242941012E-11  -1.31537351301143E-18  -8.04116027265072E-03  -8.04116027268539E-03
      0.00000000000000E+00   0.00000000000000E+00   3.46677651396057E-11   0.00000000000000E+00   3.46677651396057E-11
      5.12915680300208E-18  -2.57876742010757E-01  -2.57850024138988E-01   0.00000000000000E+00  -4.60403501657115E-13
     -1.17858463451257E-22  -8.43464859319319E-11  -8.48068894337068E-11  -3.81378328999065E-18
      4.15449071874999E-07
      0.00000000000000E+00  -5.86887870756096E-14   0.00000000000000E+00   3.82194336808511E-16  -3.18750190988123E-23
      5.87014724297531E-11   5.87018546240580E-11  -1.31224294462144E-18  -7.83182339540606E-03  -7.83182339543690E-03
      0.00000000000000E+00   0.00000000000000E+00   3.08354443750411E-11   0.00000000000000E+00   3.08354443750411E-11
      5.19082769175217E-18  -2.83736663937705E-01  -2.83708456026656E-01   0.00000000000000E+00  -4.78127916946291E-13
     -1.20225348663446E-22  -8.90591710820328E-11  -8.95372989990993E-11  -3.87858474713073E-18
      4.17449071874999E-07
      0.00000000000000E+00  -6.66792792126644E-14   0.00000000000000E+00   3.30943382801268E-16  -2.25408567347193E-23
      6.66613611833664E-11   6.66616921267266E-11  -1.30911886534232E-18  -7.67398176949070E-03  -7.67398176951872E-03
      0.00000000000000E+00   0.00000000000000E+00   2.80203051673759E-11   0.00000000000000E+00   2.80203051673759E-11
      5.24686830208692E-18  -3.09059402956217E-01  -3.09029574522229E-01   0.00000000000000E+00  -4.95148021914263E-13
     -1.22616040806092E-22  -9.41868492720660E-11  -9.46819972941028E-11  -3.93774943674460E-18
      4.19449071874999E-07
      0.00000000000000E+00  -7.42105476636816E-14   0.00000000000000E+00   2.97004775489237E-16  -1.00593490498025E-23
      7.42148324774601E-11   7.42151294822255E-11  -1.30612758156956E-18  -7.54964868370386E-03  -7.54964868372972E-03
      0.00000000000000E+00   0.00000000000000E+00   2.58641045386623E-11   0.00000000000000E+00   2.58641045386623E-11
      5.29859651116424E-18  -3.33849873804815E-01  -3.33818345322834E-01   0.00000000000000E+00  -5.12897547116361E-13
     -1.25033420691477E-22  -9.95663364736462E-11  -1.00079234020888E-10  -3.99246892959468E-18
      4.21449071874999E-07
      0.00000000000000E+00  -8.14662819030762E-14   0.00000000000000E+00   2.74153732837931E-16   5.28567504658800E-24
      8.14953696342018E-11   8.14956437879399E-11  -1.30331519835752E-18  -7.44862944187325E-03  -7.44862944189738E-03
      0.00000000000000E+00   0.00000000000000E+00   2.41365749807543E-11   0.00000000000000E+00   2.41365749807543E-11
      5.34686966112575E-18  -3.58114558544423E-01  -3.58081280983809E-01   0.00000000000000E+00  -5.32615372145083E-13
     -1.27484637466740E-22  -1.05099603396422E-10  -1.05632218768694E-10  -4.04355446276823E-18
      4.23449071874999E-07
      0.00000000000000E+00  -8.86301714052633E-14   0.00000000000000E+00   2.62529745779056E-16   2.20489371795835E-23
      8.86698002715415E-11   8.86700628013094E-11  -1.30063851468083E-18  -7.38933546811254E-03  -7.38933546813516E-03
      0.00000000000000E+00   0.00000000000000E+00   2.26266857926253E-11   0.00000000000000E+00   2.26266857926253E-11
      5.39212303271100E-18  -3.81841566350040E-01  -3.81806504609947E-01   0.00000000000000E+00  -5.53873234135728E-13
     -1.29973180241427E-22  -1.10742875359669E-10  -1.11296748593935E-10  -4.09148451803017E-18
      4.25449071874999E-07
      0.00000000000000E+00  -9.57022161702429E-14   0.00000000000000E+00   2.52173237151984E-16   3.90465011518254E-23
      9.57344489000647E-11   9.57347010733409E-11  -1.29811740110399E-18  -7.34886801281415E-03  -7.34886801283556E-03
      0.00000000000000E+00   0.00000000000000E+00   2.14029178324530E-11   0.00000000000000E+00   2.14029178324530E-11
      5.43492886837590E-18  -4.05139454772838E-01  -4.05102553340709E-01   0.00000000000000E+00  -5.82266253447258E-13
     -1.32525039004349E-22  -1.16555352652214E-10  -1.17137618905793E-10  -4.13681146727191E-18
      4.26449071874999E-07
      0.00000000000000E+00  -9.92841609213364E-14   0.00000000000000E+00   2.49580624259309E-16   4.78202009709139E-23
      9.92861973190475E-11   9.92864468997196E-11  -1.29689646281766E-18  -7.33170840819891E-03  -7.33170840821974E-03
      0.00000000000000E+00   0.00000000000000E+00   2.08296315008654E-11   0.00000000000000E+00   2.08296315008654E-11
      5.45575849987677E-18  -4.16714127374163E-01  -4.16676287828568E-01   0.00000000000000E+00  -6.08780060558639E-13
     -1.33832754552470E-22  -1.19507298339894E-10  -1.20116078400587E-10  -4.15886203705911E-18
      4.27799071874999E-07
      0.00000000000000E+00  -1.04060087256128E-13   0.00000000000000E+00   2.43698604576856E-16   5.89492359993637E-23
      1.04026235475768E-10   1.04026479174431E-10  -1.29531591861089E-18  -7.31305951943580E-03  -7.31305951945592E-03
      0.00000000000000E+00   0.00000000000000E+00   2.01234833109514E-11   0.00000000000000E+00   2.01234833109514E-11
      5.48292520234656E-18  -4.32164526030967E-01  -4.32125415979259E-01   0.00000000000000E+00  -6.30238167078672E-13
     -1.35630918148356E-22  -1.23519724318169E-10  -1.24149962485383E-10  -4.18760928373566E-18
      4.29621571874999E-07
      0.00000000000000E+00  -1.10305529386240E-13   0.00000000000000E+00   2.37203343485331E-16   7.23257763942153E-23
      1.10340245953679E-10   1.10340483157095E-10  -1.29329211278668E-18  -7.29673927418015E-03  -7.29673927419936E-03
      0.00000000000000E+00   0.00000000000000E+00   1.92049734616639E-11   0.00000000000000E+00   1.92049734616639E-11
      5.51792626648044E-18  -4.52657149892173E-01  -4.52616340528591E-01   0.00000000000000E+00  -6.59002021256240E-13
     -1.38108797443143E-22  -1.28886454597365E-10  -1.29545456618759E-10  -4.22463415369376E-18
      4.31621571874999E-07
      0.00000000000000E+00  -1.17193884676804E-13   0.00000000000000E+00   2.32045849434335E-16   8.49754733532733E-23
      1.17206589252152E-10   1.17206821298087E-10  -1.29118375209401E-18  -7.29194325120487E-03  -7.29194325122310E-03
      0.00000000000000E+00   0.00000000000000E+00   1.82248238030079E-11   0.00000000000000E+00   1.82248238030079E-11
      5.55437591408645E-18  -4.74693564847642E-01  -4.74650901685337E-01   0.00000000000000E+00  -6.95277585794965E-13
     -1.40886632439334E-22  -1.34736367515158E-10  -1.35431645101094E-10  -4.26319216199245E-18
      4.33621571874999E-07
      0.00000000000000E+00  -1.24082239967369E-13   0.00000000000000E+00   2.28627116845898E-16   9.56004894891453E-23
      1.24041157603943E-10   1.24041386231155E-10  -1.28916446142251E-18  -7.30486075931166E-03  -7.30486075932894E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72729073360474E-11   0.00000000000000E+00   1.72729073360474E-11
      5.58892172875855E-18  -4.96281781442369E-01  -4.96237265658761E-01   0.00000000000000E+00  -7.35038080384360E-13
     -1.43713922356767E-22  -1.40579255486675E-10  -1.41314293567203E-10  -4.29975726733604E-18
      4.35621571874999E-07
      0.00000000000000E+00  -1.30878750520726E-13   0.00000000000000E+00   2.27505172042448E-16   1.04353218700496E-22
      1.30885895694614E-10   1.30886123199890E-10  -1.28720169648840E-18  -7.34440807407902E-03  -7.34440807409537E-03
      0.00000000000000E+00   0.00000000000000E+00   1.63528485988057E-11   0.00000000000000E+00   1.63528485988057E-11
      5.62162742595616E-18  -5.17430306054130E-01  -5.17383924476867E-01   0.00000000000000E+00  -7.75514108051444E-13
     -1.46572867132241E-22  -1.46463457690498E-10  -1.47238971798696E-10  -4.33442572946777E-18
      4.37621571874999E-07
      0.00000000000000E+00  -1.38042640022913E-13   0.00000000000000E+00   2.41538218178778E-16   1.11695280473268E-22
      1.38085335680314E-10   1.38085577218644E-10  -1.28513539334502E-18  -7.47904353217073E-03  -7.47904353218609E-03
      0.00000000000000E+00   0.00000000000000E+00   1.53653835386595E-11   0.00000000000000E+00   1.53653835386595E-11
      5.65235819303348E-18  -5.38148089428752E-01  -5.38099751627293E-01   0.00000000000000E+00  -8.12518817942151E-13
     -1.49432214103233E-22  -1.52638441939212E-10  -1.53450960757304E-10  -4.36722279968847E-18
      4.39621571874999E-07
      0.00000000000000E+00  -1.46492355846005E-13   0.00000000000000E+00   2.90425820258753E-16   1.18389042041751E-22
      1.46458077853237E-10   1.46458368279176E-10  -1.28259790649928E-18  -7.86931710427294E-03  -7.86931710428708E-03
      0.00000000000000E+00   0.00000000000000E+00   1.41464303091900E-11   0.00000000000000E+00   1.41464303091900E-11
      5.68065105365186E-18  -5.58442831332906E-01  -5.58392240706662E-01   0.00000000000000E+00  -8.39695221234652E-13
     -1.52245702779811E-22  -1.59765103366979E-10  -1.60604798588366E-10  -4.39805314715258E-18
      4.41621571874999E-07
      0.00000000000000E+00  -1.60269066427134E-13   0.00000000000000E+00   5.15864229280753E-16   1.27157709937807E-22
      1.60309258804869E-10   1.60309774669225E-10  -1.27786677816324E-18  -9.29551279798884E-03  -9.29551279800042E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15817293315853E-11   0.00000000000000E+00   1.15817293315853E-11
      5.70381451231503E-18  -5.78315835957656E-01  -5.78261690785809E-01   0.00000000000000E+00  -8.23865567052128E-13
     -1.54874523007519E-22  -1.71067638433604E-10  -1.71891504000811E-10  -4.42594773415180E-18
      4.43621571874999E-07
      0.00000000000000E+00  -2.24652227209610E-13   0.00000000000000E+00   2.44483326009693E-15   1.61697332629625E-22
      2.24619609690077E-10   2.24622054523499E-10  -1.25592731316171E-18  -1.85611696797725E-02  -1.85611696797692E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.32187194507048E-12   0.00000000000000E+00  -3.32187194507048E-12
      5.69717076842489E-18  -5.97702347076189E-01  -5.97632639587079E-01   0.00000000000000E+00  -4.54353284249067E-13
     -1.56269302015208E-22  -2.20845829294021E-10  -2.21300182578427E-10  -4.44124345526318E-18
      4.45621571874999E-07
      0.00000000000000E+00  -4.99176146722908E-13   0.00000000000000E+00   8.97206635183715E-15   2.58434912377368E-22
      4.99188438425609E-10   4.99197410492219E-10  -1.19144840483659E-18  -4.58913818943513E-02  -4.58913818943114E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.98816458595746E-11   0.00000000000000E+00  -3.98816458595746E-11
      5.61740747670574E-18  -6.16247034115683E-01  -6.16102354683938E-01   0.00000000000000E+00   4.30874257691828E-13
     -1.54936420827468E-22  -4.59746638890181E-10  -4.59315764632644E-10  -4.42595907186914E-18
      4.47621571874999E-07
      0.00000000000000E+00  -1.06365390160037E-12   0.00000000000000E+00   1.59042095633233E-14   3.29672822930620E-22
      1.06361352111988E-09   1.06362942532977E-09  -1.11711750907336E-18  -7.56805138003783E-02  -7.56805138003250E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.32614140816907E-11   0.00000000000000E+00  -5.32614140816907E-11
      5.51088464854236E-18  -6.33360477438789E-01  -6.33042219688780E-01   0.00000000000000E+00   4.93021248724606E-13
     -1.53366602854931E-22  -1.01086103249665E-09  -1.01036801124808E-09  -4.39376713946900E-18
      4.49621571874999E-07
      0.00000000000000E+00  -2.13419615849130E-12   0.00000000000000E+00   2.80745991541395E-14   3.74222502671697E-22
      2.13419067403657E-09   2.13421874863610E-09  -1.04463067741172E-18  -1.05162291805563E-01  -1.05162291805500E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.31301378059602E-11   0.00000000000000E+00  -6.31301378059602E-11
      5.38462437293044E-18  -6.48083411289745E-01  -6.47431030176548E-01   0.00000000000000E+00   4.14506869212854E-13
     -1.51988619591317E-22  -2.07150311769920E-09  -2.07108861083014E-09  -4.33999369551872E-18
      4.50621571874999E-07
      0.00000000000000E+00  -2.96428889337293E-12   0.00000000000000E+00   4.24488555095723E-14   4.00563664670246E-22
      2.96423705339630E-09   2.96427950225221E-09  -1.00996148446883E-18  -1.19788284428066E-01  -1.19788284427996E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.96962029434997E-11   0.00000000000000E+00  -6.96962029434997E-11
      5.31492816998694E-18  -6.54566250653744E-01  -6.53654470494688E-01   0.00000000000000E+00   3.48619505983700E-13
     -1.51383966654465E-22  -2.89493191881454E-09  -2.89458329930871E-09  -4.30496668551810E-18
      4.51971571874999E-07
      0.00000000000000E+00  -4.45630664930920E-12   0.00000000000000E+00   5.58892940983892E-14   4.25464211880154E-22
      4.45623598255194E-09   4.45629187184646E-09  -9.66688284789327E-19  -1.39284729652974E-01  -1.39284729652895E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.91773645225116E-11   0.00000000000000E+00  -7.91773645225116E-11
      5.20803872788155E-18  -6.61250563984418E-01  -6.59871788491372E-01   0.00000000000000E+00   2.72775832514943E-13
     -1.50715252035888E-22  -4.37738728315631E-09  -4.37711450732395E-09  -4.24135044309222E-18
      4.53794071874999E-07
      0.00000000000000E+00  -7.23323227877877E-12   0.00000000000000E+00   7.63464853680705E-14   4.44625047029543E-22
      7.23312797027102E-09   7.23320431675684E-09  -9.14116984612843E-19  -1.65123302877130E-01  -1.65123302877037E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.31491400802836E-11   0.00000000000000E+00  -9.31491400802836E-11
      5.03827442008523E-18  -6.65226450802635E-01  -6.62977349076033E-01   0.00000000000000E+00   2.16581269987576E-13
     -1.49947196063600E-22  -7.14027175794640E-09  -7.14005517667656E-09  -4.12415743547239E-18
      4.55794071874999E-07
      0.00000000000000E+00  -1.14329247323301E-11   0.00000000000000E+00   1.04620395412089E-13   4.55910362039481E-22
      1.14327859078360E-08   1.14328905282319E-08  -8.61929349868560E-19  -1.92893926037501E-01  -1.92893926037392E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08582663297358E-10   0.00000000000000E+00  -1.08582663297358E-10
      4.82110909349052E-18  -6.61395704671090E-01  -6.57828550434911E-01   0.00000000000000E+00   2.84449017902314E-13
     -1.48817416913586E-22  -1.13245923139522E-08  -1.13243078649345E-08  -3.95917974362196E-18
      4.57794071874999E-07
      0.00000000000000E+00  -1.70277387440638E-11   0.00000000000000E+00   1.39034804131034E-13   4.57244942213992E-22
      1.70275580115478E-08   1.70276970463524E-08  -8.13352153042518E-19  -2.20089643077207E-01  -2.20089643077085E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21894162280094E-10   0.00000000000000E+00  -1.21894162280094E-10
      4.57732076893033E-18  -6.46820858407670E-01  -6.41495475388666E-01   0.00000000000000E+00   5.75461190265442E-13
     -1.46576663661469E-22  -1.69063783452625E-08  -1.69058028840723E-08  -3.76396861588781E-18
      4.59794071874999E-07
      0.00000000000000E+00  -2.42854017229398E-11   0.00000000000000E+00   1.80116480292688E-13   4.47749964426578E-22
      2.42852471556748E-08   2.42854272721556E-08  -7.66720020041781E-19  -2.46725240244185E-01  -2.46725240244053E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.31941490965894E-10   0.00000000000000E+00  -1.31941490965894E-10
      4.31343778699854E-18  -6.18475458640484E-01  -6.10866879955922E-01   0.00000000000000E+00   1.10282741093015E-12
     -1.42169197186912E-22  -2.41545886086005E-08  -2.41534857811897E-08  -3.54671776695676E-18
      4.61794071874999E-07
      0.00000000000000E+00  -3.35200226702078E-11   0.00000000000000E+00   2.29114626626134E-13   4.27167998669724E-22
      3.35197923674960E-08   3.35200214821230E-08  -7.20923364686658E-19  -2.72814340197276E-01  -2.72814340197136E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.39805515750610E-10   0.00000000000000E+00  -1.39805515750610E-10
      4.03382675549732E-18  -5.72774643861295E-01  -5.62259233122541E-01   0.00000000000000E+00   1.71785009712759E-12
     -1.34688396050571E-22  -3.33819338164694E-08  -3.33802159663724E-08  -3.31290339081066E-18
      4.63794071874999E-07
      0.00000000000000E+00  -4.47949744545410E-11   0.00000000000000E+00   2.79911061751837E-13   3.90298783315715E-22
      4.47946518494665E-08   4.47949317605286E-08  -6.75517725698515E-19  -2.98364939201809E-01  -2.98364939201661E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48554730440417E-10   0.00000000000000E+00  -1.48554730440417E-10
      3.73671729461649E-18  -5.06056773889657E-01  -4.91991762991755E-01   0.00000000000000E+00   2.10574700979086E-12
     -1.24273258645344E-22  -4.46484827770979E-08  -4.46463770300882E-08  -3.06119956891797E-18
      4.65794071874999E-07
      0.00000000000000E+00  -5.74267485416410E-11   0.00000000000000E+00   3.14035831687779E-13   3.23917989939271E-22
      5.74264218025720E-08   5.74267358384040E-08  -6.30598399815744E-19  -3.23380225179922E-01  -3.23380225179762E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.60758513753515E-10   0.00000000000000E+00  -1.60758513753515E-10
      3.41520026710946E-18  -4.16000427851284E-01  -3.97959150896652E-01   0.00000000000000E+00   2.05121692455763E-12
     -1.12618521049124E-22  -5.72680285415749E-08  -5.72659773246504E-08  -2.78460186729371E-18
      4.67794071874999E-07
      0.00000000000000E+00  -6.98574744989937E-11   0.00000000000000E+00   3.09633152800034E-13   2.52184456932108E-22
      6.98571292510164E-08   6.98574388841694E-08  -5.86178421754569E-19  -3.47868805488160E-01  -3.47868805487986E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.73732469087733E-10   0.00000000000000E+00  -1.73732469087733E-10
      3.06773532893399E-18  -3.03371371601412E-01  -2.81417203211007E-01   0.00000000000000E+00   1.75142851260775E-12
     -9.95888239068741E-23  -6.96854578435942E-08  -6.96837064150817E-08  -2.48155690717942E-18
      4.69794071874999E-07
      0.00000000000000E+00  -7.77128630276162E-11   0.00000000000000E+00   1.96169486142888E-13   1.77898579169230E-22
      7.77127234733592E-08   7.77129196428455E-08  -5.42787344744814E-19  -3.71824084244140E-01  -3.71824084243945E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.95215135832547E-10   0.00000000000000E+00  -1.95215135832547E-10
      2.67730505726890E-18  -1.77582243532653E-01  -1.53159321518281E-01   0.00000000000000E+00   1.16186236275907E-12
     -8.50640917650629E-23  -7.75188663693756E-08  -7.75177045070129E-08  -2.13451771252408E-18
      4.71794071874999E-07
      0.00000000000000E+00  -6.89512424769670E-11   0.00000000000000E+00  -2.17729918922383E-13   6.39424252114531E-23
      6.89514589422784E-08   6.89512412123595E-08  -4.98082656533481E-19  -3.95277616256380E-01  -3.95277616256174E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.05812082527873E-10   0.00000000000000E+00  -2.05812082527873E-10
      2.26568089221315E-18  -7.12934915325870E-02  -4.96341242894845E-02   0.00000000000000E+00   8.18453439083941E-13
     -5.41749269016458E-23  -6.87462475832706E-08  -6.87454291298316E-08  -1.76759823567967E-18
      4.73794071874999E-07
      0.00000000000000E+00  -3.79762374747798E-11   0.00000000000000E+00  -7.68234642134052E-13   1.81072319456465E-23
      3.79769744431570E-08   3.79762062085149E-08  -4.41942802898368E-19  -4.18384144570335E-01  -4.18384144570193E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42310868088351E-10   0.00000000000000E+00  -1.42310868088351E-10
      1.98105915603645E-18  -2.74173922142376E-02  -1.54971631728538E-02   0.00000000000000E+00   9.33837956748658E-13
     -1.81542462197198E-23  -3.78348291783833E-08  -3.78338953404265E-08  -1.53911635313808E-18
      4.75794071874999E-07
      0.00000000000000E+00  -2.26959367008264E-11   0.00000000000000E+00  -3.77363511986421E-13   7.63044924198361E-24
      2.26962948484261E-08   2.26959174849142E-08  -3.84748324335418E-19  -4.41095286084445E-01  -4.41095286084338E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06964350301179E-10   0.00000000000000E+00  -1.06964350301179E-10
      1.76713045543409E-18  -1.41507791504519E-02  -7.03372408814775E-03   0.00000000000000E+00   4.45086362736467E-13
     -8.35211989141428E-24  -2.25893982209757E-08  -2.25889531346130E-08  -1.38238213109867E-18
      4.75919071874999E-07
      0.00000000000000E+00  -2.17187086969383E-11   0.00000000000000E+00  -3.85676080226255E-13   7.08400074945957E-24
      2.17191306236651E-08   2.17187449475849E-08  -3.81177823352650E-19  -4.42512866674011E-01  -4.42512866673904E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07396558129916E-10   0.00000000000000E+00  -1.07396558129916E-10
      1.75370588566785E-18  -1.34441150290037E-02  -6.63507132811612E-03   0.00000000000000E+00   4.43742170981739E-13
     -8.01465572391935E-24  -2.16117921316260E-08  -2.16113483894550E-08  -1.37252806231520E-18
      4.76087821874999E-07
      0.00000000000000E+00  -2.06547792611263E-11   0.00000000000000E+00  -3.10954275141572E-13   6.57011077339486E-24
      2.06551023911387E-08   2.06547914368635E-08  -3.76389884210811E-19  -4.44423664906428E-01  -4.44423664906323E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05178774116862E-10   0.00000000000000E+00  -1.05178774116862E-10
      1.73595696753563E-18  -1.26697225550025E-02  -6.19519708180179E-03   0.00000000000000E+00   3.64948325682759E-13
     -7.50734991820388E-24  -2.05499776110724E-08  -2.05496126627467E-08  -1.35956708332482E-18
      4.76315634374999E-07
      0.00000000000000E+00  -1.95751443752518E-11   0.00000000000000E+00  -2.33608434273071E-13   6.06024083135302E-24
      1.95753401288231E-08   1.95751065203889E-08  -3.69981888081931E-19  -4.46997697328926E-01  -4.46997697328822E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03100150061283E-10   0.00000000000000E+00  -1.03100150061283E-10
      1.71246946459980E-18  -1.18702941063412E-02  -5.73528707251534E-03   0.00000000000000E+00   2.84381730668128E-13
     -6.93214271342031E-24  -1.94722907520582E-08  -1.94720063703276E-08  -1.34248757651786E-18
      4.76623181249999E-07
      0.00000000000000E+00  -1.85697200370410E-11   0.00000000000000E+00  -1.60999563532232E-13   5.56226599461102E-24
      1.85698079938849E-08   1.85696469943213E-08  -3.61418924000719E-19  -4.50462243616873E-01  -4.50462243616772E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01348005861933E-10   0.00000000000000E+00  -1.01348005861933E-10
      1.68130020210948E-18  -1.11002232899553E-02  -5.28145141027097E-03   0.00000000000000E+00   2.08570180763965E-13
     -6.35020503807345E-24  -1.84685075586402E-08  -1.84682989884594E-08  -1.31988127810876E-18
      4.77038369531249E-07
      0.00000000000000E+00  -1.77265853494759E-11   0.00000000000000E+00  -9.98358823360742E-14   5.09448655431759E-24
      1.77266866131227E-08   1.77265867772403E-08  -3.49994901717751E-19  -4.55120032511911E-01  -4.55120032511811E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00139904296299E-10   0.00000000000000E+00  -1.00139904296299E-10
      1.63972328736016E-18  -1.04103720983895E-02  -4.85683981637049E-03   0.00000000000000E+00   1.44382240016058E-13
     -5.79783410749784E-24  -1.76265912551840E-08  -1.76264468729440E-08  -1.28972838564240E-18
      4.77598873710936E-07
      0.00000000000000E+00  -1.71009389996182E-11   0.00000000000000E+00  -5.47032687781046E-14   4.66684637059095E-24
      1.71010589764582E-08   1.71010042731894E-08  -3.34786857153926E-19  -4.61372353236070E-01  -4.61372353235970E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.96383823583500E-11   0.00000000000000E+00  -9.96383823583500E-11
      1.58387555759100E-18  -9.82908752284224E-03  -4.47249698486009E-03   0.00000000000000E+00   9.64443946189735E-14
     -5.28863226715354E-24  -1.70014623352256E-08  -1.70013658908310E-08  -1.24908870043707E-18
      4.78355554353514E-07
      0.00000000000000E+00  -1.66934239006284E-11   0.00000000000000E+00  -2.62520182478145E-14   4.27390419140238E-24
      1.66934257781786E-08   1.66933995261604E-08  -3.14609109446924E-19  -4.69747727626403E-01  -4.69747727626303E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.98892181126158E-11   0.00000000000000E+00  -9.98892181126158E-11
      1.50829131984292E-18  -9.35171553475028E-03  -4.12362567377462E-03   0.00000000000000E+00   6.53101934971075E-14
     -4.81428620826344E-24  -1.65935756182413E-08  -1.65935103080478E-08  -1.19368221039599E-18
      4.79377073220995E-07
      0.00000000000000E+00  -1.64557297207354E-11   0.00000000000000E+00  -1.15352648987440E-14   3.90055255320801E-24
      1.64556973379733E-08   1.64556858027084E-08  -2.87979771946670E-19  -4.80936155496859E-01  -4.80936155496758E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00821713956829E-10   0.00000000000000E+00  -1.00821713956829E-10
      1.40530003678430E-18  -8.94860391039722E-03  -3.79570178938303E-03   0.00000000000000E+00   4.78491873401002E-14
     -4.35442861918175E-24  -1.63549119379389E-08  -1.63548640887516E-08  -1.11732026483763E-18
      4.80756123692094E-07
      0.00000000000000E+00  -1.63220037833612E-11   0.00000000000000E+00  -8.31010668924275E-15   3.53442823549425E-24
      1.63220196559655E-08   1.63220113458588E-08  -2.53118308813011E-19  -4.95827530364560E-01  -4.95827530364458E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02291009811088E-10   0.00000000000000E+00  -1.02291009811088E-10
      1.26423557151516E-18  -8.58703930571886E-03  -3.47671319978185E-03   0.00000000000000E+00   4.16469990276612E-14
     -3.89323889891236E-24  -1.62197619830467E-08  -1.62197203360477E-08  -1.01111726270215E-18
      4.82617841828077E-07
      0.00000000000000E+00  -1.62402619672465E-11   0.00000000000000E+00  -1.86641228369562E-15   3.17431774670922E-24
      1.62402253981280E-08   1.62402235317158E-08  -2.07996204153013E-19  -5.15550063723904E-01  -5.15550063723800E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04098521301801E-10   0.00000000000000E+00  -1.04098521301801E-10
      1.07043346647857E-18  -8.24971183772767E-03  -3.16572231317948E-03   0.00000000000000E+00   3.19221081000272E-14
     -3.43082261809634E-24  -1.61361569325221E-08  -1.61361250104140E-08  -8.62437262325558E-19
      4.84617841828077E-07
      0.00000000000000E+00  -1.61891044486219E-11   0.00000000000000E+00  -9.88859437318965E-16   2.88806103191690E-24
      1.61890894455656E-08   1.61890884567062E-08  -1.61806666932236E-19  -5.36306309982720E-01  -5.36306309982614E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06010677926727E-10   0.00000000000000E+00  -1.06010677926727E-10
      8.58412110625118E-19  -7.98954124560312E-03  -2.92226268144237E-03   0.00000000000000E+00   2.79349773720636E-14
     -3.06140051698927E-24  -1.60831057137568E-08  -1.60830777787794E-08  -6.96605443692881E-19
      4.86617841828077E-07
      0.00000000000000E+00  -1.61560403432272E-11   0.00000000000000E+00  -5.68201464369383E-16   2.67007942890918E-24
      1.61559972178922E-08   1.61559966496908E-08  -1.17810030042068E-19  -5.56639049934996E-01  -5.56639049934889E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07490614240123E-10   0.00000000000000E+00  -1.07490614240123E-10
      6.43430882144872E-19  -7.79580574947609E-03  -2.73941781925010E-03   0.00000000000000E+00   2.49059489084970E-14
     -2.77809677380752E-24  -1.60485309413996E-08  -1.60485060354507E-08  -5.25620852102804E-19
      4.88617841828077E-07
      0.00000000000000E+00  -1.61337220720858E-11   0.00000000000000E+00  -3.21658443654914E-16   2.49867549352157E-24
      1.61337302514720E-08   1.61337299298135E-08  -7.58512819264719E-20  -5.76551277784168E-01  -5.76551277784060E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08400447457958E-10   0.00000000000000E+00  -1.08400447457958E-10
      4.26629987228956E-19  -7.64647637850774E-03  -2.59738885354610E-03   0.00000000000000E+00   2.25188209367889E-14
     -2.55456529345963E-24  -1.60253520011765E-08  -1.60253294823556E-08  -3.50778705302484E-19
      4.90617841828077E-07
      0.00000000000000E+00  -1.61179247772861E-11   0.00000000000000E+00  -1.81076164372932E-16   2.36037324408537E-24
      1.61178826473144E-08   1.61178824662382E-08  -3.58691266186781E-20  -5.95997381689124E-01  -5.95997381689016E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08532939826127E-10   0.00000000000000E+00  -1.08532939826127E-10
      2.09564107576703E-19  -7.52763257592260E-03  -2.48357827057330E-03   0.00000000000000E+00   2.05432372215672E-14
     -2.37439342457376E-24  -1.60093700696493E-08  -1.60093495264121E-08  -1.73694980958025E-19
      4.92617841828077E-07
      0.00000000000000E+00  -1.61038725324933E-11   0.00000000000000E+00  -1.53126825728810E-16   2.24798127645573E-24
      1.61039027420376E-08   1.61039025889108E-08   1.64777936353051E-21  -6.14654860124489E-01  -6.14654860124383E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06343621062525E-10   0.00000000000000E+00  -1.06343621062525E-10
     -3.12313454834727E-21  -7.43114504958814E-03  -2.39080426860436E-03   0.00000000000000E+00   1.85942192629461E-14
     -2.22879971882970E-24  -1.59975775620675E-08  -1.59975589678483E-08   1.47535518481775E-21
      4.94617841828077E-07
      0.00000000000000E+00  -1.60745740613241E-11   0.00000000000000E+00  -5.53869163283994E-16   2.17011835838476E-24
      1.60745432264156E-08   1.60745426725465E-08   3.58029685387823E-20  -6.31964435657001E-01  -6.31964435656901E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00306419380942E-10   0.00000000000000E+00  -1.00306419380942E-10
     -2.03735973310232E-19  -7.37950958170446E-03  -2.34651602041211E-03   0.00000000000000E+00   1.67312924939799E-14
     -2.13037451120331E-24  -1.59742529844580E-08  -1.59742362531656E-08   1.67933004771449E-19
      4.96617841828077E-07
      0.00000000000000E+00  -1.60551029770361E-11   0.00000000000000E+00  -3.37369092586157E-16   2.10880556623557E-24
      1.60550711231669E-08   1.60550707857978E-08   6.50269789460249E-20  -6.47019631632729E-01  -6.47019631632641E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.84754357793207E-11   0.00000000000000E+00  -8.84754357793207E-11
     -3.80686844868873E-19  -7.34166824768784E-03  -2.31108121282002E-03   0.00000000000000E+00   1.37240960240596E-14
     -2.05350238966012E-24  -1.59666090741145E-08  -1.59665953500185E-08   3.15659865922848E-19
      4.98617841828077E-07
      0.00000000000000E+00  -1.60286516927204E-11   0.00000000000000E+00  -5.47536726049931E-16   2.06425451581246E-24
      1.60286083686458E-08   1.60286078211091E-08   8.68791143643120E-20  -6.58417921704484E-01  -6.58417921704416E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.76883562846350E-11   0.00000000000000E+00  -6.76883562846350E-11
     -5.16063557438143E-19  -7.31372847865071E-03  -2.28492909038661E-03   0.00000000000000E+00   1.01005721995765E-14
     -1.99941113618983E-24  -1.59609295653966E-08  -1.59609194648244E-08   4.29184443073831E-19
      5.00617841828077E-07
      0.00000000000000E+00  -1.59898013688816E-11   0.00000000000000E+00  -9.03523294384496E-16   2.03929426200630E-24
      1.59898241743149E-08   1.59898232707916E-08   9.80546184638073E-20  -6.64291098218393E-01  -6.64291098218358E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.51096825812718E-11   0.00000000000000E+00  -3.51096825812718E-11
     -5.86282922600686E-19  -7.29654582801777E-03  -2.26970138993852E-03   0.00000000000000E+00   5.19740923137223E-15
     -1.97220890717106E-24  -1.59547187856196E-08  -1.59547135882104E-08   4.88228304136879E-19
      5.02617841828077E-07
      0.00000000000000E+00  -1.59360721976152E-11   0.00000000000000E+00  -1.34252438846373E-15   2.03888741123537E-24
      1.59360882600267E-08   1.59360869175024E-08   9.45565936907157E-20  -6.62445782259511E-01  -6.62445782259522E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10151052305071E-11   0.00000000000000E+00   1.10151052305071E-11
     -5.64252712139672E-19  -7.29271193075801E-03  -2.26826575991446E-03   0.00000000000000E+00  -1.38548830091258E-15
     -1.97891330239955E-24  -1.59471006372446E-08  -1.59471020227329E-08   4.69696118448957E-19
      5.04617841828077E-07
      0.00000000000000E+00  -1.58651680604910E-11   0.00000000000000E+00   6.99607399885840E-15   2.07190600803912E-24
      1.58652514344706E-08   1.58652584305446E-08   7.15589124895365E-20  -6.50404038413482E-01  -6.50404038413554E-01
      0.00000000000000E+00   0.00000000000000E+00   7.16576687824250E-11   0.00000000000000E+00   7.16576687824250E-11
     -4.20937374574822E-19  -7.30709161886979E-03  -2.28585817882517E-03   0.00000000000000E+00  -1.90369888037274E-14
     -2.03253293114658E-24  -1.59368970623382E-08  -1.59369160993270E-08   3.49378462085286E-19
      5.06617841828077E-07
      0.00000000000000E+00  -1.57743336153927E-11   0.00000000000000E+00  -1.75104139683977E-15   2.15579808046660E-24
      1.57743262322193E-08   1.57743244811779E-08   2.26793189854317E-20  -6.25258834862920E-01  -6.25258834863067E-01
      0.00000000000000E+00   0.00000000000000E+00   1.47498156146897E-10   0.00000000000000E+00   1.47498156146897E-10
     -1.25941062281029E-19  -7.34897764676989E-03  -2.33249860203004E-03   0.00000000000000E+00  -2.30441447816443E-14
     -2.16035981648892E-24  -1.59217995931800E-08  -1.59218226373248E-08   1.03261743295597E-19
      5.08617841828077E-07
      0.00000000000000E+00  -1.56292189306048E-11   0.00000000000000E+00  -4.00916697784991E-15   2.36149260787034E-24
      1.56292669577072E-08   1.56292629485402E-08  -6.13210824554797E-20  -5.83537938789187E-01  -5.83537938789425E-01
      0.00000000000000E+00   0.00000000000000E+00   2.37336599764241E-10   0.00000000000000E+00   2.37336599764241E-10
      3.48732137247454E-19  -7.49636525811704E-03  -2.49728797697334E-03   0.00000000000000E+00  -3.96617708918664E-14
     -2.47626249350940E-24  -1.58665598865336E-08  -1.58665995483045E-08  -2.87411054791974E-19
      5.10617841828077E-07
      0.00000000000000E+00  -1.53934534901931E-11   0.00000000000000E+00  -6.56733426021572E-15   2.86482815367262E-24
      1.53934058325891E-08   1.53933992652549E-08  -1.94493995449266E-19  -5.21513237359132E-01  -5.21513237359463E-01
      0.00000000000000E+00   0.00000000000000E+00   3.30373221748873E-10   0.00000000000000E+00   3.30373221748873E-10
      1.00947858074520E-18  -7.91847333904210E-03  -2.96440230629772E-03   0.00000000000000E+00  -6.84732772394404E-14
     -3.33173137130002E-24  -1.57237040137265E-08  -1.57237724870037E-08  -8.14984585295933E-19
      5.12617841828077E-07
      0.00000000000000E+00  -1.47229869085782E-11   0.00000000000000E+00  -1.79218545705803E-14   4.28180504047485E-24
      1.47229526761457E-08   1.47229347542912E-08  -3.95400570919690E-19  -4.36454651195019E-01  -4.36454651195412E-01
      0.00000000000000E+00   0.00000000000000E+00   3.92567009065688E-10   0.00000000000000E+00   3.92567009065688E-10
      1.79461259887658E-18  -9.51947414561453E-03  -4.75706402151449E-03   0.00000000000000E+00  -1.22296687794256E-13
     -7.06787652332191E-24  -1.51153794666690E-08  -1.51155017633568E-08  -1.39921202795689E-18
      5.14617841828077E-07
      0.00000000000000E+00  -1.00913486559398E-11   0.00000000000000E+00  -1.17123614308068E-13   4.14930533515248E-24
      1.00914880693165E-08   1.00913709457022E-08  -6.57949103057378E-19  -3.28223601911063E-01  -3.28223601911462E-01
      0.00000000000000E+00   0.00000000000000E+00   3.99386610776616E-10   0.00000000000000E+00   3.99386610776616E-10
      2.59338582042981E-18  -2.01237670451109E-02  -1.68184891556855E-02   0.00000000000000E+00  -2.11682416388940E-13
     -3.97152925180323E-23  -1.04905458740624E-08  -1.04907575564788E-08  -1.93543671737243E-18
      5.16617841828077E-07
      0.00000000000000E+00  -1.14585494140110E-12   0.00000000000000E+00  -2.25786016475993E-13  -3.37445062752125E-23
      1.14607965715494E-09   1.14585387113843E-09  -9.23299585228200E-19  -2.03941780192968E-01  -2.03941780193373E-01
      0.00000000000000E+00   0.00000000000000E+00   4.04994001990253E-10   0.00000000000000E+00   4.04994001990253E-10
      3.40337382441032E-18  -4.79797148205859E-02  -4.74911022713347E-02   0.00000000000000E+00  -5.28730510328629E-13
     -8.44829101730131E-23  -1.55031914261827E-09  -1.55084787312868E-09  -2.48007423918212E-18
      5.18617841828078E-07
      0.00000000000000E+00   6.63119002638343E-14   0.00000000000000E+00  -3.73724820283193E-14  -4.50257162661294E-23
     -6.63139335107598E-11  -6.63513059928331E-11  -1.15955858435490E-18  -8.77026733802855E-02  -8.77026733806277E-02
      0.00000000000000E+00   0.00000000000000E+00   3.42178923326598E-10   0.00000000000000E+00   3.42178923326598E-10
      4.08773167106351E-18  -7.77648704316921E-02  -7.76779680802761E-02   0.00000000000000E+00  -1.20988347234651E-12
     -9.67775630461201E-23  -2.74617733861321E-10  -2.75827617333764E-10  -2.92817308670861E-18
      5.20617841828078E-07
      0.00000000000000E+00   5.56579107477612E-14   0.00000000000000E+00  -3.74236271616879E-15  -4.62482715407031E-23
     -5.56237921762691E-11  -5.56275345390315E-11  -1.26984296220875E-18  -3.28651940400274E-02  -3.28651940402218E-02
      0.00000000000000E+00   0.00000000000000E+00   1.94356050689530E-10   0.00000000000000E+00   1.94356050689530E-10
      4.47644377244257E-18  -1.07215284035671E-01  -1.07171576385201E-01   0.00000000000000E+00  -9.59614210162302E-13
     -1.03977917399153E-22  -1.37768901940232E-10  -1.38728516150499E-10  -3.20660081023382E-18
      5.22617841828078E-07
      0.00000000000000E+00   1.44196237415817E-14   0.00000000000000E+00   3.97824657642811E-16  -4.63849122798120E-23
     -1.44121501947760E-11  -1.44117523701648E-11  -1.30703895502933E-18  -1.57251158206089E-02  -1.57251158207164E-02
      0.00000000000000E+00   0.00000000000000E+00   1.07501588111524E-10   0.00000000000000E+00   1.07501588111524E-10
      4.69144694866562E-18  -1.36153231675979E-01  -1.36123903233000E-01   0.00000000000000E+00  -5.56676652764514E-13
     -1.07443963160095E-22  -9.25331590884878E-11  -9.30898357413597E-11  -3.38440799363628E-18
      5.24617841828078E-07
      0.00000000000000E+00  -9.00078424633762E-15   0.00000000000000E+00   9.31649025234869E-16  -4.60988474184877E-23
      8.96821686693014E-12   8.96914851590927E-12  -1.31830323313241E-18  -1.07629337364150E-02  -1.07629337364858E-02
      0.00000000000000E+00   0.00000000000000E+00   7.07181655460276E-11   0.00000000000000E+00   7.07181655460276E-11
      4.83288327975767E-18  -1.64520075923556E-01  -1.64494970256203E-01   0.00000000000000E+00  -4.27393649049484E-13
     -1.09905157956071E-22  -7.92599204127771E-11  -7.96873140619365E-11  -3.51458004662527E-18
      5.26617841828078E-07
      0.00000000000000E+00  -2.42470106227871E-14   0.00000000000000E+00   8.20958911337343E-16  -4.53044440514760E-23
      2.42878377466174E-11   2.42886587054834E-11  -1.32051661233832E-18  -9.17487179436270E-03  -9.17487179441592E-03
      0.00000000000000E+00   0.00000000000000E+00   5.32210930660082E-11   0.00000000000000E+00   5.32210930660082E-11
      4.93932546588969E-18  -1.92303852841045E-01  -1.92279433409620E-01   0.00000000000000E+00  -4.15358079817467E-13
     -1.12189500448656E-22  -7.70943936915621E-11  -7.75097517714918E-11  -3.61880885355137E-18
      5.28617841828078E-07
      0.00000000000000E+00  -3.60949817225580E-14   0.00000000000000E+00   6.42713497127112E-16  -4.35854794168145E-23
      3.60979512565242E-11   3.60985939699777E-11  -1.31930090111933E-18  -8.51850286447720E-03  -8.51850286452045E-03
      0.00000000000000E+00   0.00000000000000E+00   4.32494268310175E-11   0.00000000000000E+00   4.32494268310175E-11
      5.02582431955173E-18  -2.19512395192556E-01  -2.19487396806060E-01   0.00000000000000E+00  -4.32064182180648E-13
     -1.14482463945843E-22  -7.89159566186994E-11  -7.93480208009945E-11  -3.70652341843239E-18
      5.30617841828078E-07
      0.00000000000000E+00  -4.61060580781784E-14   0.00000000000000E+00   5.05031155296297E-16  -4.03810415348900E-23
      4.60912064364250E-11   4.60917114675399E-11  -1.31672335130340E-18  -8.15656976465479E-03  -8.15656976469160E-03
      0.00000000000000E+00   0.00000000000000E+00   3.68130481481406E-11   0.00000000000000E+00   3.68130481481406E-11
      5.09945041584801E-18  -2.46160237898257E-01  -2.46134119181933E-01   0.00000000000000E+00  -4.52041155677715E-13
     -1.16809208562461E-22  -8.24527184598860E-11  -8.29047596156805E-11  -3.78272706454461E-18
      5.32617841828078E-07
      0.00000000000000E+00  -5.50149975873085E-14   0.00000000000000E+00   4.11905465442901E-16  -3.50746634513229E-23
      5.49966786006852E-11   5.49970905061156E-11  -1.31365731490589E-18  -7.91517023101285E-03  -7.91517023104522E-03
      0.00000000000000E+00   0.00000000000000E+00   3.23695312311670E-11   0.00000000000000E+00   3.23695312311670E-11
      5.16418947831034E-18  -2.72261153617344E-01  -2.72233629450173E-01   0.00000000000000E+00  -4.70443234984894E-13
     -1.19165156202256E-22  -8.68961785021783E-11  -8.73666217372823E-11  -3.85053216340446E-18
      5.34617841828078E-07
      0.00000000000000E+00  -6.31891791987784E-14   0.00000000000000E+00   3.50537666194496E-16  -2.70830300933501E-23
      6.31878210447242E-11   6.31881715823633E-11  -1.31050261799583E-18  -7.73782292724941E-03  -7.73782292727857E-03
      0.00000000000000E+00   0.00000000000000E+00   2.91634099217096E-11   0.00000000000000E+00   2.91634099217096E-11
      5.22251629815376E-18  -2.97823372732615E-01  -2.97794278351346E-01   0.00000000000000E+00  -4.87599446658804E-13
     -1.21545491165341E-22  -9.18639820572933E-11  -9.23515815040737E-11  -3.91201368015794E-18
      5.36617841828078E-07
      0.00000000000000E+00  -7.09041371242107E-14   0.00000000000000E+00   3.10039593806903E-16  -1.60081260914794E-23
      7.08966413411188E-11   7.08969513806966E-11  -1.30744088780542E-18  -7.60047867427623E-03  -7.60047867430298E-03
      0.00000000000000E+00   0.00000000000000E+00   2.67520257588560E-11   0.00000000000000E+00   2.67520257588560E-11
      5.27602034967147E-18  -3.22850154920936E-01  -3.22819391930026E-01   0.00000000000000E+00  -5.04818002587622E-13
     -1.23950390864498E-22  -9.71441591368404E-11  -9.76489771395520E-11  -3.96857946186606E-18
      5.38617841828078E-07
      0.00000000000000E+00  -7.82517161008128E-14   0.00000000000000E+00   2.83036377785668E-16  -1.83937312947276E-24
      7.82821612284356E-11   7.82824442648115E-11  -1.30454540295535E-18  -7.49028708099882E-03  -7.49028708102368E-03
      0.00000000000000E+00   0.00000000000000E+00   2.48604012661491E-11   0.00000000000000E+00   2.48604012661491E-11
      5.32574115220377E-18  -3.47350071570412E-01  -3.47317578108406E-01   0.00000000000000E+00  -5.23570225330935E-13
     -1.26385723942082E-22  -1.02619275305503E-10  -1.03142845530961E-10  -4.02119574924842E-18
      5.40617841828078E-07
      0.00000000000000E+00  -8.55074503402074E-14   0.00000000000000E+00   2.66604258248034E-16   1.44979817191414E-23
      8.54871885735836E-11   8.54874551778563E-11  -1.30181186325809E-18  -7.41166256898914E-03  -7.41166256901241E-03
      0.00000000000000E+00   0.00000000000000E+00   2.32725323415963E-11   0.00000000000000E+00   2.32725323415963E-11
      5.37228621688696E-18  -3.71317019741624E-01  -3.71282757010756E-01   0.00000000000000E+00  -5.44099376435974E-13
     -1.28856872014374E-22  -1.08215888142888E-10  -1.08759987519453E-10  -4.07047435362887E-18
      5.41617841828078E-07
      0.00000000000000E+00  -8.90893950913009E-14   0.00000000000000E+00   2.63630442100048E-16   2.34759019553426E-23
      8.91132625346964E-11   8.91135261651620E-11  -1.30047719297921E-18  -7.38491610474476E-03  -7.38491610476723E-03
      0.00000000000000E+00   0.00000000000000E+00   2.24655629451545E-11   0.00000000000000E+00   2.24655629451545E-11
      5.39475177983212E-18  -3.83157330297332E-01  -3.83122179626395E-01   0.00000000000000E+00  -5.62426103089311E-13
     -1.30111008876860E-22  -1.11016663007096E-10  -1.11579089110315E-10  -4.09427458685290E-18
      5.42967841828078E-07
      0.00000000000000E+00  -9.39571661632999E-14   0.00000000000000E+00   2.54825682588703E-16   3.54439250053613E-23
      9.39184717780860E-11   9.39187266038040E-11  -1.29875014641844E-18  -7.35672810501961E-03  -7.35672810504123E-03
      0.00000000000000E+00   0.00000000000000E+00   2.16265903636974E-11   0.00000000000000E+00   2.16265903636974E-11
      5.42394767682311E-18  -3.98948682441126E-01  -3.98912282528870E-01   0.00000000000000E+00  -5.79314777864092E-13
     -1.31829719596412E-22  -1.14966002189507E-10  -1.15545316967503E-10  -4.12519753040467E-18
      5.44790341828078E-07
      0.00000000000000E+00  -1.00294453030619E-13   0.00000000000000E+00   2.46496818464706E-16   5.07134841207893E-23
      1.00313073228670E-10   1.00313319725539E-10  -1.29654635691704E-18  -7.32683383508762E-03  -7.32683383510830E-03
      0.00000000000000E+00   0.00000000000000E+00   2.06845546233897E-11   0.00000000000000E+00   2.06845546233897E-11
      5.46164527762424E-18  -4.19992037880460E-01  -4.19953920605630E-01   0.00000000000000E+00  -6.07062376100400E-13
     -1.34210899639936E-22  -1.20390811972693E-10  -1.20997874348928E-10  -4.16509892070719E-18
      5.46790341828078E-07
      0.00000000000000E+00  -1.07274653058391E-13   0.00000000000000E+00   2.39538093519469E-16   6.60542425025337E-23
      1.07256492350036E-10   1.07256731888195E-10  -1.29426801665805E-18  -7.30381371719494E-03  -7.30381371721461E-03
      0.00000000000000E+00   0.00000000000000E+00   1.96687005405437E-11   0.00000000000000E+00   1.96687005405437E-11
      5.50098267870532E-18  -4.42675863711205E-01  -4.42635879520240E-01   0.00000000000000E+00  -6.40686405757373E-13
     -1.36894403995867E-22  -1.26284746022845E-10  -1.26925432428740E-10  -4.20671466204727E-18
      5.48790341828078E-07
      0.00000000000000E+00  -1.14163008348956E-13   0.00000000000000E+00   2.34064395144102E-16   7.95912177761635E-23
      1.14144258584091E-10   1.14144492648566E-10  -1.29211213030797E-18  -7.29249564501876E-03  -7.29249564503743E-03
      0.00000000000000E+00   0.00000000000000E+00   1.86676332987362E-11   0.00000000000000E+00   1.86676332987362E-11
      5.53831794530280E-18  -4.64913022906908E-01  -4.64871184730073E-01   0.00000000000000E+00  -6.77640031522326E-13
     -1.39643713531297E-22  -1.32134485915639E-10  -1.32812125947301E-10  -4.24620581499483E-18
      5.50790341828078E-07
      0.00000000000000E+00  -1.20959518902313E-13   0.00000000000000E+00   2.29901585409603E-16   9.11109410596719E-23
      1.20989375360291E-10   1.20989605261967E-10  -1.29005700085389E-18  -7.29638039724672E-03  -7.29638039726442E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76986705412124E-11   0.00000000000000E+00   1.76986705412124E-11
      5.57371528638522E-18  -4.86700101250307E-01  -4.86656412470377E-01   0.00000000000000E+00  -7.16814652338504E-13
     -1.42449369091508E-22  -1.37971461150699E-10  -1.38688275803180E-10  -4.28365828553133E-18
      5.52790341828078E-07
      0.00000000000000E+00  -1.27847874192877E-13   0.00000000000000E+00   2.27614081632873E-16   1.00667797986537E-22
      1.27821104749000E-10   1.27821332363182E-10  -1.28807478163418E-18  -7.32209003306322E-03  -7.32209003307998E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67635044391822E-11   0.00000000000000E+00   1.67635044391822E-11
      5.60724229526359E-18  -5.08043702810587E-01  -5.07998157063430E-01   0.00000000000000E+00  -7.57286586737616E-13
     -1.45295968050406E-22  -1.43827550215481E-10  -1.44584836802364E-10  -4.31916751362940E-18
      5.54790341828078E-07
      0.00000000000000E+00  -1.34736229483442E-13   0.00000000000000E+00   2.30427610866687E-16   1.08533078392843E-22
      1.34749545663050E-10   1.34749776090769E-10  -1.28610438146250E-18  -7.39188477996478E-03  -7.39188477998062E-03
      0.00000000000000E+00   0.00000000000000E+00   1.58407412195794E-11   0.00000000000000E+00   1.58407412195794E-11
      5.63892377770275E-18  -5.28952734708769E-01  -5.28905297691088E-01   0.00000000000000E+00  -7.97045080671510E-13
     -1.48160756817034E-22  -1.49793472229529E-10  -1.50590517310348E-10  -4.35281939624024E-18
      5.56790341828078E-07
      0.00000000000000E+00  -1.42451187408874E-13   0.00000000000000E+00   2.62285333186383E-16   1.15397738403166E-22
      1.42448507964764E-10   1.42448770250212E-10  -1.28384782613201E-18  -7.63758260033575E-03  -7.63758260035049E-03
      0.00000000000000E+00   0.00000000000000E+00   1.47407091418332E-11   0.00000000000000E+00   1.47407091418332E-11
      5.66840519598641E-18  -5.49435577068885E-01  -5.49386061974253E-01   0.00000000000000E+00  -8.29349255759467E-13
     -1.51001546261705E-22  -1.56360130136135E-10  -1.57189479392046E-10  -4.38455736985440E-18
      5.58790341828078E-07
      0.00000000000000E+00  -1.52554108501702E-13   0.00000000000000E+00   3.62968055615494E-16   1.22475412826904E-22
      1.52566591443489E-10   1.52566954411668E-10  -1.28059610853689E-18  -8.37301735193412E-03  -8.37301735194726E-03
      0.00000000000000E+00   0.00000000000000E+00   1.31310105681330E-11   0.00000000000000E+00   1.31310105681330E-11
      5.69466721712268E-18  -5.69497939875578E-01  -5.69445745300079E-01   0.00000000000000E+00  -8.42989621062051E-13
     -1.53749629759289E-22  -1.64854975358585E-10  -1.65697964979800E-10  -4.41407110858579E-18
      5.60790341828078E-07
      0.00000000000000E+00  -1.79648305977922E-13   0.00000000000000E+00   1.04368831037655E-15   1.38151548413982E-22
      1.79665971829544E-10   1.79667015517993E-10  -1.27093063389112E-18  -1.20700138346946E-02  -1.20700138347017E-02
      0.00000000000000E+00   0.00000000000000E+00   7.12317780452241E-12   0.00000000000000E+00   7.12317780452241E-12
      5.70891357273172E-18  -5.89124621606964E-01  -5.89065783943330E-01   0.00000000000000E+00  -7.25992900442812E-13
     -1.56010596168144E-22  -1.86064200421916E-10  -1.86790193322515E-10  -4.43798293884060E-18
      5.62790341828078E-07
      0.00000000000000E+00  -3.48275243490941E-13   0.00000000000000E+00   5.94737470845682E-15   2.14469366415201E-22
      3.48241848373566E-10   3.48247795748489E-10  -1.22274344981631E-18  -3.28742000918886E-02  -3.28742000918631E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.55412447913630E-11   0.00000000000000E+00  -2.55412447913630E-11
      5.65783108314900E-18  -6.08102348422448E-01  -6.08000699515765E-01   0.00000000000000E+00   1.18165041430165E-13
     -1.55641714548222E-22  -3.22824715998402E-10  -3.22706550957127E-10  -4.43508763333268E-18
      5.64790341828078E-07
      0.00000000000000E+00  -7.64240058303830E-13   0.00000000000000E+00   1.23977027887286E-14   3.02272577522427E-22
      7.64182422634695E-10   7.64194820337786E-10  -1.15045912065020E-18  -6.23932532601822E-02  -6.23932532601337E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.85535375063218E-11   0.00000000000000E+00  -4.85535375063218E-11
      5.56072400813635E-18  -6.25946473747406E-01  -6.25721053449135E-01   0.00000000000000E+00   5.07636808220313E-13
     -1.54050249997251E-22  -7.16148919639530E-10  -7.15641282831464E-10  -4.41026488748615E-18
      5.66790341828078E-07
      0.00000000000000E+00  -1.57605569048116E-12   0.00000000000000E+00   2.18218994298306E-14   3.56064519445729E-22
      1.57607480678478E-09   1.57609662868456E-09  -1.07640262244173E-18  -9.20486086740427E-02  -9.20486086739842E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.85290827347082E-11   0.00000000000000E+00  -5.85290827347082E-11
      5.44366584266693E-18  -6.41887108386255E-01  -6.41409084761198E-01   0.00000000000000E+00   4.52627385342693E-13
     -1.52576143798329E-22  -1.51802017333505E-09  -1.51756754594986E-09  -4.36726322022520E-18
      5.68790341828079E-07
      0.00000000000000E+00  -3.04456119369230E-12   0.00000000000000E+00   3.77506399035434E-14   3.94072384303728E-22
      3.04451388280221E-09   3.04455163344251E-09  -1.00710573200800E-18  -1.21261783978907E-01  -1.21261783978837E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.95149894934437E-11   0.00000000000000E+00  -6.95149894934437E-11
      5.30463586368005E-18  -6.54691640552295E-01  -6.53754517739678E-01   0.00000000000000E+00   3.61639281711481E-13
     -1.51338038747474E-22  -2.97539828323062E-09  -2.97503664394906E-09  -4.29753013167205E-18
      5.69790341828079E-07
      0.00000000000000E+00  -4.13916677173161E-12   0.00000000000000E+00   5.53821124195158E-14   4.18011367049951E-22
      4.13912296086225E-09   4.13917834297509E-09  -9.74474069019682E-19  -1.35736880503829E-01  -1.35736880503752E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.70821849809907E-11   0.00000000000000E+00  -7.70821849809907E-11
      5.22755367869906E-18  -6.59967001651261E-01  -6.58687456532736E-01   0.00000000000000E+00   2.89336550227358E-13
     -1.50815484007062E-22  -4.06238549454417E-09  -4.06209615799410E-09  -4.25307960967938E-18
      5.71140341828079E-07
      0.00000000000000E+00  -6.03419923453451E-12   0.00000000000000E+00   7.05109756302342E-14   4.39475613092492E-22
      6.03411169279320E-09   6.03418220376927E-09  -9.34017608032956E-19  -1.55017501621951E-01  -1.55017501621863E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.77387566558952E-11   0.00000000000000E+00  -8.77387566558952E-11
      5.10910635721360E-18  -6.64513970213337E-01  -6.62640856698903E-01   0.00000000000000E+00   2.22634360485088E-13
     -1.50239864530476E-22  -5.94666608147370E-09  -5.94644344711337E-09  -4.17508874918065E-18
      5.72962841828079E-07
      0.00000000000000E+00  -9.41224866902734E-12   0.00000000000000E+00   9.25721534529785E-14   4.53778878815024E-22
      9.41218748050725E-09   9.41228005266116E-09  -8.84570299783940E-19  -1.80560240039422E-01  -1.80560240039319E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02172961219007E-10   0.00000000000000E+00  -1.02172961219007E-10
      4.92289613539196E-18  -6.64593098408757E-01  -6.61660426409224E-01   0.00000000000000E+00   2.22917296890865E-13
     -1.49424543145443E-22  -9.31033000873889E-09  -9.31010709144215E-09  -4.03832583560802E-18
      5.74962841828079E-07
      0.00000000000000E+00  -1.43545976676388E-11   0.00000000000000E+00   1.22950703527771E-13   4.58851947407485E-22
      1.43544423200721E-08   1.43545652707761E-08  -8.34674319869925E-19  -2.08010654420528E-01  -2.08010654420411E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16556235648732E-10   0.00000000000000E+00  -1.16556235648732E-10
      4.68978366409450E-18  -6.55127456966876E-01  -6.50642464583657E-01   0.00000000000000E+00   4.10152095106573E-13
     -1.47816912355519E-22  -1.42384191872223E-08  -1.42380090351273E-08  -3.85510934422457E-18
      5.76962841828079E-07
      0.00000000000000E+00  -2.08277229012880E-11   0.00000000000000E+00   1.60718182469552E-13   4.53713746067446E-22
      2.08275651037477E-08   2.08277258219306E-08  -7.87371188018156E-19  -2.34894367266996E-01  -2.34894367266867E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27960241223878E-10   0.00000000000000E+00  -1.27960241223878E-10
      4.43386318164674E-18  -6.33318736051600E-01  -6.26798179978427E-01   0.00000000000000E+00   8.42432437647613E-13
     -1.44516029936708E-22  -2.07006080131442E-08  -2.06997655807067E-08  -3.64649199362858E-18
      5.78962841828079E-07
      0.00000000000000E+00  -2.91445393896412E-11   0.00000000000000E+00   2.06344491141544E-13   4.38015743803279E-22
      2.91443121327858E-08   2.91445184772774E-08  -7.41307640754686E-19  -2.61226092922330E-01  -2.61226092922194E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.36463813285646E-10   0.00000000000000E+00  -1.36463813285646E-10
      4.16093555507545E-18  -5.95817274025933E-01  -5.86679317301069E-01   0.00000000000000E+00   1.45083332356523E-12
     -1.38482460733631E-22  -2.90095054973151E-08  -2.90080546639917E-08  -3.41962791432076E-18
      5.80962841828079E-07
      0.00000000000000E+00  -3.95392512125775E-11   0.00000000000000E+00   2.57960637680317E-13   4.09726418804130E-22
      3.95389829044209E-08   3.95392408650590E-08  -6.95741425220141E-19  -2.87016711785109E-01  -2.87016711784964E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.44308288844211E-10   0.00000000000000E+00  -1.44308288844211E-10
      3.87231897738703E-18  -5.38869809133809E-01  -5.26459389466180E-01   0.00000000000000E+00   1.98603365339170E-12
     -1.29231413934681E-22  -3.93969186098680E-08  -3.93949325762148E-08  -3.17657755216689E-18
      5.82962841828079E-07
      0.00000000000000E+00  -5.17058317057213E-11   0.00000000000000E+00   3.02256500577092E-13   3.57499359654880E-22
      5.17055100631182E-08   5.17058123196191E-08  -6.50587557684190E-19  -3.12270556287747E-01  -3.12270556287592E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.54974674438338E-10   0.00000000000000E+00  -1.54974674438338E-10
      3.56236962851035E-18  -4.59349314798691E-01  -4.43108830232796E-01   0.00000000000000E+00   2.12547082194581E-12
     -1.17915574126332E-22  -5.15529631160026E-08  -5.15508376451807E-08  -2.91178207082616E-18
      5.84962841828079E-07
      0.00000000000000E+00  -6.45182643909085E-11   0.00000000000000E+00   3.18851810843125E-13   2.81313021968994E-22
      6.45179395313219E-08   6.45182583831331E-08  -6.05944568227392E-19  -3.36993320340252E-01  -3.36993320340085E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.67869098819239E-10   0.00000000000000E+00  -1.67869098819239E-10
      3.22663143087187E-18  -3.56320609263337E-01  -3.36047030983469E-01   0.00000000000000E+00   1.91159405090829E-12
     -1.05746666640771E-22  -6.43523008783646E-08  -6.43503892843138E-08  -2.62068686264448E-18
      5.86962841828079E-07
      0.00000000000000E+00  -7.51677535148585E-11   0.00000000000000E+00   2.65582968032258E-13   2.18086187486225E-22
      7.51674755225966E-08   7.51677411055648E-08  -5.61978634283285E-19  -3.61189441032552E-01  -3.61189441032369E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.83668074889734E-10   0.00000000000000E+00  -1.83668074889734E-10
      2.85929528109241E-18  -2.34480959730330E-01  -2.10856515027546E-01   0.00000000000000E+00   1.45730420050861E-12
     -9.13124182638186E-23  -7.49855303348755E-08  -7.49840730306751E-08  -2.29731664680912E-18
      5.88962841828079E-07
      0.00000000000000E+00  -7.71289141884508E-11   0.00000000000000E+00   4.93465583155706E-14   1.12426936183954E-22
      7.71288441031180E-08   7.71288934496764E-08  -5.19141518270328E-19  -3.84849634916338E-01  -3.84849634916129E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.09354838986748E-10   0.00000000000000E+00  -2.09354838986748E-10
      2.44058560311891E-18  -1.11153450625192E-01  -8.69187906375497E-02   0.00000000000000E+00   8.67902856778278E-13
     -7.50281907527505E-23  -7.69204065135463E-08  -7.69195386106896E-08  -1.92144408484858E-18
      5.90962841828079E-07
      0.00000000000000E+00  -5.09531640843057E-11   0.00000000000000E+00  -6.50317028768527E-13   3.09904405768190E-23
      5.09538148759665E-08   5.09531645589378E-08  -4.67795762534026E-19  -4.08104919187487E-01  -4.08104919187314E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.73389632839141E-10   0.00000000000000E+00  -1.73389632839141E-10
      2.09380633744063E-18  -4.12245971003383E-02  -2.52255615445352E-02   0.00000000000000E+00   9.49092582208932E-13
     -2.92270556434897E-23  -5.07807240186808E-08  -5.07797749260986E-08  -1.62601057490660E-18
      5.92962841828079E-07
      0.00000000000000E+00  -2.75896079887178E-11   0.00000000000000E+00  -5.78003999909111E-13   1.05858099867376E-23
      2.75901416268855E-08   2.75895636228856E-08  -4.10029163874613E-19  -4.31002410407374E-01  -4.31002410407256E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17360351446917E-10   0.00000000000000E+00  -1.17360351446917E-10
      1.85908563454679E-18  -1.81611795403587E-02  -9.50557399824186E-03   0.00000000000000E+00   6.71324020489796E-13
     -1.12593097021441E-23  -2.74728745954591E-08  -2.74722032714387E-08  -1.44905647067218E-18
      5.94962841828079E-07
      0.00000000000000E+00  -1.94044968535202E-11   0.00000000000000E+00  -2.01753880832298E-13   5.73104878859647E-24
      1.94047172528557E-08   1.94045154989749E-08  -3.54176619756652E-19  -4.53470706256475E-01  -4.53470706256374E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01371590229839E-10   0.00000000000000E+00  -1.01371590229839E-10
      1.65634245408712E-18  -1.14792951704897E-02  -5.39748963645079E-03   0.00000000000000E+00   2.53956275670261E-13
     -6.36952943818278E-24  -1.93033978650207E-08  -1.93031439087450E-08  -1.30216583433046E-18
      5.95462841828079E-07
      0.00000000000000E+00  -1.80741258350692E-11   0.00000000000000E+00  -1.30809990531531E-13   5.03374483604977E-24
      1.80743224071475E-08   1.80741915971570E-08  -3.40481460270227E-19  -4.59059061978283E-01  -4.59059061978182E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01485868392528E-10   0.00000000000000E+00  -1.01485868392528E-10
      1.60559951989085E-18  -1.04747901813853E-02  -4.81216196030985E-03   0.00000000000000E+00   1.75192039440699E-13
     -5.70865452976136E-24  -1.79728809208039E-08  -1.79727057287644E-08  -1.26511805962062E-18
      5.96137841828079E-07
      0.00000000000000E+00  -1.71830481946818E-11   0.00000000000000E+00  -6.52561127506494E-14   4.50612886283042E-24
      1.71831188020128E-08   1.71830535459001E-08  -3.22322861163601E-19  -4.66552052479261E-01  -4.66552052479160E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00541848189339E-10   0.00000000000000E+00  -1.00541848189339E-10
      1.53773377236305E-18  -9.71940325986205E-03  -4.33724507697784E-03   0.00000000000000E+00   1.05891506667129E-13
     -5.09060173209706E-24  -1.70826175892174E-08  -1.70825116977107E-08  -1.21541091119945E-18
      5.97049091828079E-07
      0.00000000000000E+00  -1.66694524242173E-11   0.00000000000000E+00  -2.76345226171681E-14   4.06792363830723E-24
      1.66695153285621E-08   1.66694876940395E-08  -2.98334663313602E-19  -4.76573631050664E-01  -4.76573631050564E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00742681741855E-10   0.00000000000000E+00  -1.00742681741855E-10
      1.44593200362578E-18  -9.16620696162265E-03  -3.94591856644735E-03   0.00000000000000E+00   6.51698626476830E-14
     -4.55897013600374E-24  -1.65688101821603E-08  -1.65687450122976E-08  -1.14759734031218E-18
      5.98279279328079E-07
      0.00000000000000E+00  -1.64078786126502E-11   0.00000000000000E+00  -1.18482069695672E-14   3.67698781551107E-24
      1.64078703183067E-08   1.64078584700997E-08  -2.66843123061664E-19  -4.89932634881458E-01  -4.89932634881356E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01813829992033E-10   0.00000000000000E+00  -1.01813829992033E-10
      1.32068190264246E-18  -8.73938103165909E-03  -3.60185847356547E-03   0.00000000000000E+00   4.63567229292596E-14
     -4.07277734896690E-24  -1.63060909968306E-08  -1.63060446401077E-08  -1.05383877958079E-18
      5.99940032453079E-07
      0.00000000000000E+00  -1.62779183095016E-11   0.00000000000000E+00  -3.54792271848177E-15   3.30780079353236E-24
      1.62779413644895E-08   1.62779378165668E-08  -2.25899372320665E-19  -5.07661983449129E-01  -5.07661983449025E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03442984375314E-10   0.00000000000000E+00  -1.03442984375314E-10
      1.14888864308183E-18  -8.37700938263695E-03  -3.28093185726269E-03   0.00000000000000E+00   3.48511853576853E-14
     -3.60275422617223E-24  -1.61745296833768E-08  -1.61744948321915E-08  -9.22989270761163E-19
      6.01940032453079E-07
      0.00000000000000E+00  -1.62082081539611E-11   0.00000000000000E+00  -1.43635455324804E-15   2.98635348341397E-24
      1.62082448851774E-08   1.62082434488229E-08  -1.78849129001509E-19  -5.28578903704416E-01  -5.28578903704311E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05309751622648E-10   0.00000000000000E+00  -1.05309751622648E-10
      9.38269139836533E-19  -8.07903063044775E-03  -3.00549692653172E-03   0.00000000000000E+00   2.95067474187760E-14
     -3.18830121626443E-24  -1.61029632039476E-08  -1.61029336972002E-08  -7.59420010835024E-19
      6.03940032453079E-07
      0.00000000000000E+00  -1.61675209353781E-11   0.00000000000000E+00  -7.47575898196190E-16   2.74547011547503E-24
      1.61675317248272E-08   1.61675309772513E-08  -1.34048945921971E-19  -5.49069495076041E-01  -5.49069495075934E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07004570575892E-10   0.00000000000000E+00  -1.07004570575892E-10
      7.24259998684749E-19  -7.86258014883983E-03  -2.80240568139985E-03   0.00000000000000E+00   2.60022731692260E-14
     -2.87624383770527E-24  -1.60605524089485E-08  -1.60605264066754E-08  -5.90211052762779E-19
      6.05940032453079E-07
      0.00000000000000E+00  -1.61413451852740E-11   0.00000000000000E+00  -4.10408576429218E-16   2.55848468376349E-24
      1.61413725906503E-08   1.61413721802417E-08  -9.13438226179798E-20  -5.69139677925839E-01  -5.69139677925731E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08126534030439E-10   0.00000000000000E+00  -1.08126534030439E-10
      5.08006930623871E-19  -7.69836857174734E-03  -2.64678756090647E-03   0.00000000000000E+00   2.33618271535968E-14
     -2.63256945835157E-24  -1.60332690080384E-08  -1.60332456462113E-08  -4.16663108005891E-19
      6.07940032453079E-07
      0.00000000000000E+00  -1.61234354615185E-11   0.00000000000000E+00  -2.25903990681417E-16   2.40893138342898E-24
      1.61234449506845E-08   1.61234447247805E-08  -5.06077693601145E-20  -5.88775827186652E-01  -5.88775827186544E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08627256824092E-10   0.00000000000000E+00  -1.08627256824092E-10
      2.90752416975687E-19  -7.56929872661743E-03  -2.52352217679148E-03   0.00000000000000E+00   2.12582244422117E-14
     -2.43757973979868E-24  -1.60148387261808E-08  -1.60148174679564E-08  -2.40144647615573E-19
      6.09940032453079E-07
      0.00000000000000E+00  -1.61092913719886E-11   0.00000000000000E+00  -1.49902713630943E-16   2.28724164481642E-24
      1.61093193676640E-08   1.61093192177612E-08  -1.20994135949905E-20  -6.07772942820271E-01  -6.07772942820163E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07476695857521E-10   0.00000000000000E+00  -1.07476695857521E-10
      7.57990252606434E-20  -7.46483184603832E-03  -2.42314191075988E-03   0.00000000000000E+00   1.93281430314160E-14
     -2.27954476474708E-24  -1.60018618500467E-08  -1.60018425219037E-08  -6.36996116656518E-20
      6.11940032453079E-07
      0.00000000000000E+00  -1.60852280508402E-11   0.00000000000000E+00  -4.16453240697981E-16   2.19772263952520E-24
      1.60851941882089E-08   1.60851937717557E-08   2.34186639591850E-20  -6.25651918251730E-01  -6.25651918251627E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03003141666602E-10   0.00000000000000E+00  -1.03003141666602E-10
     -1.30207258072560E-19  -7.39802270553727E-03  -2.36252334380367E-03   0.00000000000000E+00   1.74685516423961E-14
     -2.16520372953200E-24  -1.59822080986407E-08  -1.59821906300891E-08   1.06788594113376E-19
      6.13940032453079E-07
      0.00000000000000E+00  -1.60630016244360E-11   0.00000000000000E+00  -3.92530669758172E-16   2.13020524690056E-24
      1.60630435682743E-08   1.60630431757437E-08   5.46582672744253E-20  -6.41652915399028E-01  -6.41652915398934E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.35760047170139E-11   0.00000000000000E+00  -9.35760047170139E-11
     -3.17359267506588E-19  -7.35502346746330E-03  -2.32353192264406E-03   0.00000000000000E+00   1.48906505755109E-14
     -2.08018807038292E-24  -1.59694820616772E-08  -1.59694671710267E-08   2.62701000232162E-19
      6.15940032453079E-07
      0.00000000000000E+00  -1.60394893717108E-11   0.00000000000000E+00  -4.61019221790776E-16   2.07926559951493E-24
      1.60394772686356E-08   1.60394768076164E-08   7.95019569722835E-20  -6.54556785875745E-01  -6.54556785875669E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.63576798991704E-11   0.00000000000000E+00  -7.63576798991704E-11
     -4.70074627304929E-19  -7.32329260420482E-03  -2.29380038846422E-03   0.00000000000000E+00   1.15427507504916E-14
     -2.01740349665500E-24  -1.59631306704680E-08  -1.59631191277173E-08   3.90572670332644E-19
      6.16940032453079E-07
      0.00000000000000E+00  -1.60236920769112E-11   0.00000000000000E+00  -6.81529066424894E-16   2.05846187863642E-24
      1.60236835384943E-08   1.60236828569653E-08   8.96935160984867E-20  -6.59894421995911E-01  -6.59894421995848E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.36097985352814E-11   0.00000000000000E+00  -6.36097985352814E-11
     -5.33684425840210E-19  -7.31004873615554E-03  -2.28151594130624E-03   0.00000000000000E+00   9.39269898501564E-15
     -1.99268894017969E-24  -1.59600824511290E-08  -1.59600730584300E-08   4.43990909741723E-19
      6.18290032453079E-07
      0.00000000000000E+00  -1.59971489478582E-11   0.00000000000000E+00  -9.08123654796825E-16   2.03931517573583E-24
      1.59971264811711E-08   1.59971255730475E-08   9.85461562723982E-20  -6.64550620991373E-01  -6.64550620991332E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.12587401873639E-11   0.00000000000000E+00  -4.12587401873639E-11
     -5.89383725093151E-19  -7.29709591891647E-03  -2.26988811520373E-03   0.00000000000000E+00   6.06750420573194E-15
     -1.97129036229599E-24  -1.59558729003643E-08  -1.59558668328601E-08   4.90837568820754E-19
      6.20112532453079E-07
      0.00000000000000E+00  -1.59511347345172E-11   0.00000000000000E+00  -1.24366860208619E-15   2.03274261704487E-24
      1.59510930812952E-08   1.59510918376266E-08   9.90746521041720E-20  -6.64826682645823E-01  -6.64826682645821E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.83862690425241E-12   0.00000000000000E+00  -1.83862690425241E-12
     -5.92734622626151E-19  -7.29017787892908E-03  -2.26505380458896E-03   0.00000000000000E+00   4.41365175571653E-16
     -1.96882284153911E-24  -1.59492536520875E-08  -1.59492532107224E-08   4.93659970521979E-19
      6.22112532453079E-07
      0.00000000000000E+00  -1.58851902132022E-11   0.00000000000000E+00  -1.71222099555073E-15   2.05590585387112E-24
      1.58851348202007E-08   1.58851331079797E-08   8.15982364218428E-20  -6.55644071701104E-01  -6.55644071701158E-01
      0.00000000000000E+00   0.00000000000000E+00   5.47885392511609E-11   0.00000000000000E+00   5.47885392511609E-11
     -4.83157544123830E-19  -7.29918408975780E-03  -2.27700060948071E-03   0.00000000000000E+00  -7.66285161689632E-15
     -2.00839047779754E-24  -1.59399139843793E-08  -1.59399216472309E-08   4.01559307701987E-19
      6.24112532453079E-07
      0.00000000000000E+00  -1.57998664523364E-11   0.00000000000000E+00  -2.33101592314105E-15   2.12384953032839E-24
      1.57999514560468E-08   1.57999491250309E-08   4.01958643329625E-20  -6.34198069468188E-01  -6.34198069468314E-01
      0.00000000000000E+00   0.00000000000000E+00   1.26523564758379E-10   0.00000000000000E+00   1.26523564758379E-10
     -2.30110414607071E-19  -7.33258472423220E-03  -2.31463982003219E-03   0.00000000000000E+00  -1.86853338210386E-14
     -2.11239309636174E-24  -1.59264540044554E-08  -1.59264726897893E-08   1.89914550274109E-19
      6.26112532453079E-07
      0.00000000000000E+00  -1.56764271255295E-11   0.00000000000000E+00  -3.89583919656610E-15   2.28313310828979E-24
      1.56764730030979E-08   1.56764691072588E-08  -3.34702307077093E-20  -5.97154106983223E-01  -5.97154106983436E-01
      0.00000000000000E+00   0.00000000000000E+00   2.13091520339402E-10   0.00000000000000E+00   2.13091520339402E-10
      1.96072626071734E-19  -7.43584797443892E-03  -2.42953517590651E-03   0.00000000000000E+00  -3.39225982013611E-14
     -2.35509437188204E-24  -1.58895267049999E-08  -1.58895606275981E-08  -1.62602395364025E-19
      6.28112532453080E-07
      0.00000000000000E+00  -1.54706030694474E-11   0.00000000000000E+00  -7.18513491704053E-15   2.67627508095869E-24
      1.54706643280162E-08   1.54706571428813E-08  -1.51981776947008E-19  -5.40760752805194E-01  -5.40760752805502E-01
      0.00000000000000E+00   0.00000000000000E+00   3.07558368956759E-10   0.00000000000000E+00   3.07558368956759E-10
      8.11189363985252E-19  -7.75315364872553E-03  -2.78192675533011E-03   0.00000000000000E+00  -5.75990352437744E-14
     -2.99437236829998E-24  -1.57781579128028E-08  -1.57782155118380E-08  -6.59207587038242E-19
      6.30112532453080E-07
      0.00000000000000E+00  -1.50131244334167E-11   0.00000000000000E+00  -1.31335633439319E-14   3.73445484809213E-24
      1.50131608334824E-08   1.50131476999190E-08  -3.33403688846399E-19  -4.61852655237951E-01  -4.61852655238334E-01
      0.00000000000000E+00   0.00000000000000E+00   3.82917336849683E-10   0.00000000000000E+00   3.82917336849683E-10
      1.57702403768462E-18  -8.80955624898058E-03  -3.95874440808750E-03   0.00000000000000E+00  -1.03588565632049E-13
     -5.30631694094505E-24  -1.53959614482031E-08  -1.53960650367687E-08  -1.24362034883822E-18
      6.32112532453080E-07
      0.00000000000000E+00  -1.23147260542596E-11   0.00000000000000E+00  -1.10178998693408E-13   5.78512301097351E-24
      1.23147522839039E-08   1.23146421049052E-08  -5.85122763565040E-19  -3.59416675099318E-01  -3.59416675099717E-01
      0.00000000000000E+00   0.00000000000000E+00   3.99422611254696E-10   0.00000000000000E+00   3.99422611254696E-10
      2.37586926019401E-18  -1.50841970030875E-02  -1.10784078734310E-02   0.00000000000000E+00  -1.45035966098368E-13
     -2.39369083990845E-23  -1.27139196801938E-08  -1.27140647161599E-08  -1.79074649662897E-18
      6.34112532453080E-07
      0.00000000000000E+00  -2.51158618367703E-12   0.00000000000000E+00  -2.83447138950322E-13  -2.39212931164112E-23
      2.51181632042777E-09   2.51153287328880E-09  -8.52595061853981E-19  -2.37901707702697E-01  -2.37901707703107E-01
      0.00000000000000E+00   0.00000000000000E+00   4.09279066904814E-10   0.00000000000000E+00   4.09279066904814E-10
      3.19442739400364E-18  -4.03653325673789E-02  -3.94450819505138E-02   0.00000000000000E+00  -3.43423867219666E-13
     -7.96197086936345E-23  -2.92046851632631E-09  -2.92081194019361E-09  -2.34183233214965E-18
      6.36112532453080E-07
      0.00000000000000E+00  -1.10213684649032E-15   0.00000000000000E+00  -6.91110127378012E-14  -4.40710094512652E-23
      1.16731022964977E-12   1.09819921686790E-12  -1.10702239677974E-18  -1.14070003196367E-01  -1.14070003196736E-01
      0.00000000000000E+00   0.00000000000000E+00   3.69615958039318E-10   0.00000000000000E+00   3.69615958039318E-10
      3.93365931008227E-18  -7.01186854348244E-02  -7.00018881534331E-02   0.00000000000000E+00  -1.08102337447143E-12
     -9.36689505406085E-23  -3.69633133881620E-10  -3.70714157256185E-10  -2.82663691330253E-18
      6.38112532453080E-07
      0.00000000000000E+00   6.93427765916827E-14   0.00000000000000E+00  -7.06631597665391E-15  -4.60833300391425E-23
     -6.93048099523426E-11  -6.93118762683653E-11  -1.25034218105233E-18  -4.23212420213679E-02  -4.23212420215995E-02
      0.00000000000000E+00   0.00000000000000E+00   2.31635205822955E-10   0.00000000000000E+00   2.31635205822955E-10
      4.39692972172818E-18  -9.96781516620715E-02  -9.96270101337351E-02   0.00000000000000E+00  -1.10059612083160E-12
     -1.02614649907594E-22  -1.61222733433656E-10  -1.62323329554590E-10  -3.14658754067585E-18
      6.40112532453080E-07
      0.00000000000000E+00   2.31448737762967E-14   0.00000000000000E+00  -9.81967438141521E-17  -4.63960843811599E-23
     -2.31734685494104E-11  -2.31735667462006E-11  -1.30075252959235E-18  -1.84838607344003E-02  -1.84838607345243E-02
      0.00000000000000E+00   0.00000000000000E+00   1.23952387635199E-10   0.00000000000000E+00   1.23952387635199E-10
      4.64483449699858E-18  -1.28755751689734E-01  -1.28724000695151E-01   0.00000000000000E+00  -6.34838337638334E-13
     -1.06701947341523E-22  -1.00143982551253E-10  -1.00778820888998E-10  -3.34408196740623E-18
      6.42112532453080E-07
      0.00000000000000E+00  -3.85747896271612E-15   0.00000000000000E+00   8.97606015188870E-16  -4.62099228133975E-23
      3.90079531671825E-12   3.90169292268723E-12  -1.31652102102776E-18  -1.15730424710900E-02  -1.15730424711678E-02
      0.00000000000000E+00   0.00000000000000E+00   7.77745583763143E-11   0.00000000000000E+00   7.77745583763143E-11
      4.80038361375121E-18  -1.57271845921816E-01  -1.57246113577556E-01   0.00000000000000E+00  -4.44936375588638E-13
     -1.09304069862272E-22  -8.12313149233034E-11  -8.16762512990013E-11  -3.48386259272344E-18
      6.42612532453080E-07
      0.00000000000000E+00  -9.73554214399784E-15   0.00000000000000E+00   1.01267511923192E-15  -4.60974722150272E-23
      9.74452144992262E-12   9.74553412499575E-12  -1.31894587816174E-18  -1.05349916817518E-02  -1.05349916818208E-02
      0.00000000000000E+00   0.00000000000000E+00   6.90314259179933E-11   0.00000000000000E+00   6.90314259179933E-11
      4.83489932671021E-18  -1.64364290359079E-01  -1.64339471503335E-01   0.00000000000000E+00  -4.23561034440208E-13
     -1.09903162990375E-22  -7.83533990084399E-11  -7.87769600429900E-11  -3.51595344854847E-18
      6.43287532453080E-07
      0.00000000000000E+00  -1.60728290113172E-14   0.00000000000000E+00   9.87181255555881E-16  -4.58774973562878E-23
      1.60708274684181E-11   1.60718146496278E-11  -1.32063330237152E-18  -9.75630508983893E-03  -9.75630508989998E-03
      0.00000000000000E+00   0.00000000000000E+00   6.10508211004064E-11   0.00000000000000E+00   6.10508211004064E-11
      4.87610863095298E-18  -1.73871786911370E-01  -1.73847489326563E-01   0.00000000000000E+00  -4.07788390016676E-13
     -1.10671009282232E-22  -7.67148473599049E-11  -7.71226357500323E-11  -3.55547532858146E-18
      6.44198782453080E-07
      0.00000000000000E+00  -2.30530290390892E-14   0.00000000000000E+00   8.75191442474718E-16  -4.54448687326410E-23
      2.30503589140542E-11   2.30512341054512E-11  -1.32135642987585E-18  -9.18881779011444E-03  -9.18881779016810E-03
      0.00000000000000E+00   0.00000000000000E+00   5.36554170156960E-11   0.00000000000000E+00   5.36554170156960E-11
      4.92500212970853E-18  -1.86584192832830E-01  -1.86560026385081E-01   0.00000000000000E+00  -4.09082677070384E-13
     -1.11694422876548E-22  -7.62975684439653E-11  -7.67066511211474E-11  -3.60364569983269E-18
      6.45428969953080E-07
      0.00000000000000E+00  -3.08598317017290E-14   0.00000000000000E+00   7.28772712495807E-16  -4.45503966781300E-23
      3.08906377370079E-11   3.08913665096759E-11  -1.32088342673560E-18  -8.75384914245160E-03  -8.75384914249831E-03
      0.00000000000000E+00   0.00000000000000E+00   4.67162620359860E-11   0.00000000000000E+00   4.67162620359860E-11
      4.98247189131193E-18  -2.03525005255588E-01  -2.03500555065162E-01   0.00000000000000E+00  -4.21405645496705E-13
     -1.13089923269563E-22  -7.71862229000508E-11  -7.76076285456606E-11  -3.66158846457632E-18
      6.47089723078080E-07
      0.00000000000000E+00  -3.97687712108591E-14   0.00000000000000E+00   5.75772085618523E-16  -4.25952599901284E-23
      3.98027264896307E-11   3.98033022616737E-11  -1.31900693149170E-18  -8.38668461086201E-03  -8.38668461090225E-03
      0.00000000000000E+00   0.00000000000000E+00   4.02359758056736E-11   0.00000000000000E+00   4.02359758056736E-11
      5.04929391386862E-18  -2.26001596525782E-01  -2.25976380408385E-01   0.00000000000000E+00  -4.39217430541446E-13
     -1.15006372302596E-22  -7.96000606366913E-11  -8.00392780673478E-11  -3.73028698237692E-18
      6.49089723078080E-07
      0.00000000000000E+00  -4.91369344060268E-14   0.00000000000000E+00   4.55198449718580E-16  -3.86890616387002E-23
      4.91203875722370E-11   4.91208427706480E-11  -1.31601912935972E-18  -8.08577419437250E-03  -8.08577419440735E-03
      0.00000000000000E+00   0.00000000000000E+00   3.48523313268841E-11   0.00000000000000E+00   3.48523313268841E-11
      5.11899857652239E-18  -2.52514208012612E-01  -2.52487752751601E-01   0.00000000000000E+00  -4.58177448396083E-13
     -1.17348807209234E-22  -8.35149966490191E-11  -8.39731740975326E-11  -3.80297944716267E-18
      6.51089723078080E-07
      0.00000000000000E+00  -5.75866502291193E-14   0.00000000000000E+00   3.78866630516350E-16  -3.24651796249818E-23
      5.75924167090039E-11   5.75927955756020E-11  -1.31281378316402E-18  -7.86757525510820E-03  -7.86757525513921E-03
      0.00000000000000E+00   0.00000000000000E+00   3.10119373450391E-11   0.00000000000000E+00   3.10119373450391E-11
      5.18102245121247E-18  -2.78483590587404E-01  -2.78455676422312E-01   0.00000000000000E+00  -4.76148823439351E-13
     -1.19718546124615E-22  -8.81285840970815E-11  -8.86047329206406E-11  -3.86820866804845E-18
      6.53089723078080E-07
      0.00000000000000E+00  -6.54852976289666E-14   0.00000000000000E+00   3.28923597195793E-16  -2.33858022117710E-23
      6.54897362504849E-11   6.54900651740587E-11  -1.30964314229277E-18  -7.70222531884209E-03  -7.70222531887028E-03
      0.00000000000000E+00   0.00000000000000E+00   2.81871940870918E-11   0.00000000000000E+00   2.81871940870918E-11
      5.23739683938665E-18  -3.03915753689205E-01  -3.03886241731581E-01   0.00000000000000E+00  -4.92867993232083E-13
     -1.22110324342043E-22  -9.31843912677963E-11  -9.36772592611505E-11  -3.92775369709388E-18
      6.55089723078080E-07
      0.00000000000000E+00  -7.30165660799838E-14   0.00000000000000E+00   2.95823715069190E-16  -1.11709383330366E-23
      7.29967823782193E-11   7.29970782019232E-11  -1.30661959757930E-18  -7.57237889943343E-03  -7.57237889945945E-03
      0.00000000000000E+00   0.00000000000000E+00   2.60251807667467E-11   0.00000000000000E+00   2.60251807667467E-11
      5.28944720092015E-18  -3.28813849489664E-01  -3.28782653933872E-01   0.00000000000000E+00  -5.10019490354599E-13
     -1.24525948198878E-22  -9.85122394781910E-11  -9.90222589686701E-11  -3.98282760334085E-18
      6.57089723078080E-07
      0.00000000000000E+00  -8.02723003193784E-14   0.00000000000000E+00   2.73534324069680E-16   3.96474786349947E-24
      8.02426289074617E-11   8.02429024417897E-11  -1.30378231107940E-18  -7.46736297259900E-03  -7.46736297262330E-03
      0.00000000000000E+00   0.00000000000000E+00   2.42980424249799E-11   0.00000000000000E+00   2.42980424249799E-11
      5.33804328577011E-18  -3.53186328598920E-01  -3.53153394762498E-01   0.00000000000000E+00  -5.29047670504114E-13
     -1.26972573812035E-22  -1.04011897196139E-10  -1.04540944866770E-10  -4.03426097469071E-18
      6.59089723078080E-07
      0.00000000000000E+00  -8.73443450843579E-14   0.00000000000000E+00   2.61269715894371E-16   2.06344552996233E-23
      8.73718378283033E-11   8.73720990980398E-11  -1.30109650087292E-18  -7.39938318000505E-03  -7.39938318002785E-03
      0.00000000000000E+00   0.00000000000000E+00   2.28028441632627E-11   0.00000000000000E+00   2.28028441632627E-11
      5.38364897409664E-18  -3.77022336162112E-01  -3.76987627756352E-01   0.00000000000000E+00  -5.49752664206754E-13
     -1.29454773486607E-22  -1.09625190596966E-10  -1.10174943261303E-10  -4.08255247322372E-18
      6.60089723078080E-07
      0.00000000000000E+00  -9.09262898354515E-14   0.00000000000000E+00   2.58096354349891E-16   2.96382365075488E-23
      9.09523906829957E-11   9.09526487793797E-11  -1.29979058517673E-18  -7.37478022892058E-03  -7.37478022894263E-03
      0.00000000000000E+00   0.00000000000000E+00   2.20549063492453E-11   0.00000000000000E+00   2.20549063492453E-11
      5.40570388044588E-18  -3.88801983796889E-01  -3.88766383199498E-01   0.00000000000000E+00  -5.68933446038467E-13
     -1.30715744814853E-22  -1.12438621682456E-10  -1.13007555128626E-10  -4.10591329526915E-18
      6.61439723078080E-07
      0.00000000000000E+00  -9.57022161702429E-14   0.00000000000000E+00   2.50901544083510E-16   4.14902413394199E-23
      9.57202839730423E-11   9.57205348746278E-11  -1.29810012042349E-18  -7.34823855507199E-03  -7.34823855509328E-03
      0.00000000000000E+00   0.00000000000000E+00   2.12955992918968E-11   0.00000000000000E+00   2.12955992918968E-11
      5.43445293948994E-18  -4.04543192916649E-01  -4.04506329742463E-01   0.00000000000000E+00  -5.87939621483947E-13
     -1.32449178223118E-22  -1.16428194544908E-10  -1.17016134166524E-10  -4.13635281906645E-18
      6.63262223078080E-07
      0.00000000000000E+00  -1.02039503037562E-13   0.00000000000000E+00   2.43509649880583E-16   5.63734390452709E-23
      1.02076140276015E-10   1.02076383785721E-10  -1.29594082273141E-18  -7.32038540167631E-03  -7.32038540169670E-03
      0.00000000000000E+00   0.00000000000000E+00   2.03838662540097E-11   0.00000000000000E+00   2.03838662540097E-11
      5.47160253573787E-18  -4.25505131961135E-01  -4.25466554095651E-01   0.00000000000000E+00  -6.15869601885539E-13
     -1.34848826858926E-22  -1.21844380437711E-10  -1.22460250039731E-10  -4.17566171300646E-18
      6.65262223078080E-07
      0.00000000000000E+00  -1.09019703065334E-13   0.00000000000000E+00   2.37205183961548E-16   7.10756804815167E-23
      1.08984671958068E-10   1.08984909163324E-10  -1.29370466045703E-18  -7.29995983410618E-03  -7.29995983412557E-03
      0.00000000000000E+00   0.00000000000000E+00   1.93856381052638E-11   0.00000000000000E+00   1.93856381052638E-11
      5.51037381194840E-18  -4.48083318877066E-01  -4.48042879546926E-01   0.00000000000000E+00  -6.49652722580426E-13
     -1.37549861814414E-22  -1.27720894545869E-10  -1.28370547268586E-10  -4.21666915149136E-18
      6.67262223078080E-07
      0.00000000000000E+00  -1.15816213618691E-13   0.00000000000000E+00   2.32285053219129E-16   8.38628728612733E-23
      1.15845094218010E-10   1.15845326503147E-10  -1.29158364404987E-18  -7.29189990367190E-03  -7.29189990369030E-03
      0.00000000000000E+00   0.00000000000000E+00   1.84027083154194E-11   0.00000000000000E+00   1.84027083154194E-11
      5.54717922857924E-18  -4.70211696228387E-01  -4.70169405826951E-01   0.00000000000000E+00  -6.87084970098533E-13
     -1.40314449482076E-22  -1.33560949848328E-10  -1.34248034818567E-10  -4.25559558452937E-18
      6.69262223078080E-07
      0.00000000000000E+00  -1.22704568909256E-13   0.00000000000000E+00   2.28674683925374E-16   9.46296716478525E-23
      1.22671794458054E-10   1.22672023132832E-10  -1.28955541623637E-18  -7.30025580610013E-03  -7.30025580611757E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74498928154659E-11   0.00000000000000E+00   1.74498928154659E-11
      5.58207901421017E-18  -4.91891004561168E-01  -4.91846864286807E-01   0.00000000000000E+00  -7.26635486917918E-13
     -1.43132065262200E-22  -1.39395280461237E-10  -1.40121915948298E-10  -4.29252359797380E-18
      6.71262223078080E-07
      0.00000000000000E+00  -1.29501079462613E-13   0.00000000000000E+00   2.27065764542964E-16   1.03507112503133E-22
      1.29499241871354E-10   1.29499468937222E-10  -1.28759023083395E-18  -7.33278341381325E-03  -7.33278341382977E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65281505626070E-11   0.00000000000000E+00   1.65281505626070E-11
      5.61513531533538E-18  -5.13128889017514E-01  -5.13082888912425E-01   0.00000000000000E+00  -7.67168986179761E-13
     -1.45985873970504E-22  -1.45260450513504E-10  -1.46027619499829E-10  -4.32754508450143E-18
      6.73262223078080E-07
      0.00000000000000E+00  -1.36573124227592E-13   0.00000000000000E+00   2.23844193417595E-16   1.10871365666794E-22
      1.36545838280287E-10   1.36546062124591E-10  -1.28558109059057E-18  -7.43334967166393E-03  -7.43334967167951E-03
      0.00000000000000E+00   0.00000000000000E+00   1.55803132401512E-11   0.00000000000000E+00   1.55803132401512E-11
      5.64629594181569E-18  -5.33934312592178E-01  -5.33886391912085E-01   0.00000000000000E+00  -8.05628389605679E-13
     -1.48848892941664E-22  -1.51320746974987E-10  -1.52126375364742E-10  -4.36071485122511E-18
      6.75262223078080E-07
      0.00000000000000E+00  -1.44563616364647E-13   0.00000000000000E+00   2.74269676810100E-16   1.17437989415896E-22
      1.44532641107087E-10   1.44532915376882E-10  -1.28320605172076E-18  -7.74333479034148E-03  -7.74333479035591E-03
      0.00000000000000E+00   0.00000000000000E+00   1.44360203406224E-11   0.00000000000000E+00   1.44360203406224E-11
      5.67516798249693E-18  -5.54315364035988E-01  -5.54265288568955E-01   0.00000000000000E+00  -8.35709772777706E-13
     -1.51677605400540E-22  -1.58133225944574E-10  -1.58968935717504E-10  -4.39196193077617E-18
      6.77262223078080E-07
      0.00000000000000E+00  -1.56136053252795E-13   0.00000000000000E+00   4.26595900313716E-16   1.25018315794468E-22
      1.56163354361247E-10   1.56163780957272E-10  -1.27935060550151E-18  -8.76351469850084E-03  -8.76351469851329E-03
      0.00000000000000E+00   0.00000000000000E+00   1.24468526244435E-11   0.00000000000000E+00   1.24468526244435E-11
      5.70006168774582E-18  -5.74275976272242E-01  -5.74222864397471E-01   0.00000000000000E+00  -8.37276949443650E-13
     -1.54375187621948E-22  -1.67773356632119E-10  -1.68610633581717E-10  -4.42071108224431E-18
      6.79262223078080E-07
      0.00000000000000E+00  -1.97649874470598E-13   0.00000000000000E+00   1.59632847118755E-15   1.48094760578340E-22
      1.97613043016870E-10   1.97614639345489E-10  -1.26471879473816E-18  -1.47263046515745E-02  -1.47263046515774E-02
      0.00000000000000E+00   0.00000000000000E+00   2.85353320430940E-12   0.00000000000000E+00   2.85353320430940E-12
      5.70576875415444E-18  -5.93782237867443E-01  -5.93719092016897E-01   0.00000000000000E+00  -6.17281611613041E-13
     -1.56280975893292E-22  -1.99850890938029E-10  -2.00468172549798E-10  -4.44104995941627E-18
      6.81262223078080E-07
      0.00000000000000E+00  -4.21934722731378E-13   0.00000000000000E+00   7.62088153874408E-15   2.38645548955471E-22
      4.21871588628223E-10   4.21879209510001E-10  -1.20659123524158E-18  -3.96536893852038E-02  -3.96536893851696E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.41461232936837E-11   0.00000000000000E+00  -3.41461232936837E-11
      5.63747650756707E-18  -6.12542536735285E-01  -6.12420405221674E-01   0.00000000000000E+00   3.19197625829736E-13
     -1.55294775099763E-22  -3.88052283841992E-10  -3.87733086216318E-10  -4.43088527232548E-18
      6.83262223078081E-07
      0.00000000000000E+00  -9.11007948361458E-13   0.00000000000000E+00   1.41227520983735E-14   3.17737208675480E-22
      9.10995735334453E-10   9.11009858086869E-10  -1.13289019144438E-18  -6.93943500106313E-02  -6.93943500105802E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.11665245858309E-11   0.00000000000000E+00  -5.11665245858309E-11
      5.53514345839541E-18  -6.30020244583738E-01  -6.29749401421802E-01   0.00000000000000E+00   5.03802250344810E-13
     -1.53703505914382E-22  -8.60347135751228E-10  -8.59843333501037E-10  -4.40225326695102E-18
      6.85262223078081E-07
      0.00000000000000E+00  -1.85232466000140E-12   0.00000000000000E+00   2.49446636841997E-14   3.66003234890457E-22
      1.85232607820892E-09   1.85235102287297E-09  -1.05952479982877E-18  -9.89630571174510E-02  -9.89630571173901E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.09075604038929E-11   0.00000000000000E+00  -6.09075604038929E-11
      5.41332833758762E-18  -6.45350433954608E-01  -6.44786140335313E-01   0.00000000000000E+00   4.33190567087672E-13
     -1.52278245786118E-22  -1.79187665303602E-09  -1.79144346246908E-09  -4.35380353775885E-18
      6.87262223078081E-07
      0.00000000000000E+00  -3.51600022977854E-12   0.00000000000000E+00   4.25126983669513E-14   4.01966514715639E-22
      3.51599898803950E-09   3.51604150073826E-09  -9.91834848633726E-19  -1.28053485660019E-01  -1.28053485659947E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25386874450300E-11   0.00000000000000E+00  -7.25386874450300E-11
      5.26825096269756E-18  -6.57179500578158E-01  -6.56094811728083E-01   0.00000000000000E+00   3.38212115303398E-13
     -1.51104014111396E-22  -3.44384102540839E-09  -3.44350281329323E-09  -4.27641611406383E-18
      6.89262223078081E-07
      0.00000000000000E+00  -6.16241448767621E-12   0.00000000000000E+00   6.65492400110090E-14   4.30531442979995E-22
      6.16230511458889E-09   6.16237166382933E-09  -9.31492193712489E-19  -1.56583603869276E-01  -1.56583603869189E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.71711186029127E-11   0.00000000000000E+00  -8.71711186029127E-11
      5.09390872549174E-18  -6.63677903030992E-01  -6.61764230645221E-01   0.00000000000000E+00   2.51981373062775E-13
     -1.50160762288987E-22  -6.07545252659933E-09  -6.07520054522642E-09  -4.16241653177925E-18
      6.89762223078081E-07
      0.00000000000000E+00  -7.03962357274530E-12   0.00000000000000E+00   8.77381579947172E-14   4.41471105376490E-22
      7.03949535453043E-09   7.03958309268886E-09  -9.16962310226298E-19  -1.63679600559503E-01  -1.63679600559411E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.22939812714996E-11   0.00000000000000E+00  -9.22939812714996E-11
      5.04776173485599E-18  -6.64865695826629E-01  -6.62677315119334E-01   0.00000000000000E+00   2.10098277685486E-13
     -1.49949702174408E-22  -6.94749920969490E-09  -6.94728911141737E-09  -4.13079942462969E-18
      6.90437223078081E-07
      0.00000000000000E+00  -8.34271670424569E-12   0.00000000000000E+00   9.63624951912944E-14   4.52773565205330E-22
      8.34267934206919E-09   8.34277570456484E-09  -8.98254634802645E-19  -1.73191920795584E-01  -1.73191920795485E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.85809395367685E-11   0.00000000000000E+00  -9.85809395367685E-11
      4.98121960066867E-18  -6.65599262536630E-01  -6.63002355284561E-01   0.00000000000000E+00   1.89580113041291E-13
     -1.49683302215128E-22  -8.24438434514095E-09  -8.24419476502806E-09  -4.08296496586602E-18
      6.91348473078081E-07
      0.00000000000000E+00  -1.03212360331702E-11   0.00000000000000E+00   1.08181802312416E-13   4.61703449510084E-22
      1.03211068457833E-08   1.03212150275861E-08  -8.74239913276939E-19  -1.85910819835935E-01  -1.85910819835828E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06556506738985E-10   0.00000000000000E+00  -1.06556506738985E-10
      4.88411998390277E-18  -6.64822246265414E-01  -6.61604638872137E-01   0.00000000000000E+00   2.04842458169419E-13
     -1.49290780266763E-22  -1.02148633633051E-08  -1.02146585208471E-08  -4.00988007062583E-18
      6.92578660578081E-07
      0.00000000000000E+00  -1.34112603717803E-11   0.00000000000000E+00   1.24865446605316E-13   4.65617858921523E-22
      1.34111243640239E-08   1.34112492294710E-08  -8.43439332919258E-19  -2.02860285610985E-01  -2.02860285610869E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15889031521366E-10   0.00000000000000E+00  -1.15889031521366E-10
      4.74155474593807E-18  -6.60085770210666E-01  -6.55897726856403E-01   0.00000000000000E+00   3.17096781410180E-13
     -1.48502928972374E-22  -1.32956772947309E-08  -1.32953601979496E-08  -3.89811541301882E-18
      6.94239413703081E-07
      0.00000000000000E+00  -1.84351674970320E-11   0.00000000000000E+00   1.50272637697018E-13   4.61433660320738E-22
      1.84350351634093E-08   1.84351854360475E-08  -8.03765796018769E-19  -2.25348296307849E-01  -2.25348296307723E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25709710642758E-10   0.00000000000000E+00  -1.25709710642758E-10
      4.53278195114527E-18  -6.45697666878336E-01  -6.39930116606455E-01   0.00000000000000E+00   6.41871576300138E-13
     -1.46426343976365E-22  -1.83101175969809E-08  -1.83094757254047E-08  -3.72901615512650E-18
      6.96239413703081E-07
      0.00000000000000E+00  -2.60471674720546E-11   0.00000000000000E+00   1.88886992588239E-13   4.47136631636486E-22
      2.60470138093902E-08   2.60472026963832E-08  -7.57498674775737E-19  -2.51874302643074E-01  -2.51874302642940E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.34385709215376E-10   0.00000000000000E+00  -1.34385709215376E-10
      4.26401053271452E-18  -6.13962539221583E-01  -6.05799728426241E-01   0.00000000000000E+00   1.23531545472907E-12
     -1.41475349847445E-22  -2.59140523026224E-08  -2.59128169871678E-08  -3.50651185793878E-18
      6.98239413703081E-07
      0.00000000000000E+00  -3.56992227499308E-11   0.00000000000000E+00   2.39488324607767E-13   4.22971365615465E-22
      3.56990329488645E-08   3.56992724371895E-08  -7.11846716392647E-19  -2.77856836042849E-01  -2.77856836042707E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.41678971996789E-10   0.00000000000000E+00  -1.41678971996789E-10
      3.98065258872094E-18  -5.64122478039893E-01  -5.52921089064168E-01   0.00000000000000E+00   1.85222375357476E-12
     -1.33289362153679E-22  -3.55594456889462E-08  -3.55575934651927E-08  -3.26880587232830E-18
      7.00239413703081E-07
      0.00000000000000E+00  -4.73460538752172E-11   0.00000000000000E+00   2.89210109740006E-13   3.81211895501809E-22
      4.73457460631725E-08   4.73460352732826E-08  -6.66542800003406E-19  -3.03302078009573E-01  -3.03302078009422E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.50808100743268E-10   0.00000000000000E+00  -1.50808100743268E-10
      3.67903638723441E-18  -4.92611615596190E-01  -4.77743536130688E-01   0.00000000000000E+00   2.16447608995867E-12
     -1.22355267718644E-22  -4.71973916486292E-08  -4.71952271725394E-08  -3.01249358723100E-18
      7.02239413703081E-07
      0.00000000000000E+00  -6.01237692497400E-11   0.00000000000000E+00   3.17780405203582E-13   3.09635093044194E-22
      6.01234636677306E-08   6.01237814481361E-08  -6.21745261261679E-19  -3.28213095044358E-01  -3.28213095044195E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.63470657148512E-10   0.00000000000000E+00  -1.63470657148512E-10
      3.35209507293738E-18  -3.97546672093593E-01  -3.78656437838019E-01   0.00000000000000E+00   2.03281547220583E-12
     -1.10456359381146E-22  -5.99623436064596E-08  -5.99603107909875E-08  -2.73034981167570E-18
      7.04239413703081E-07
      0.00000000000000E+00  -7.21523071028609E-11   0.00000000000000E+00   2.99750482291246E-13   2.41333963378937E-22
      7.21520322322342E-08   7.21523319827168E-08  -5.77477872672373E-19  -3.52598419917063E-01  -3.52598419916886E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.76947928004612E-10   0.00000000000000E+00  -1.76947928004612E-10
      2.99819921692816E-18  -2.80797380206277E-01  -2.58121078834565E-01   0.00000000000000E+00   1.67742770972741E-12
     -9.68750666066033E-23  -7.19770614824217E-08  -7.19753840547121E-08  -2.42072134425579E-18
      7.06239413703081E-07
      0.00000000000000E+00  -7.84270477041420E-11   0.00000000000000E+00   1.56825509304145E-13   1.57223318330938E-22
      7.84269302069687E-08   7.84270870324781E-08  -5.34381140470283E-19  -3.76447580554969E-01  -3.76447580554768E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.00907137621688E-10   0.00000000000000E+00  -2.00907137621688E-10
      2.59638494168478E-18  -1.54048513072891E-01  -1.29402298085192E-01   0.00000000000000E+00   1.05039374635583E-12
     -8.26969987160559E-23  -7.82272302886027E-08  -7.82261798948564E-08  -2.06200380121450E-18
      7.07239413703081E-07
      0.00000000000000E+00  -7.48363777030137E-11   0.00000000000000E+00  -1.77458505532700E-13   9.41557081833590E-23
      7.48365724412953E-08   7.48363949827898E-08  -5.12785821430231E-19  -3.88232947819130E-01  -3.88232947818911E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.19436445477952E-10   0.00000000000000E+00  -2.19436445477952E-10
      2.37694849620683E-18  -9.48253775830963E-02  -7.13161421390056E-02   0.00000000000000E+00   8.35939152369095E-13
     -6.86037172579738E-23  -7.46177944764642E-08  -7.46169585373119E-08  -1.86416267477660E-18
      7.08589413703081E-07
      0.00000000000000E+00  -5.29323263263906E-11   0.00000000000000E+00  -8.06293281464952E-13   3.52044492234364E-23
      5.29331368035769E-08   5.29323305102954E-08  -4.77811362623254E-19  -4.03978917095435E-01  -4.03978917095256E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.79659076626112E-10   0.00000000000000E+00  -1.79659076626112E-10
      2.13440874276158E-18  -4.49234576749158E-02  -2.83028347604008E-02   0.00000000000000E+00   1.10210890088786E-12
     -3.27934799213089E-23  -5.27537735425702E-08  -5.27526714336693E-08  -1.65659738013832E-18
      7.10411913703081E-07
      0.00000000000000E+00  -2.96094574493857E-11   0.00000000000000E+00  -6.33431843730699E-13   1.23479808617532E-23
      2.96101224607398E-08   2.96094890288960E-08  -4.25125272188995E-19  -4.24949299841965E-01  -4.24949299841843E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21808330158177E-10   0.00000000000000E+00  -1.21808330158177E-10
      1.91241306104830E-18  -2.02169118352039E-02  -1.09262977262316E-02   0.00000000000000E+00   7.39773497975397E-13
     -1.29492580580242E-23  -2.94884204722358E-08  -2.94876806987378E-08  -1.48728778885931E-18
      7.12411913703081E-07
      0.00000000000000E+00  -2.00899341273000E-11   0.00000000000000E+00  -2.34750134831594E-13   6.28275614450051E-24
      2.00901620021446E-08   2.00899272520098E-08  -3.68710178633477E-19  -4.47538224606580E-01  -4.47538224606478E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01928115484594E-10   0.00000000000000E+00  -1.01928115484594E-10
      1.70855683007911E-18  -1.21627793414316E-02  -5.86519938818000E-03   0.00000000000000E+00   2.91282882835492E-13
     -6.94969750825946E-24  -1.99882904194080E-08  -1.99879991365252E-08  -1.33984665144564E-18
      7.14411913703081E-07
      0.00000000000000E+00  -1.72956498424982E-11   0.00000000000000E+00  -6.85892938986258E-14   4.45516630525045E-24
      1.72956706836015E-08   1.72956020943076E-08  -3.14841529146577E-19  -4.69677586602168E-01  -4.69677586602068E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94379815873819E-11   0.00000000000000E+00  -9.94379815873819E-11
      1.50968086690435E-18  -9.69548284860552E-03  -4.27751593648945E-03   0.00000000000000E+00   1.10512932478961E-13
     -4.96176858917632E-24  -1.71962746256527E-08  -1.71961641127202E-08  -1.19483933775777E-18
      7.16411913703081E-07
      0.00000000000000E+00  -1.65214905525760E-11   0.00000000000000E+00  -1.87598350414325E-14   3.67745781532862E-24
      1.65214944475645E-08   1.65214756877295E-08  -2.63506915095064E-19  -4.91367758919602E-01  -4.91367758919501E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01257466002378E-10   0.00000000000000E+00  -1.01257466002378E-10
      1.30716593489959E-18  -8.77371887179461E-03  -3.60022411785956E-03   0.00000000000000E+00   5.39305868810320E-14
     -4.05205377419189E-24  -1.64202721523140E-08  -1.64202182217271E-08  -1.04365901980453E-18
      7.18411913703081E-07
      0.00000000000000E+00  -1.62897662806014E-11   0.00000000000000E+00  -5.43977982299101E-15   3.23038804333456E-24
      1.62897882313896E-08   1.62897827916098E-08  -2.14636281166623E-19  -5.12616296504407E-01  -5.12616296504303E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03685191625783E-10   0.00000000000000E+00  -1.03685191625783E-10
      1.09979555164803E-18  -8.31398481845111E-03  -3.21425090649214E-03   0.00000000000000E+00   3.61747696722813E-14
     -3.49909537761924E-24  -1.61861337747537E-08  -1.61860975999840E-08  -8.85159270481402E-19
      7.20411913703081E-07
      0.00000000000000E+00  -1.62037996065751E-11   0.00000000000000E+00  -1.84419280580271E-15   2.92495675791377E-24
      1.62038338593501E-08   1.62038320151573E-08  -1.68125266791443E-19  -5.33432162148535E-01  -5.33432162148429E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05774418486089E-10   0.00000000000000E+00  -1.05774418486089E-10
      8.88246714675849E-19  -8.02569631196421E-03  -2.95369835593455E-03   0.00000000000000E+00   2.92122390817848E-14
     -3.10877391523815E-24  -1.60980868089103E-08  -1.60980575966712E-08  -7.20121447884406E-19
      7.22411913703081E-07
      0.00000000000000E+00  -1.61620102511457E-11   0.00000000000000E+00  -7.80340190209974E-16   2.69770594962335E-24
      1.61620160595545E-08   1.61620152792143E-08  -1.23831375452052E-19  -5.53823480936568E-01  -5.53823480936461E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07321031826676E-10   0.00000000000000E+00  -1.07321031826676E-10
      6.73604651022498E-19  -7.82086318182587E-03  -2.76252581177206E-03   0.00000000000000E+00   2.54530369109198E-14
     -2.81400018808110E-24  -1.60547197004245E-08  -1.60546942473876E-08  -5.49773275570445E-19
      7.24411913703081E-07
      0.00000000000000E+00  -1.61370284826252E-11   0.00000000000000E+00  -3.85408170448300E-16   2.52050625661914E-24
      1.61370577549899E-08   1.61370573695817E-08  -8.15971364593177E-20  -5.73794411010955E-01  -5.73794411010846E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08306693146208E-10   0.00000000000000E+00  -1.08306693146208E-10
      4.56991264730081E-19  -7.66558672201773E-03  -2.61542152591809E-03   0.00000000000000E+00   2.28570670866680E-14
     -2.58301156193673E-24  -1.60287735335026E-08  -1.60287506764355E-08  -3.75394128270763E-19
      7.26411913703081E-07
      0.00000000000000E+00  -1.61201290509791E-11   0.00000000000000E+00  -2.04425135289284E-16   2.37810097597070E-24
      1.61201647010278E-08   1.61201644966026E-08  -4.13319494780474E-20  -5.93313563273368E-01  -5.93313563273260E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08588459835123E-10   0.00000000000000E+00  -1.08588459835123E-10
      2.39814345059835E-19  -7.54293092141505E-03  -2.49817528883713E-03   0.00000000000000E+00   2.08147007087877E-14
     -2.39744009426147E-24  -1.60115968514682E-08  -1.60115760367675E-08  -1.98482395581786E-19
      7.28411913703081E-07
      0.00000000000000E+00  -1.61062604956607E-11   0.00000000000000E+00  -1.48475965002592E-16   2.26206828496395E-24
      1.61062770623409E-08   1.61062769138649E-08  -3.44983257494670E-21  -6.12097079340305E-01  -6.12097079340198E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06772840642617E-10   0.00000000000000E+00  -1.06772840642617E-10
      2.62686637746014E-20  -7.44304916633036E-03  -2.40209571141489E-03   0.00000000000000E+00   1.88605026465898E-14
     -2.24699096222891E-24  -1.59995229337250E-08  -1.59995040732223E-08  -2.28188311996549E-20
      7.30411913703081E-07
      0.00000000000000E+00  -1.60783396955496E-11   0.00000000000000E+00  -5.16300095506992E-16   2.18026133576324E-24
      1.60783181670703E-08   1.60783176507702E-08   3.12006838990350E-20  -6.29613801555605E-01  -6.29613801555503E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01288316156089E-10   0.00000000000000E+00  -1.01288316156089E-10
     -1.76307968537576E-19  -7.38628620203241E-03  -2.35241276766220E-03   0.00000000000000E+00   1.70083182964203E-14
     -2.14318491959059E-24  -1.59770463429324E-08  -1.59770293346141E-08   1.45107284638541E-19
      7.32411913703081E-07
      0.00000000000000E+00  -1.60579501638896E-11   0.00000000000000E+00  -3.54613348612425E-16   2.11673723192603E-24
      1.60579886456931E-08   1.60579882910797E-08   6.11483485948723E-20  -6.45008894514120E-01  -6.45008894514030E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.03103313980877E-11   0.00000000000000E+00  -9.03103313980877E-11
     -3.56928631333752E-19  -7.34663065586643E-03  -2.31570264056361E-03   0.00000000000000E+00   1.41395654002060E-14
     -2.06340884982505E-24  -1.59676920992470E-08  -1.59676779596816E-08   2.95780282738880E-19
      7.34411913703081E-07
      0.00000000000000E+00  -1.60325091716831E-11   0.00000000000000E+00  -5.17658841630315E-16   2.06992563467166E-24
      1.60325204672084E-08   1.60325199495496E-08   8.40602580868465E-20  -6.56940966432433E-01  -6.56940966432363E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.07641462141548E-11   0.00000000000000E+00  -7.07641462141548E-11
     -4.98456923762062E-19  -7.31734370798413E-03  -2.28828089851873E-03   0.00000000000000E+00   1.06111173844355E-14
     -2.00624840811922E-24  -1.59617664144528E-08  -1.59617558033354E-08   4.14396665675215E-19
      7.36411913703081E-07
      0.00000000000000E+00  -1.59953120531140E-11   0.00000000000000E+00  -8.57311127055615E-16   2.04233362222741E-24
      1.59953185572816E-08   1.59953176999705E-08   9.67241230877381E-20  -6.63590336320165E-01  -6.63590336320125E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.97158438088377E-11   0.00000000000000E+00  -3.97158438088377E-11
     -5.77888611379737E-19  -7.29870345350775E-03  -2.27157918876368E-03   0.00000000000000E+00   5.87477733016767E-15
     -1.97544263330179E-24  -1.59556077309390E-08  -1.59556018561616E-08   4.81164488291999E-19
      7.36911913703082E-07
      0.00000000000000E+00  -1.59834640820143E-11   0.00000000000000E+00  -1.12721543240148E-15   2.03672535287781E-24
      1.59834466472958E-08   1.59834455200804E-08   9.90572701453314E-20  -6.64819341177528E-01  -6.64819341177498E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.94537446353870E-11   0.00000000000000E+00  -2.94537446353870E-11
     -5.92615483697430E-19  -7.29471323803474E-03  -2.26809619106124E-03   0.00000000000000E+00   4.35838433143747E-15
     -1.96976740572729E-24  -1.59539961338294E-08  -1.59539917754450E-08   4.93558213552098E-19
      7.37586913703081E-07
      0.00000000000000E+00  -1.59657380477332E-11   0.00000000000000E+00  -2.49409350350936E-15   2.03190361790894E-24
      1.59657018047253E-08   1.59656993106318E-08   1.00567438235417E-19  -6.65614963136781E-01  -6.65614963136766E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.41482992332843E-11   0.00000000000000E+00  -1.41482992332843E-11
     -6.02165585679897E-19  -7.29076299830402E-03  -2.26491453165534E-03   0.00000000000000E+00   3.40858066055788E-15
     -1.96580978698038E-24  -1.59515544199791E-08  -1.59515510113985E-08   5.01598147444480E-19
      7.38498163703082E-07
      0.00000000000000E+00  -1.59389193844686E-11   0.00000000000000E+00  -4.84262604383793E-15   2.03090149996079E-24
      1.59389183604620E-08   1.59389135178359E-08   9.92788948228892E-20  -6.64933703463007E-01  -6.64933703463016E-01
      0.00000000000000E+00   0.00000000000000E+00   8.92975441120432E-12   0.00000000000000E+00   8.92975441120432E-12
     -5.94028346972687E-19  -7.28841066654984E-03  -2.26372974872525E-03   0.00000000000000E+00   2.31061390971900E-15
     -1.96804897398604E-24  -1.59478455828610E-08  -1.59478432722471E-08   4.94749452149797E-19
      7.39728351203081E-07
      0.00000000000000E+00  -1.58974974079880E-11   0.00000000000000E+00  -6.97282365763560E-14   2.04123874540977E-24
      1.58974884282503E-08   1.58974187000137E-08   9.05738357728677E-20  -6.60349625499409E-01  -6.60349625499454E-01
      0.00000000000000E+00   0.00000000000000E+00   4.45359543672698E-11   0.00000000000000E+00   4.45359543672698E-11
     -5.39240772609502E-19  -7.29163119386282E-03  -2.26878548881996E-03   0.00000000000000E+00   6.18574063270534E-14
     -1.98727135677215E-24  -1.59420165117873E-08  -1.59419546543810E-08   4.48666936836634E-19
      7.41389104328081E-07
      0.00000000000000E+00  -1.58309099735126E-11   0.00000000000000E+00  -2.13601602502865E-15   2.08266199644443E-24
      1.58309052929623E-08   1.58309031569463E-08   6.34999396529102E-20  -6.46214844523308E-01  -6.46214844523409E-01
      0.00000000000000E+00   0.00000000000000E+00   1.01069134240303E-10   0.00000000000000E+00   1.01069134240303E-10
     -3.71389892078873E-19  -7.31108270696644E-03  -2.29140435581459E-03   0.00000000000000E+00  -1.45484098440363E-14
     -2.05197271811367E-24  -1.59319577427767E-08  -1.59319722911866E-08   3.07889952425963E-19
      7.43389104328082E-07
      0.00000000000000E+00  -1.57318095020656E-11   0.00000000000000E+00  -3.04783317252525E-15   2.19283027078070E-24
      1.57318137898602E-08   1.57318107420270E-08   2.11151582318221E-21  -6.14866867164773E-01  -6.14866867164956E-01
      0.00000000000000E+00   0.00000000000000E+00   1.82736665632950E-10   0.00000000000000E+00   1.82736665632950E-10
     -5.91656081297411E-21  -7.36648283194849E-03  -2.35229629013564E-03   0.00000000000000E+00  -2.80317979956085E-14
     -2.21913176315776E-24  -1.59145193758619E-08  -1.59145474076599E-08   3.80504498979228E-21
      7.45389104328082E-07
      0.00000000000000E+00  -1.55521611960877E-11   0.00000000000000E+00  -1.19660405939446E-14   2.47772922067919E-24
      1.55521613563809E-08   1.55521493903403E-08  -9.89261381639949E-20  -5.65505314623065E-01  -5.65505314623341E-01
      0.00000000000000E+00   0.00000000000000E+00   2.76476386454490E-10   0.00000000000000E+00   2.76476386454490E-10
      5.47036212096006E-19  -7.58714932494689E-03  -2.60003575332624E-03   0.00000000000000E+00  -4.14807487279927E-14
     -2.66417013138183E-24  -1.58285842960461E-08  -1.58286257767948E-08  -4.48110073932011E-19
      7.47389104328082E-07
      0.00000000000000E+00  -1.52467774448727E-11   0.00000000000000E+00  -8.46085431612156E-15   3.19303989793360E-24
      1.52467194933264E-08   1.52467110324721E-08  -2.55968557584174E-19  -4.94545283876724E-01  -4.94545283877089E-01
      0.00000000000000E+00   0.00000000000000E+00   3.64172512027520E-10   0.00000000000000E+00   3.64172512027520E-10
      1.27538123615105E-18  -8.22754141447000E-03  -3.30904190022483E-03   0.00000000000000E+00  -8.45725959668086E-14
     -3.99111532797902E-24  -1.56107989719036E-08  -1.56108835444996E-08  -1.01941267856687E-18
      7.49389104328082E-07
      0.00000000000000E+00  -1.39788608477228E-11   0.00000000000000E+00  -3.68935885267442E-14   5.24814950837249E-24
      1.39788533252085E-08   1.39788164316200E-08  -4.85695578812488E-19  -4.00046477187900E-01  -4.00046477188304E-01
      0.00000000000000E+00   0.00000000000000E+00   4.03173427009335E-10   0.00000000000000E+00   4.03173427009335E-10
      2.08172809016972E-18  -1.12552212568451E-02  -6.72392434982448E-03   0.00000000000000E+00  -1.49045820019846E-13
     -1.18925055652522E-23  -1.43818408128093E-08  -1.43819898586293E-08  -1.59603251135723E-18
      7.51389104328082E-07
      0.00000000000000E+00  -5.92150574198087E-12   0.00000000000000E+00  -2.13466399015435E-13  -6.46173703245523E-24
      5.92167597261331E-09   5.92146250621429E-09  -7.55787604324968E-19  -2.83730577004512E-01  -2.83730577004920E-01
      0.00000000000000E+00   0.00000000000000E+00   4.08284722788610E-10   0.00000000000000E+00   4.08284722788610E-10
      2.89829753574694E-18  -2.99539009226893E-02  -2.79596200740344E-02   0.00000000000000E+00  -2.53030273065428E-13
     -6.50237831676196E-23  -6.32949419872976E-09  -6.32974722900289E-09  -2.14250993142197E-18
      7.53389104328082E-07
      0.00000000000000E+00  -2.88759853780464E-13   0.00000000000000E+00  -1.45133918365675E-13  -4.11089429679247E-23
      2.88901773084272E-10   2.88756639165866E-10  -1.02000348222189E-18  -1.56994091424421E-01  -1.56994091424814E-01
      0.00000000000000E+00   0.00000000000000E+00   3.93365298483046E-10   0.00000000000000E+00   3.93365298483046E-10
      3.68502813271303E-18  -5.93088400462669E-02  -5.90939304434073E-02   0.00000000000000E+00  -8.09551068982646E-13
     -8.89800619266113E-23  -6.81312386579839E-10  -6.82121937648911E-10  -2.66502465049114E-18
      7.55389104328082E-07
      0.00000000000000E+00   8.27521082239816E-14   0.00000000000000E+00  -1.60343162846731E-14  -4.57702446509084E-23
     -8.27384861719819E-11  -8.27545204883123E-11  -1.21353632001429E-18  -6.04980111681872E-02  -6.04980111684763E-02
      0.00000000000000E+00   0.00000000000000E+00   2.89058921135523E-10   0.00000000000000E+00   2.89058921135523E-10
      4.26314597498407E-18  -8.90011408295512E-02  -8.89361425104079E-02   0.00000000000000E+00  -1.23346854959509E-12
     -1.00092124862890E-22  -2.05070932097516E-10  -2.06304400647211E-10  -3.04960965496979E-18
      7.57389104328082E-07
      0.00000000000000E+00   3.77481869922935E-14   0.00000000000000E+00  -1.28959596188212E-15  -4.63657001641868E-23
     -3.77322655896782E-11  -3.77335551856864E-11  -1.28856650813504E-18  -2.39766338112425E-02  -2.39766338113960E-02
      0.00000000000000E+00   0.00000000000000E+00   1.53453182726966E-10   0.00000000000000E+00   1.53453182726966E-10
      4.57005234043801E-18  -1.18267829158149E-01  -1.18231370814147E-01   0.00000000000000E+00  -7.76931321603953E-13
     -1.05517125673030E-22  -1.14942696219570E-10  -1.15719627541280E-10  -3.28148583230297E-18
      7.59389104328082E-07
      0.00000000000000E+00   4.22485791154623E-15   0.00000000000000E+00   7.65899651991194E-16  -4.63216905429904E-23
     -4.24420579443151E-12  -4.24343989482584E-12  -1.31286634761145E-18  -1.31543830740261E-02  -1.31543830741163E-02
      0.00000000000000E+00   0.00000000000000E+00   9.01714708251469E-11   0.00000000000000E+00   9.01714708251469E-11
      4.75039528208830E-18  -1.46992262831672E-01  -1.46965190861980E-01   0.00000000000000E+00  -4.85464961816030E-13
     -1.08429455743575E-22  -8.54425659683964E-11  -8.59280309303208E-11  -3.43752893447686E-18
      7.61389104328082E-07
      0.00000000000000E+00  -1.53380711136570E-14   0.00000000000000E+00   9.17522937616327E-16  -4.58761397460403E-23
      1.52923847295755E-11   1.52933022524672E-11  -1.31970019275642E-18  -9.97209866741147E-03  -9.97209866747430E-03
      0.00000000000000E+00   0.00000000000000E+00   6.28313873529172E-11   0.00000000000000E+00   6.28313873529172E-11
      4.87605805679413E-18  -1.75137683284937E-01  -1.75113070000588E-01   0.00000000000000E+00  -4.16256356554814E-13
     -1.10918262406056E-22  -7.77084332487188E-11  -7.81246896053845E-11  -3.55635786403772E-18
      7.63389104328082E-07
      0.00000000000000E+00  -2.90229369575785E-14   0.00000000000000E+00   7.53524255242271E-16  -4.47909508390646E-23
      2.90019346842614E-11   2.90026882084719E-11  -1.32027403215590E-18  -8.86993289592598E-03  -8.86993289597488E-03
      0.00000000000000E+00   0.00000000000000E+00   4.89075442038369E-11   0.00000000000000E+00   4.89075442038369E-11
      4.97387314520181E-18  -2.02701608674305E-01  -2.02677063141860E-01   0.00000000000000E+00  -4.20471679840518E-13
     -1.13059543368545E-22  -7.74897607323556E-11  -7.79102324123091E-11  -3.65359911304591E-18
      7.65389104328082E-07
      0.00000000000000E+00  -4.00443054224817E-14   0.00000000000000E+00   5.97387576213041E-16  -4.25787506980181E-23
      4.00159917188029E-11   4.00165891063365E-11  -1.31840889485015E-18  -8.36047373824839E-03  -8.36047373828892E-03
      0.00000000000000E+00   0.00000000000000E+00   4.05299841886638E-11   0.00000000000000E+00   4.05299841886638E-11
      5.05493311357914E-18  -2.29695511224006E-01  -2.29670135316552E-01   0.00000000000000E+00  -4.39691051301951E-13
     -1.15262605820444E-22  -8.01068822435821E-11  -8.05465732949993E-11  -3.73652421872899E-18
      7.67389104328082E-07
      0.00000000000000E+00  -4.95043133548569E-14   0.00000000000000E+00   4.66286094006158E-16  -3.86499191640645E-23
      4.95491690929483E-11   4.95496353790037E-11  -1.31558678195380E-18  -8.05486818785381E-03  -8.05486818788877E-03
      0.00000000000000E+00   0.00000000000000E+00   3.49599592845830E-11   0.00000000000000E+00   3.49599592845830E-11
      5.12485303214830E-18  -2.56134319667581E-01  -2.56107695441524E-01   0.00000000000000E+00  -4.59189943576226E-13
     -1.17710336513772E-22  -8.40504047198933E-11  -8.45095946635872E-11  -3.80926625019451E-18
      7.69389104328082E-07
      0.00000000000000E+00  -5.81377186523644E-14   0.00000000000000E+00   3.88927540064267E-16  -3.23867530157506E-23
      5.81577890013149E-11   5.81581779288225E-11  -1.31245936789213E-18  -7.84184701335627E-03  -7.84184701338732E-03
      0.00000000000000E+00   0.00000000000000E+00   3.10465455846184E-11   0.00000000000000E+00   3.10465455846184E-11
      5.18694612331754E-18  -2.82030150368243E-01  -2.82002047216318E-01   0.00000000000000E+00  -4.77005028100217E-13
     -1.20051763114416E-22  -8.87277184852216E-11  -8.92047235134419E-11  -3.87448675542541E-18
      7.71389104328082E-07
      0.00000000000000E+00  -6.61282107894193E-14   0.00000000000000E+00   3.33605089656963E-16  -2.32575258917087E-23
      6.61487357834083E-11   6.61490693884747E-11  -1.30932744682982E-18  -7.68172073253595E-03  -7.68172073256413E-03
      0.00000000000000E+00   0.00000000000000E+00   2.81792521099012E-11   0.00000000000000E+00   2.81792521099012E-11
      5.24330462753734E-18  -3.07388619698780E-01  -3.07358902668222E-01   0.00000000000000E+00  -4.94023086870058E-13
     -1.22460890958858E-22  -9.38342984113833E-11  -9.43283214983758E-11  -3.93397718070752E-18
      7.73389104328082E-07
      0.00000000000000E+00  -7.37513239776440E-14   0.00000000000000E+00   2.98779365378429E-16  -1.09937009629479E-23
      7.37230028886570E-11   7.37233016680114E-11  -1.30632407859357E-18  -7.55584234819413E-03  -7.55584234822012E-03
      0.00000000000000E+00   0.00000000000000E+00   2.59888619558179E-11   0.00000000000000E+00   2.59888619558179E-11
      5.29528235144898E-18  -3.32214217172766E-01  -3.32182804311709E-01   0.00000000000000E+00  -5.11672217786454E-13
     -1.24912817780575E-22  -9.92004914059178E-11  -9.97121636238291E-11  -3.98895827285541E-18
      7.75389104328082E-07
      0.00000000000000E+00  -8.10070582170386E-14   0.00000000000000E+00   2.75376209966671E-16   4.19429442135127E-24
      8.10177491275424E-11   8.10180245037566E-11  -1.30349857401194E-18  -7.45372029379686E-03  -7.45372029382110E-03
      0.00000000000000E+00   0.00000000000000E+00   2.42397698931292E-11   0.00000000000000E+00   2.42397698931292E-11
      5.34376189123524E-18  -3.56514262164458E-01  -3.56481102539060E-01   0.00000000000000E+00  -5.31244277839851E-13
     -1.27372576888472E-22  -1.04726550118919E-10  -1.05257794396886E-10  -4.04026331722329E-18
      7.77389104328082E-07
      0.00000000000000E+00  -8.81709477192257E-14   0.00000000000000E+00   2.63116493534910E-16   2.08977842265264E-23
      8.81967654012229E-11   8.81970285177373E-11  -1.30081246185397E-18  -7.39206650913994E-03  -7.39206650916266E-03
      0.00000000000000E+00   0.00000000000000E+00   2.27187465555700E-11   0.00000000000000E+00   2.27187465555700E-11
      5.38919938434637E-18  -3.80276563741212E-01  -3.80241621996807E-01   0.00000000000000E+00  -5.52354578608334E-13
     -1.30317427212919E-22  -1.10363420494569E-10  -1.10915775073307E-10  -4.08838692249242E-18
      7.79389104328082E-07
      0.00000000000000E+00  -9.52429924842052E-14   0.00000000000000E+00   2.52727235752956E-16   3.79476519212925E-23
      9.52661965570182E-11   9.52664492842919E-11  -1.29828114773195E-18  -7.35077759970551E-03  -7.35077759972698E-03
      0.00000000000000E+00   0.00000000000000E+00   2.14744161799949E-11   0.00000000000000E+00   2.14744161799949E-11
      5.43214821670637E-18  -4.03596912493918E-01  -4.03560136025884E-01   0.00000000000000E+00  -5.80058102063180E-13
     -1.32374975177896E-22  -1.16160807362091E-10  -1.16740865464287E-10  -4.13386706897442E-18
      7.81389104328082E-07
      0.00000000000000E+00  -1.02315037249185E-13   0.00000000000000E+00   2.44970128761531E-16   5.43209530264448E-23
      1.02270144911818E-10   1.02270389882001E-10  -1.29589846184143E-18  -7.32031290927266E-03  -7.32031290929309E-03
      0.00000000000000E+00   0.00000000000000E+00   2.04279579383178E-11   0.00000000000000E+00   2.04279579383178E-11
      5.47300413258300E-18  -4.26571350018002E-01  -4.26532697165865E-01   0.00000000000000E+00  -6.14846814239450E-13
     -1.34960544083777E-22  -1.22083501005944E-10  -1.22698347820318E-10  -4.17710567074158E-18
      7.83389104328082E-07
      0.00000000000000E+00  -1.09203392539749E-13   0.00000000000000E+00   2.38452441501660E-16   6.92864003027743E-23
      1.09210572213241E-10   1.09210810665751E-10  -1.29365163042662E-18  -7.30039435893340E-03  -7.30039435895280E-03
      0.00000000000000E+00   0.00000000000000E+00   1.94020489908532E-11   0.00000000000000E+00   1.94020489908532E-11
      5.51180823056471E-18  -4.49126153723657E-01  -4.49085638080401E-01   0.00000000000000E+00  -6.50690577430484E-13
     -1.37684623566147E-22  -1.27962169079036E-10  -1.28612859656604E-10  -4.21815660013809E-18
      7.85389104328082E-07
      0.00000000000000E+00  -1.16091747830314E-13   0.00000000000000E+00   2.33179722934911E-16   8.23946962558587E-23
      1.16095015762848E-10   1.16095248942653E-10  -1.29152215149969E-18  -7.29314500223941E-03  -7.29314500225781E-03
      0.00000000000000E+00   0.00000000000000E+00   1.84024439585418E-11   0.00000000000000E+00   1.84024439585418E-11
      5.54861311848179E-18  -4.71232907862572E-01  -4.71190538836543E-01   0.00000000000000E+00  -6.88486035394395E-13
     -1.40449290222718E-22  -1.33809206865660E-10  -1.34497692901195E-10  -4.25709096698210E-18
      7.87389104328082E-07
      0.00000000000000E+00  -1.22980103120878E-13   0.00000000000000E+00   2.29374931981970E-16   9.35000653905266E-23
      1.22940968684898E-10   1.22941198059923E-10  -1.28948690582964E-18  -7.30275456828644E-03  -7.30275456830388E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74378989210380E-11   0.00000000000000E+00   1.74378989210380E-11
      5.58348891632387E-18  -4.92891333880902E-01  -4.92847112614995E-01   0.00000000000000E+00  -7.28238371377368E-13
     -1.43271385151988E-22  -1.39650858609441E-10  -1.40379096980962E-10  -4.29400201049423E-18
      7.89389104328083E-07
      0.00000000000000E+00  -1.29776613674235E-13   0.00000000000000E+00   2.27835112063449E-16   1.02638463457587E-22
      1.29786456935015E-10   1.29786684770229E-10  -1.28751486859817E-18  -7.33730531092367E-03  -7.33730531094017E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65078593617584E-11   0.00000000000000E+00   1.65078593617584E-11
      5.61650463504738E-18  -5.14108841501327E-01  -5.14062757338536E-01   0.00000000000000E+00  -7.68846091832262E-13
     -1.46113537229861E-22  -1.45525698040011E-10  -1.46294544131989E-10  -4.32898976644922E-18
      7.91389104328083E-07
      0.00000000000000E+00  -1.36848658439215E-13   0.00000000000000E+00   2.37604625552763E-16   1.10263576414130E-22
      1.36890284459072E-10   1.36890522063808E-10  -1.28548186059518E-18  -7.44842231759444E-03  -7.44842231760998E-03
      0.00000000000000E+00   0.00000000000000E+00   1.55408712173366E-11   0.00000000000000E+00   1.55408712173366E-11
      5.64758637748206E-18  -5.34894281883618E-01  -5.34846265153503E-01   0.00000000000000E+00  -8.06954745689974E-13
     -1.48975866059101E-22  -1.51624438535305E-10  -1.52431393281144E-10  -4.36210451688688E-18
      7.93389104328083E-07
      0.00000000000000E+00  -1.45022840050685E-13   0.00000000000000E+00   2.87995973328689E-16   1.17076462295422E-22
      1.44992288577879E-10   1.44992576573969E-10  -1.28305607509115E-18  -7.78123526729941E-03  -7.78123526731378E-03
      0.00000000000000E+00   0.00000000000000E+00   1.43719673224070E-11   0.00000000000000E+00   1.43719673224070E-11
      5.67633031212687E-18  -5.55255620980327E-01  -5.55205420930657E-01   0.00000000000000E+00  -8.36315646602185E-13
     -1.51798474923350E-22  -1.58528228249623E-10  -1.59364543896377E-10  -4.39327423703573E-18
      7.95389104328083E-07
      0.00000000000000E+00  -1.57238190099286E-13   0.00000000000000E+00   5.13484774618953E-16   1.25130584737849E-22
      1.57213306727023E-10   1.57213820211923E-10  -1.27896326943763E-18  -8.90991144942187E-03  -8.90991144943410E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22279406442753E-11   0.00000000000000E+00   1.22279406442753E-11
      5.70078619341542E-18  -5.75196109851056E-01  -5.75142736231643E-01   0.00000000000000E+00  -8.33435954037582E-13
     -1.54476738329810E-22  -1.68608324902006E-10  -1.69441760856198E-10  -4.42182292397779E-18
      7.97389104328083E-07
      0.00000000000000E+00  -2.04538229761162E-13   0.00000000000000E+00   1.67697982126848E-15   1.51323367575662E-22
      2.04506369452496E-10   2.04508046432468E-10  -1.26238832616205E-18  -1.57527716671455E-02  -1.57527716671467E-02
      0.00000000000000E+00   0.00000000000000E+00   1.22384165772788E-12   0.00000000000000E+00   1.22384165772788E-12
      5.70323387673088E-18  -5.94674086727867E-01  -5.94609282870740E-01   0.00000000000000E+00  -5.73588969944056E-13
     -1.56275526985814E-22  -2.05158299120095E-10  -2.05731888090196E-10  -4.44084555056883E-18
      7.99389104328083E-07
      0.00000000000000E+00  -4.43977459661184E-13   0.00000000000000E+00   8.03955248394444E-15   2.44592018197781E-22
      4.44019536385801E-10   4.44027575938530E-10  -1.20204951325118E-18  -4.15473808483602E-02  -4.15473808483241E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.60912554129728E-11   0.00000000000000E+00  -3.60912554129728E-11
      5.63105136590493E-18  -6.13377727289783E-01  -6.13249231918375E-01   0.00000000000000E+00   3.60111700639269E-13
     -1.55139593505718E-22  -4.08296432226041E-10  -4.07936320525556E-10  -4.42900185265375E-18
      8.01389104328083E-07
      0.00000000000000E+00  -9.54817888009448E-13   0.00000000000000E+00   1.46346875393580E-14   3.21334979126679E-22
      9.54833317551312E-10   9.54847952239172E-10  -1.12809700690504E-18  -7.13138968583258E-02  -7.13138968582740E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.18117449178199E-11   0.00000000000000E+00  -5.18117449178199E-11
      5.52742787606929E-18  -6.30755367384051E-01  -6.30470918607565E-01   0.00000000000000E+00   5.00648079916108E-13
     -1.53593928356754E-22  -9.03536855401116E-10  -9.03036207321353E-10  -4.39933086916425E-18
      8.03389104328083E-07
      0.00000000000000E+00  -1.93388278664168E-12   0.00000000000000E+00   2.58563535201727E-14   3.68461048422611E-22
      1.93385803944331E-09   1.93388389579720E-09  -1.05497211802742E-18  -1.00857003016566E-01  -1.00857003016505E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.15633659827539E-11   0.00000000000000E+00  -6.15633659827539E-11
      5.40430114410378E-18  -6.45914435022662E-01  -6.45324665218997E-01   0.00000000000000E+00   4.27271280908630E-13
     -1.52143750970100E-22  -1.87274780109520E-09  -1.87232052981445E-09  -4.34932902607637E-18
      8.05389104328083E-07
      0.00000000000000E+00  -3.65303257769217E-12   0.00000000000000E+00   4.38675352213442E-14   4.03967167636013E-22
      3.65303127786774E-09   3.65307514540336E-09  -9.87737015407277E-19  -1.29913050833105E-01  -1.29913050833031E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.33819868815904E-11   0.00000000000000E+00  -7.33819868815904E-11
      5.25753717034061E-18  -6.57468556355006E-01  -6.56340967452335E-01   0.00000000000000E+00   3.31546145578209E-13
     -1.51049173583743E-22  -3.58002470466720E-09  -3.57969315852177E-09  -4.26980015493333E-18
      8.07389104328083E-07
      0.00000000000000E+00  -6.36934068060477E-12   0.00000000000000E+00   6.82226272600785E-14   4.31947898581434E-22
      6.36929578079120E-09   6.36936400341889E-09  -9.27851169942286E-19  -1.58405924023324E-01  -1.58405924023236E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.81751693392873E-11   0.00000000000000E+00  -8.81751693392873E-11
      5.08118683166203E-18  -6.63562126694953E-01  -6.61583567412245E-01   0.00000000000000E+00   2.48350738924677E-13
     -1.50001176772658E-22  -6.28143718481837E-09  -6.28118883407960E-09  -4.15333566171974E-18
      8.09389104328083E-07
      0.00000000000000E+00  -1.02692519119108E-11   0.00000000000000E+00   9.73076629084865E-14   4.49980813693993E-22
      1.02691144646401E-08   1.02692117723035E-08  -8.74227545047649E-19  -1.86316177865063E-01  -1.86316177864959E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04177289267680E-10   0.00000000000000E+00  -1.04177289267680E-10
      4.87283225312667E-18  -6.62010360880994E-01  -6.58808381086094E-01   0.00000000000000E+00   2.64714767140634E-13
     -1.48908911466239E-22  -1.01652991978028E-08  -1.01650344830358E-08  -3.99860470807902E-18
      8.11389104328083E-07
      0.00000000000000E+00  -1.55167091275256E-11   0.00000000000000E+00   1.30267173943427E-13   4.56226210161314E-22
      1.55165683972845E-08   1.55166986644589E-08  -8.24836999653080E-19  -2.13648618137149E-01  -2.13648618137030E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18528376189456E-10   0.00000000000000E+00  -1.18528376189456E-10
      4.63577550074776E-18  -6.50345900594359E-01  -6.45495439221737E-01   0.00000000000000E+00   4.87647064239608E-13
     -1.47106368111666E-22  -1.53986579353335E-08  -1.53981702882694E-08  -3.81093850109468E-18
      8.13389104328083E-07
      0.00000000000000E+00  -2.23510597126121E-11   0.00000000000000E+00   1.69646055213587E-13   4.50364862534514E-22
      2.23509127693993E-08   2.23510824154550E-08  -7.77815698380131E-19  -2.40417049791616E-01  -2.40417049791486E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29575660833018E-10   0.00000000000000E+00  -1.29575660833018E-10
      4.37662417908172E-18  -6.25678744078181E-01  -6.18678792423457E-01   0.00000000000000E+00   9.57844026761550E-13
     -1.43124506080308E-22  -2.22224645986486E-08  -2.22215067546220E-08  -3.59880848070159E-18
      8.15389104328083E-07
      0.00000000000000E+00  -3.10883414079013E-11   0.00000000000000E+00   2.16721672615187E-13   4.32645522913556E-22
      3.10880889115360E-08   3.10883056332091E-08  -7.31867291094078E-19  -2.66635877576008E-01  -2.66635877575870E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37884413315153E-10   0.00000000000000E+00  -1.37884413315153E-10
      4.10085535245141E-18  -5.84555028767718E-01  -5.74805125137923E-01   0.00000000000000E+00   1.56990022725502E-12
     -1.36533918830880E-22  -3.09519911201210E-08  -3.09504212198939E-08  -3.36898806135734E-18
      8.17389104328083E-07
      0.00000000000000E+00  -4.18963545482714E-11   0.00000000000000E+00   2.60333416529085E-13   4.00802374258146E-22
      4.18960350957042E-08   4.18962954291212E-08  -6.86365672345229E-19  -2.92314821535979E-01  -2.92314821535833E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.46143502247086E-10   0.00000000000000E+00  -1.46143502247086E-10
      3.80856834795725E-18  -5.23244331193338E-01  -5.10091839188388E-01   0.00000000000000E+00   2.05298595849409E-12
     -1.26701493412153E-22  -4.17522049128325E-08  -4.17501519268741E-08  -3.12220267561201E-18
      8.19389104328083E-07
      0.00000000000000E+00  -5.42993433949875E-11   0.00000000000000E+00   3.08225663034154E-13   3.42021559701412E-22
      5.42990288483058E-08   5.42993370739692E-08  -6.41314998412716E-19  -3.17457505024739E-01  -3.17457505024581E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.57604930774950E-10   0.00000000000000E+00  -1.57604930774950E-10
      3.49335848640734E-18  -4.38963453238846E-01  -4.21906597593077E-01   0.00000000000000E+00   2.08567886039066E-12
     -1.15185032062141E-22  -5.41438178220545E-08  -5.41417321431943E-08  -2.85204348799463E-18
      8.21389104328083E-07
      0.00000000000000E+00  -6.70075323034441E-11   0.00000000000000E+00   3.16376585959919E-13   2.66310804619036E-22
      6.70072290944513E-08   6.70075454710375E-08  -5.96760578957300E-19  -3.42071350032839E-01  -3.42071350032669E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.70426745614029E-10   0.00000000000000E+00  -1.70426745614029E-10
      3.15250499517929E-18  -3.31457243642942E-01  -3.10400067639527E-01   0.00000000000000E+00   1.83666360176045E-12
     -1.02597231818800E-22  -6.68389553890252E-08  -6.68371187254235E-08  -2.55574441622199E-18
      8.23389104328083E-07
      0.00000000000000E+00  -7.64831538411447E-11   0.00000000000000E+00   2.36476390918347E-13   2.00924039943832E-22
      7.64828978896649E-08   7.64831343660560E-08  -5.53036234795777E-19  -3.66155861759821E-01  -3.66155861759632E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.88657079292840E-10   0.00000000000000E+00  -1.88657079292840E-10
      2.77519083659361E-18  -2.07528388523391E-01  -1.83490971485823E-01   0.00000000000000E+00   1.31571314859545E-12
     -8.81695032589367E-23  -7.62957929999117E-08  -7.62944772867632E-08  -2.22215460179783E-18
      8.25389104328083E-07
      0.00000000000000E+00  -7.42928405482196E-11   0.00000000000000E+00   2.31453976399558E-13   8.61872888022473E-23
      7.42929689246131E-08   7.42932003785896E-08  -5.09769771542728E-19  -3.89714309247172E-01  -3.89714309246962E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.10399746909191E-10   0.00000000000000E+00  -2.10399746909191E-10
      2.35439134277522E-18  -9.02493444563326E-02  -6.69084862636772E-02   0.00000000000000E+00   5.23393940895237E-13
     -6.13088963369526E-23  -7.40833240256214E-08  -7.40828006316805E-08  -1.84462157123250E-18
      8.27389104328083E-07
      0.00000000000000E+00  -4.42710920735092E-11   0.00000000000000E+00  -7.45320972701543E-13   2.38133407347139E-23
      4.42717855143669E-08   4.42710401933942E-08  -4.55788387793745E-19  -4.12902367903953E-01  -4.12902367903795E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.57802503098676E-10   0.00000000000000E+00  -1.57802503098676E-10
      2.03878633657787E-18  -3.37440116406605E-02  -1.98453739766758E-02   0.00000000000000E+00   9.69286550431732E-13
     -2.31052574421473E-23  -4.41142069768459E-08  -4.41132376902955E-08  -1.58299794878413E-18
      8.29389104328083E-07
      0.00000000000000E+00  -2.49421834387108E-11   0.00000000000000E+00  -4.77765887026180E-13   8.96360600355528E-24
      2.49426394830802E-08   2.49421617171932E-08  -3.98184180108016E-19  -4.35714830774804E-01  -4.35714830774692E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11531464644019E-10   0.00000000000000E+00  -1.11531464644019E-10
      1.81572340728984E-18  -1.59812772009469E-02  -8.15794387117701E-03   0.00000000000000E+00   5.56780316748881E-13
     -9.68269302754527E-24  -2.48311870328659E-08  -2.48306302525492E-08  -1.41753922718182E-18
      8.31389104328083E-07
      0.00000000000000E+00  -1.86341031978235E-11   0.00000000000000E+00  -1.55363648529763E-13   5.27678913291171E-24
      1.86342698307072E-08   1.86341144670587E-08  -3.42884825364395E-19  -4.58090203801921E-01  -4.58090203801820E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00424260295027E-10   0.00000000000000E+00  -1.00424260295027E-10
      1.61487488669978E-18  -1.08399082915243E-02  -5.00053193426236E-03   0.00000000000000E+00   2.03919342298632E-13
     -5.87682662468472E-24  -1.85338941261059E-08  -1.85336902067636E-08  -1.27199006133539E-18
      8.33389104328084E-07
      0.00000000000000E+00  -1.68802360961085E-11   0.00000000000000E+00  -4.29218323677999E-14   4.03889390282011E-24
      1.68802650853021E-08   1.68802221634697E-08  -2.90201528995816E-19  -4.80015650634119E-01  -4.80015650634019E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00253585090985E-10   0.00000000000000E+00  -1.00253585090985E-10
      1.41436771651781E-18  -9.20306861269662E-03  -3.91622980096244E-03   0.00000000000000E+00   8.13145054204834E-14
     -4.48135590564505E-24  -1.67800498928841E-08  -1.67799685783787E-08  -1.12416618752199E-18
      8.35389104328084E-07
      0.00000000000000E+00  -1.63959387968133E-11   0.00000000000000E+00  -1.16249511445327E-14   3.44424452032247E-24
      1.63959571977093E-08   1.63959455727582E-08  -2.40039297377039E-19  -5.01495327926620E-01  -5.01495327926517E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02453687307553E-10   0.00000000000000E+00  -1.02453687307553E-10
      1.20946034190271E-18  -8.53237481892859E-03  -3.39880596321991E-03   0.00000000000000E+00   4.45378138765616E-14
     -3.76616221171183E-24  -1.62935364232645E-08  -1.62934918854507E-08  -9.69421044525667E-19
      8.37389104328084E-07
      0.00000000000000E+00  -1.62436602225232E-11   0.00000000000000E+00  -3.46650839960147E-15   3.07381781246486E-24
      1.62436343596175E-08   1.62436308931091E-08  -1.92301487607871E-19  -5.22537687573416E-01  -5.22537687573311E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04745404915453E-10   0.00000000000000E+00  -1.04745404915453E-10
      9.99969532071800E-19  -8.16521962138558E-03  -3.08035941718694E-03   0.00000000000000E+00   3.25077018136109E-14
     -3.29994287988462E-24  -1.61389179958955E-08  -1.61388854881937E-08  -8.07668044463929E-19
      8.39389104328084E-07
      0.00000000000000E+00  -1.61817568696453E-11   0.00000000000000E+00  -1.26168893855282E-15   2.80979112702046E-24
      1.61817965983783E-08   1.61817953366894E-08  -1.46860678222182E-19  -5.43151380168856E-01  -5.43151380168750E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06579248180782E-10   0.00000000000000E+00  -1.06579248180782E-10
      7.86811035710236E-19  -7.92130789200410E-03  -2.85650567675534E-03   0.00000000000000E+00   2.72812584003615E-14
     -2.95967138436066E-24  -1.60752433697670E-08  -1.60752160885086E-08  -6.39950357488054E-19
      8.41389104328084E-07
      0.00000000000000E+00  -1.61490601431994E-11   0.00000000000000E+00  -5.65964382579894E-16   2.60863650009900E-24
      1.61490903686356E-08   1.61490898026712E-08  -1.03562277536731E-19  -5.63343447905785E-01  -5.63343447905677E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07858642589789E-10   0.00000000000000E+00  -1.07858642589789E-10
      5.71093750530659E-19  -7.74247552559250E-03  -2.68837905838117E-03   0.00000000000000E+00   2.41422571536396E-14
     -2.69793203446686E-24  -1.60412553023386E-08  -1.60412311600814E-08  -4.67531472993928E-19
      8.43389104328084E-07
      0.00000000000000E+00  -1.61284869220649E-11   0.00000000000000E+00  -2.86727839421997E-16   2.44933218823331E-24
      1.61284893418649E-08   1.61284890551371E-08  -6.22596707745628E-20  -5.83110527608500E-01  -5.83110527608391E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08560349377713E-10   0.00000000000000E+00  -1.08560349377713E-10
      3.53973051775232E-19  -7.60415612472999E-03  -2.55676965399990E-03   0.00000000000000E+00   2.18482324644410E-14
     -2.49020368845310E-24  -1.60199505539918E-08  -1.60199287057594E-08  -2.91713381000669E-19
      8.45389104328084E-07
      0.00000000000000E+00  -1.61135162299001E-11   0.00000000000000E+00  -1.65666759790471E-16   2.32019111023260E-24
      1.61135091608798E-08   1.61135089952131E-08  -2.30361810473894E-20  -6.02335211031400E-01  -6.02335211031292E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08098324811783E-10   0.00000000000000E+00  -1.08098324811783E-10
      1.37776402151667E-19  -7.49328379899458E-03  -2.45047004114295E-03   0.00000000000000E+00   1.99020424795051E-14
     -2.32222058747578E-24  -1.60054305724438E-08  -1.60054106704013E-08  -1.14740221104276E-19
      8.47389104328084E-07
      0.00000000000000E+00  -1.60939533008749E-11   0.00000000000000E+00  -2.98193281598807E-16   2.22049554746297E-24
      1.60939293909212E-08   1.60939290927280E-08   1.34545616438823E-20  -6.20602809176377E-01  -6.20602809176273E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04735695344194E-10   0.00000000000000E+00  -1.04735695344194E-10
     -7.16949885367222E-20  -7.41326005320322E-03  -2.37555464236667E-03   0.00000000000000E+00   1.80084169294622E-14
     -2.19398914203357E-24  -1.59892114058007E-08  -1.59891933973838E-08   5.82404268928396E-20
      8.49389104328084E-07
      0.00000000000000E+00  -1.60687878428801E-11   0.00000000000000E+00  -4.57588600297209E-16   2.14813211886722E-24
      1.60688196096337E-08   1.60688191520451E-08   4.61204204215575E-20  -6.37254472922839E-01  -6.37254472922742E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.69832817590393E-11   0.00000000000000E+00  -9.69832817590393E-11
     -2.65661552054801E-19  -7.36614491230756E-03  -2.33390732237489E-03   0.00000000000000E+00   1.57645054905443E-14
     -2.10266452599762E-24  -1.59718516347915E-08  -1.59718358702860E-08   2.19541131633244E-19
      8.51389104328084E-07
      0.00000000000000E+00  -1.60472043296363E-11   0.00000000000000E+00  -4.01249407305990E-16   2.09230412616497E-24
      1.60472326160802E-08   1.60472322148308E-08   7.31021231999525E-20  -6.51217970003323E-01  -6.51217970003241E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.23761510014092E-11   0.00000000000000E+00  -8.23761510014092E-11
     -4.30413854057619E-19  -7.33149876242995E-03  -2.30145948116671E-03   0.00000000000000E+00   1.25962102577375E-14
     -2.03323825032731E-24  -1.59648686600396E-08  -1.59648560638294E-08   3.57311730857667E-19
      8.53389104328084E-07
      0.00000000000000E+00  -1.60167118768834E-11   0.00000000000000E+00  -6.63955844188476E-16   2.05411230813465E-24
      1.60167127819636E-08   1.60167121180078E-08   9.16362845894363E-20  -6.60914567015953E-01  -6.60914567015896E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.77297384508854E-11   0.00000000000000E+00  -5.77297384508854E-11
     -5.45873330959390E-19  -7.30702758715308E-03  -2.27883837410511E-03   0.00000000000000E+00   8.56038614977867E-15
     -1.98787752272793E-24  -1.59589909399430E-08  -1.59589823795569E-08   4.54237046369955E-19
      8.55389104328084E-07
      0.00000000000000E+00  -1.59729019372354E-11   0.00000000000000E+00  -1.05062164857185E-15   2.03701899419057E-24
      1.59728695730966E-08   1.59728685224749E-08   9.81610358368161E-20  -6.64346234159229E-01  -6.64346234159209E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.05430760028341E-11   0.00000000000000E+00  -2.05430760028341E-11
     -5.86959482965058E-19  -7.29410468550165E-03  -2.26801267275913E-03   0.00000000000000E+00   3.10573848425746E-15
     -1.97152198816407E-24  -1.59523285522106E-08  -1.59523254464721E-08   4.88798447128242E-19
      8.57389104328084E-07
      0.00000000000000E+00  -1.59133865475249E-11   0.00000000000000E+00  -1.51433004271065E-15   2.04703498560234E-24
      1.59133786028426E-08   1.59133770885125E-08   8.84311691026462E-20  -6.59225583019461E-01  -6.59225583019491E-01
      0.00000000000000E+00   0.00000000000000E+00   3.05755114628834E-11   0.00000000000000E+00   3.05755114628834E-11
     -5.25808460039291E-19  -7.29593319905794E-03  -2.27247949159121E-03   0.00000000000000E+00  -4.18006624537448E-15
     -1.99275265388632E-24  -1.59439484199092E-08  -1.59439525999754E-08   4.37377290936646E-19
      8.59389104328084E-07
      0.00000000000000E+00  -1.58358695893218E-11   0.00000000000000E+00  -2.18133433149799E-15   2.09533540730685E-24
      1.58358490701185E-08   1.58358468887842E-08   5.71872645067718E-20  -6.42946680048178E-01  -6.42946680048274E-01
      0.00000000000000E+00   0.00000000000000E+00   9.64954260026218E-11   0.00000000000000E+00   9.64954260026218E-11
     -3.32817608034048E-19  -7.31864123474789E-03  -2.29884645367485E-03   0.00000000000000E+00  -1.38611156290046E-14
     -2.06827872193670E-24  -1.59323284536712E-08  -1.59323423147868E-08   2.75630343527275E-19
      8.61389104328084E-07
      0.00000000000000E+00  -1.57358506705028E-11   0.00000000000000E+00  -2.76672811043800E-15   2.20564797988628E-24
      1.57358598005230E-08   1.57358570337949E-08  -2.78671640985219E-21  -6.12408673267667E-01  -6.12408673267844E-01
      0.00000000000000E+00   0.00000000000000E+00   1.77576765990936E-10   0.00000000000000E+00   1.77576765990936E-10
      2.23359239478233E-20  -7.37618426504376E-03  -2.36234884077782E-03   0.00000000000000E+00  -2.77421437623951E-14
     -2.23629049899059E-24  -1.59134060576420E-08  -1.59134337997858E-08  -1.95492075379709E-20
      8.63389104328084E-07
      0.00000000000000E+00  -1.55573963461085E-11   0.00000000000000E+00  -7.60361678788288E-14   2.49047781299239E-24
      1.55573512873137E-08   1.55572752511458E-08  -1.02161267614358E-19  -5.63973733044781E-01  -5.63973733045052E-01
      0.00000000000000E+00   0.00000000000000E+00   2.70669214376049E-10   0.00000000000000E+00   2.70669214376049E-10
      5.63674352699921E-19  -7.59795309245349E-03  -2.61103412444720E-03   0.00000000000000E+00   2.32702520391525E-14
     -2.68219330097771E-24  -1.58279677357739E-08  -1.58279444655219E-08  -4.61513085085563E-19
      8.65389104328084E-07
      0.00000000000000E+00  -1.52535739554260E-11   0.00000000000000E+00  -1.32154178602935E-14   3.20200830355531E-24
      1.52536496189561E-08   1.52536364035382E-08  -2.57055835821381E-19  -4.94077480238288E-01  -4.94077480238646E-01
      0.00000000000000E+00   0.00000000000000E+00   3.58099150304252E-10   0.00000000000000E+00   3.58099150304252E-10
      1.27987265330842E-18  -8.23652597770368E-03  -3.31775657883174E-03   0.00000000000000E+00  -7.87948332876113E-14
     -4.00569518250425E-24  -1.56116567590092E-08  -1.56117355538425E-08  -1.02281681748704E-18
      8.67389104328084E-07
      0.00000000000000E+00  -1.40073327162571E-11   0.00000000000000E+00  -3.25736329919273E-14   5.30209998343600E-24
      1.40073547281933E-08   1.40073221545603E-08  -4.84036129272312E-19  -4.00715339223749E-01  -4.00715339224148E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98417624413275E-10   0.00000000000000E+00   3.98417624413275E-10
      2.07670790213498E-18  -1.12176840113731E-02  -6.67890529500586E-03   0.00000000000000E+00  -1.50975011211042E-13
     -1.18696077191602E-23  -1.44055888039624E-08  -1.44057397789736E-08  -1.59267177286266E-18
      8.69389104328084E-07
      0.00000000000000E+00  -6.08765287158929E-12   0.00000000000000E+00  -2.11137242164247E-13  -5.76501104581420E-24
      6.08787500713359E-09   6.08766386989142E-09  -7.52132219486166E-19  -2.85428931595673E-01  -2.85428931596078E-01
      0.00000000000000E+00   0.00000000000000E+00   4.05191637894258E-10   0.00000000000000E+00   4.05191637894258E-10
      2.88709117792349E-18  -2.95985062482594E-02  -2.75528350906043E-02   0.00000000000000E+00  -2.47834345622229E-13
     -6.40369514133641E-23  -6.49260767343999E-09  -6.49285550778568E-09  -2.13495895843732E-18
      8.71389104328084E-07
      0.00000000000000E+00  -3.15578517045062E-13   0.00000000000000E+00  -1.48511296194968E-13  -4.08468340381284E-23
      3.15743364127502E-10   3.15594852831266E-10  -1.01525464877936E-18  -1.59275727671816E-01  -1.59275727672209E-01
      0.00000000000000E+00   0.00000000000000E+00   3.92705925596059E-10   0.00000000000000E+00   3.92705925596059E-10
      3.67250302911561E-18  -5.89095051309862E-02  -5.86863475877754E-02   0.00000000000000E+00  -7.93622696400716E-13
     -8.88685121064953E-23  -7.07507155730836E-10  -7.08300778427326E-10  -2.65724838033625E-18
      8.73389104328084E-07
      0.00000000000000E+00   8.25684187495665E-14   0.00000000000000E+00  -1.67357582920242E-14  -4.56847243324117E-23
     -8.25214702993383E-11  -8.25382060576760E-11  -1.21101465998287E-18  -6.17310236277290E-02  -6.17310236280206E-02
      0.00000000000000E+00   0.00000000000000E+00   2.91619975880744E-10   0.00000000000000E+00   2.91619975880744E-10
      4.25574298087709E-18  -8.86044774758839E-02  -8.85386041171305E-02   0.00000000000000E+00  -1.23561090427068E-12
     -1.00044285339089E-22  -2.07846158918697E-10  -2.09081769823068E-10  -3.04472832089423E-18
      8.75389104328084E-07
      0.00000000000000E+00   3.84829448899537E-14   0.00000000000000E+00  -1.39410353131556E-15  -4.63601007936358E-23
     -3.84944386259627E-11  -3.84958327295404E-11  -1.28764397938382E-18  -2.43823909727601E-02  -2.43823909729153E-02
      0.00000000000000E+00   0.00000000000000E+00   1.55236119617218E-10   0.00000000000000E+00   1.55236119617218E-10
      4.56621522011153E-18  -1.17877285656966E-01  -1.17840505737670E-01   0.00000000000000E+00  -7.86224400423226E-13
     -1.05451830451370E-22  -1.15954062487148E-10  -1.16740286887677E-10  -3.27857124072771E-18
      8.76389104328084E-07
      0.00000000000000E+00   1.60728290113172E-14   0.00000000000000E+00   5.56222437638462E-16  -4.64172112568571E-23
     -1.61087987056745E-11  -1.61082424832833E-11  -1.30637290649278E-18  -1.59140347836189E-02  -1.59140347837280E-02
      0.00000000000000E+00   0.00000000000000E+00   1.09125548544468E-10   0.00000000000000E+00   1.09125548544468E-10
      4.67534076865600E-18  -1.32384985366085E-01  -1.32355679752323E-01   0.00000000000000E+00  -5.55858446102470E-13
     -1.07152563217430E-22  -9.24614476149757E-11  -9.30173060611853E-11  -3.36896786216322E-18
      8.77739104328084E-07
      0.00000000000000E+00  -2.11242895577312E-15   0.00000000000000E+00   1.01410459376598E-15  -4.62742723077490E-23
      2.16785988267533E-12   2.16887398722282E-12  -1.31670318551205E-18  -1.16100260891659E-02  -1.16100260892447E-02
      0.00000000000000E+00   0.00000000000000E+00   7.88849513679718E-11   0.00000000000000E+00   7.88849513679718E-11
      4.78183545300276E-18  -1.51711528878448E-01  -1.51685992610160E-01   0.00000000000000E+00  -4.31116890748160E-13
     -1.08853560735852E-22  -8.06227084643358E-11  -8.10538253551928E-11  -3.46513226749071E-18
      8.79561604328084E-07
      0.00000000000000E+00  -1.79097237554677E-14   0.00000000000000E+00   9.24648727967090E-16  -4.57712566236911E-23
      1.79098557598695E-11   1.79107804085517E-11  -1.32068217898476E-18  -9.64046385571546E-03  -9.64046385577464E-03
      0.00000000000000E+00   0.00000000000000E+00   5.91822800294845E-11   0.00000000000000E+00   5.91822800294845E-11
      4.88969515835650E-18  -1.77316664293872E-01  -1.77292376047200E-01   0.00000000000000E+00  -4.06317721296480E-13
     -1.10933054390101E-22  -7.66867427166296E-11  -7.70930604380371E-11  -3.56901297937174E-18
      8.81561604328084E-07
      0.00000000000000E+00  -3.07679869645215E-14   0.00000000000000E+00   7.23331886412616E-16  -4.45512922587987E-23
      3.07376273494721E-11   3.07383506813139E-11  -1.32042242724271E-18  -8.77862619403156E-03  -8.77862619407869E-03
      0.00000000000000E+00   0.00000000000000E+00   4.71312538383415E-11   0.00000000000000E+00   4.71312538383415E-11
      4.98395766603318E-18  -2.04834334683070E-01  -2.04809801965882E-01   0.00000000000000E+00  -4.21149101842550E-13
     -1.13210881496505E-22  -7.74484554176988E-11  -7.78696045196546E-11  -3.66353523879047E-18
      8.83561604328085E-07
      0.00000000000000E+00  -4.13301317433870E-14   0.00000000000000E+00   5.60028993230650E-16  -4.21297806017890E-23
      4.13333784703096E-11   4.13339384992607E-11  -1.31824394684674E-18  -8.32680736586071E-03  -8.32680736590019E-03
      0.00000000000000E+00   0.00000000000000E+00   3.94769756229247E-11   0.00000000000000E+00   3.94769756229247E-11
      5.06291161727903E-18  -2.31783506736030E-01  -2.31758047561256E-01   0.00000000000000E+00  -4.42304375387892E-13
     -1.15525104673530E-22  -8.03686097466827E-11  -8.08109141221861E-11  -3.74466767043230E-18
      8.85561604328085E-07
      0.00000000000000E+00  -5.06064502013472E-14   0.00000000000000E+00   4.47954956968095E-16  -3.79073560205863E-23
      5.06198816299512E-11   5.06203295848703E-11  -1.31530468599149E-18  -8.03705646553088E-03  -8.03705646556514E-03
      0.00000000000000E+00   0.00000000000000E+00   3.42665109562462E-11   0.00000000000000E+00   3.42665109562462E-11
      5.13144463919152E-18  -2.58179051764731E-01  -2.58152308707303E-01   0.00000000000000E+00  -4.61701277305025E-13
     -1.17871495391699E-22  -8.44251392636931E-11  -8.48868405411160E-11  -3.81613995320003E-18
      8.87561604328085E-07
      0.00000000000000E+00  -5.90561660244397E-14   0.00000000000000E+00   3.74212755585794E-16  -3.12704961240621E-23
      5.90657598106395E-11   5.90661340233638E-11  -1.31214460855687E-18  -7.82986179643300E-03  -7.82986179646357E-03
      0.00000000000000E+00   0.00000000000000E+00   3.05652304876931E-11   0.00000000000000E+00   3.05652304876931E-11
      5.19257510016691E-18  -2.84032531507577E-01  -2.84004293964886E-01   0.00000000000000E+00  -4.79167953193936E-13
     -1.20242990508594E-22  -8.91521965577426E-11  -8.96313645110568E-11  -3.88043049161004E-18
      8.89561604328085E-07
      0.00000000000000E+00  -6.69548134242870E-14   0.00000000000000E+00   3.25736569479942E-16  -2.17097188855646E-23
      6.69449784015267E-11   6.69453041380745E-11  -1.30901764943036E-18  -7.67269662830413E-03  -7.67269662833197E-03
      0.00000000000000E+00   0.00000000000000E+00   2.78330909961768E-11   0.00000000000000E+00   2.78330909961768E-11
      5.24824128215926E-18  -3.09348949411429E-01  -3.09319090611637E-01   0.00000000000000E+00  -4.95962029728484E-13
     -1.22636999399250E-22  -9.42824331044003E-11  -9.47783951342514E-11  -3.93922363272890E-18
      8.91561604328085E-07
      0.00000000000000E+00  -7.44860818753042E-14   0.00000000000000E+00   2.93585264763693E-16  -9.00308165799506E-24
      7.44417983184917E-11   7.44420919037475E-11  -1.30603466080427E-18  -7.54867260809806E-03  -7.54867260812379E-03
      0.00000000000000E+00   0.00000000000000E+00   2.57318272534666E-11   0.00000000000000E+00   2.57318272534666E-11
      5.29970493666620E-18  -3.34133155160199E-01  -3.34101596852534E-01   0.00000000000000E+00  -5.13555328295475E-13
     -1.25056814691175E-22  -9.96603638287943E-11  -1.00173919157215E-10  -3.99367027586193E-18
      8.93561604328085E-07
      0.00000000000000E+00  -8.16499713774913E-14   0.00000000000000E+00   2.71875060969526E-16   6.49506130544226E-24
      8.16820227662934E-11   8.16822946413608E-11  -1.30323426785517E-18  -7.44783810723545E-03  -7.44783810725949E-03
      0.00000000000000E+00   0.00000000000000E+00   2.40413240246731E-11   0.00000000000000E+00   2.40413240246731E-11
      5.34778758471554E-18  -3.58391540725012E-01  -3.58358234374202E-01   0.00000000000000E+00  -5.33173785828722E-13
     -1.27509886948721E-22  -1.05190444880077E-10  -1.05723618666033E-10  -4.04455331686037E-18
      8.95561604328085E-07
      0.00000000000000E+00  -8.88138608796784E-14   0.00000000000000E+00   2.61024532022815E-16   2.32941335434607E-23
      8.88282637613718E-11   8.88285247859271E-11  -1.30056927186080E-18  -7.38890005055539E-03  -7.38890005057794E-03
      0.00000000000000E+00   0.00000000000000E+00   2.25563591767914E-11   0.00000000000000E+00   2.25563591767914E-11
      5.39290030306913E-18  -3.82112326190166E-01  -3.82077236688840E-01   0.00000000000000E+00  -5.54370603052257E-13
     -1.29999893472110E-22  -1.10830513359537E-10  -1.11384883962719E-10  -4.09233103120833E-18
      8.97561604328085E-07
      0.00000000000000E+00  -9.58859056446579E-14   0.00000000000000E+00   2.51119896934310E-16   4.02553119531114E-23
      9.58721865692498E-11   9.58724376891870E-11  -1.29805883086966E-18  -7.34855401262468E-03  -7.34855401264604E-03
      0.00000000000000E+00   0.00000000000000E+00   2.13517748351675E-11   0.00000000000000E+00   2.13517748351675E-11
      5.43560385273946E-18  -4.05405946099798E-01  -4.05369017392652E-01   0.00000000000000E+00  -5.82808898790561E-13
     -1.32553287641851E-22  -1.16641403625432E-10  -1.17224212524355E-10  -4.13754502186980E-18
      8.99561604328085E-07
      0.00000000000000E+00  -1.02866105672430E-13   0.00000000000000E+00   2.43771930693599E-16   5.64669516814735E-23
      1.02856948401199E-10   1.02857192173186E-10  -1.29569467374186E-18  -7.31880588447191E-03  -7.31880588449224E-03
      0.00000000000000E+00   0.00000000000000E+00   2.03206035406265E-11   0.00000000000000E+00   2.03206035406265E-11
      5.47624505982071E-18  -4.28349789131033E-01  -4.28310985272347E-01   0.00000000000000E+00  -6.17722868737558E-13
     -1.35188323352013E-22  -1.22560072844939E-10  -1.23177795713812E-10  -4.18055038607885E-18
      9.01561604328085E-07
      0.00000000000000E+00  -1.09754460962994E-13   0.00000000000000E+00   2.37533339815220E-16   7.11936574927063E-23
      1.09782031449911E-10   1.09782268983322E-10  -1.29346361029436E-18  -7.29969335258071E-03  -7.29969335260002E-03
      0.00000000000000E+00   0.00000000000000E+00   1.93037850614784E-11   0.00000000000000E+00   1.93037850614784E-11
      5.51485262994367E-18  -4.50869958617149E-01  -4.50829293941870E-01   0.00000000000000E+00  -6.53651440831750E-13
     -1.37895382833391E-22  -1.28432402603830E-10  -1.29086054044799E-10  -4.22138901964930E-18
      9.02561604328085E-07
      0.00000000000000E+00  -1.13244560976880E-13   0.00000000000000E+00   2.35876579910173E-16   7.82366128565513E-23
      1.13258382262591E-10   1.13258618139249E-10  -1.29238100187694E-18  -7.29307273073429E-03  -7.29307273075305E-03
      0.00000000000000E+00   0.00000000000000E+00   1.87532636663219E-11   0.00000000000000E+00   1.87532636663219E-11
      5.53360589360999E-18  -4.62017165401416E-01  -4.61975579250413E-01   0.00000000000000E+00  -6.81529275571163E-13
     -1.39272094124930E-22  -1.31330352529863E-10  -1.32011881805574E-10  -4.24122489173305E-18
      9.03911604328085E-07
      0.00000000000000E+00  -1.17928642574464E-13   0.00000000000000E+00   2.32081175881734E-16   8.66718171874812E-23
      1.17910576432090E-10   1.17910808513352E-10  -1.29096943997535E-18  -7.29061833239886E-03  -7.29061833241695E-03
      0.00000000000000E+00   0.00000000000000E+00   1.80864016196321E-11   0.00000000000000E+00   1.80864016196321E-11
      5.55802253579649E-18  -4.76860370392642E-01  -4.76817529111337E-01   0.00000000000000E+00  -7.05430890453356E-13
     -1.41156880894958E-22  -1.35291779242389E-10  -1.35997210132983E-10  -4.26705309582115E-18
      9.05734104328085E-07
      0.00000000000000E+00  -1.24174084704576E-13   0.00000000000000E+00   2.28437461281856E-16   9.62331773616649E-23
      1.24138784483960E-10   1.24139012921518E-10  -1.28913516773300E-18  -7.30250028286723E-03  -7.30250028288446E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72338640997236E-11   0.00000000000000E+00   1.72338640997236E-11
      5.58943125311824E-18  -4.96527649000519E-01  -4.96483114766010E-01   0.00000000000000E+00  -7.37906278661747E-13
     -1.43738195923508E-22  -1.40634970742436E-10  -1.41372877021241E-10  -4.30029608538524E-18
      9.07734104328085E-07
      0.00000000000000E+00  -1.30970595257933E-13   0.00000000000000E+00   2.27196977996716E-16   1.04843358861836E-22
      1.30975559790713E-10   1.30975786987795E-10  -1.28717681061076E-18  -7.34226146228129E-03  -7.34226146229762E-03
      0.00000000000000E+00   0.00000000000000E+00   1.63260952239876E-11   0.00000000000000E+00   1.63260952239876E-11
      5.62208344356622E-18  -5.17671195768239E-01  -5.17624794379055E-01   0.00000000000000E+00  -7.76633032622263E-13
     -1.46600283535975E-22  -1.46525249179014E-10  -1.47301882211783E-10  -4.33490663295546E-18
      9.09734104328085E-07
      0.00000000000000E+00  -1.38134484760120E-13   0.00000000000000E+00   2.41058369067368E-16   1.12063505096815E-22
      1.38162291711670E-10   1.38162532770151E-10  -1.28511671379654E-18  -7.47573390625407E-03  -7.47573390626941E-03
      0.00000000000000E+00   0.00000000000000E+00   1.53469570986051E-11   0.00000000000000E+00   1.53469570986051E-11
      5.65277735776343E-18  -5.38384105883220E-01  -5.38335749651043E-01   0.00000000000000E+00  -8.13497515849390E-13
     -1.49461758812534E-22  -1.52695992352758E-10  -1.53509489868757E-10  -4.36766064396688E-18
      9.11734104328085E-07
      0.00000000000000E+00  -1.46492355846005E-13   0.00000000000000E+00   2.90993522551304E-16   1.18663990477114E-22
      1.46528823401606E-10   1.46529114395247E-10  -1.28258338547729E-18  -7.86550377600936E-03  -7.86550377602349E-03
      0.00000000000000E+00   0.00000000000000E+00   1.41312584284657E-11   0.00000000000000E+00   1.41312584284657E-11
      5.68103987462036E-18  -5.58674085341327E-01  -5.58623477216527E-01   0.00000000000000E+00  -8.40481487600428E-13
     -1.52276400664556E-22  -1.59819891335960E-10  -1.60660372823713E-10  -4.39845648914307E-18
      9.13734104328085E-07
      0.00000000000000E+00  -1.60360911164342E-13   0.00000000000000E+00   5.16274995345151E-16   1.27368232072197E-22
      1.60385153193345E-10   1.60385669468467E-10  -1.27785223296066E-18  -9.29284100760030E-03  -9.29284100761187E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15668414572055E-11   0.00000000000000E+00   1.15668414572055E-11
      5.70417355753477E-18  -5.78542420939718E-01  -5.78488256559162E-01   0.00000000000000E+00  -8.24414330715211E-13
     -1.54905514117642E-22  -1.71128096594802E-10  -1.71952510925672E-10  -4.42632132457411E-18
      9.15734104328085E-07
      0.00000000000000E+00  -2.25019606158441E-13   0.00000000000000E+00   2.45598736121699E-15   1.62015198133682E-22
      2.25004732096077E-10   2.25007188083600E-10  -1.25582353992458E-18  -1.85998139864581E-02  -1.85998139864547E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.40760168177290E-12   0.00000000000000E+00  -3.40760168177290E-12
      5.69735835417123E-18  -5.97923901897649E-01  -5.97854100110900E-01   0.00000000000000E+00  -4.52600338165161E-13
     -1.56294155633344E-22  -2.21146986063506E-10  -2.21599586401827E-10  -4.44153481424664E-18
      9.17734104328085E-07
      0.00000000000000E+00  -5.00370128306606E-13   0.00000000000000E+00   8.99213128171066E-15   2.58804999939811E-22
      5.00318267316826E-10   5.00327259448367E-10  -1.19126193396609E-18  -4.59623221123793E-02  -4.59623221123393E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.99647570754955E-11   0.00000000000000E+00  -3.99647570754955E-11
      5.61742884002023E-18  -6.16462219896108E-01  -6.16317210769124E-01   0.00000000000000E+00   4.32447622924612E-13
     -1.54956923126876E-22  -4.60794949995641E-10  -4.60362502372871E-10  -4.42616690605414E-18
      9.19734104328085E-07
      0.00000000000000E+00  -1.06585817529335E-12   0.00000000000000E+00   1.59300764242380E-14   3.29898467610493E-22
      1.06582904350776E-09   1.06584497358451E-09  -1.11692395485467E-18  -7.57525807043661E-02  -7.57525807043128E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.32951816919741E-11   0.00000000000000E+00  -5.32951816919741E-11
      5.51083847663629E-18  -6.33567224693645E-01  -6.33248279732347E-01   0.00000000000000E+00   4.93040007161233E-13
     -1.53387613954371E-22  -1.01304283189954E-09  -1.01254979189254E-09  -4.39391452178162E-18
      9.21734104328085E-07
      0.00000000000000E+00  -2.13823732692843E-12   0.00000000000000E+00   2.81189631476932E-14   3.74378369565792E-22
      2.13823267882117E-09   2.13826079778469E-09  -1.04444884803303E-18  -1.05233629163617E-01  -1.05233629163554E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.31653258550705E-11   0.00000000000000E+00  -6.31653258550705E-11
      5.38450782492614E-18  -6.48278356551850E-01  -6.47624713368403E-01   0.00000000000000E+00   4.14409706084047E-13
     -1.52010437977014E-22  -2.07550988163555E-09  -2.07509547192962E-09  -4.34005897689311E-18
      9.22734104328085E-07
      0.00000000000000E+00  -2.96961588813096E-12   0.00000000000000E+00   4.25099221189162E-14   4.00700908378014E-22
      2.96952909585392E-09   2.96957160577644E-09  -1.00978869699277E-18  -1.19859073589358E-01  -1.19859073589289E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.97355516448618E-11   0.00000000000000E+00  -6.97355516448618E-11
      5.31477227328128E-18  -6.54754136937092E-01  -6.53840702281259E-01   0.00000000000000E+00   3.48444325715428E-13
     -1.51406283297214E-22  -2.90018449845715E-09  -2.89983605413158E-09  -4.30498357628851E-18
      9.24084104328085E-07
      0.00000000000000E+00  -4.46356238354859E-12   0.00000000000000E+00   5.59600864362256E-14   4.25579991928946E-22
      4.46347990649098E-09   4.46353586657784E-09  -9.66529331522310E-19  -1.39354626746540E-01  -1.39354626746461E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.92230029957674E-11   0.00000000000000E+00  -7.92230029957674E-11
      5.20782121923699E-18  -6.61426489607167E-01  -6.60045446804779E-01   0.00000000000000E+00   2.72555658168293E-13
     -1.50738279887738E-22  -4.38458541924009E-09  -4.38431286358207E-09  -4.24129188771468E-18
      9.25906604328085E-07
      0.00000000000000E+00  -7.24342704460880E-12   0.00000000000000E+00   7.58752546099066E-14   4.44713006320478E-22
      7.24333560377933E-09   7.24341147903438E-09  -9.13974514994367E-19  -1.65191905584288E-01  -1.65191905584194E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.31990705449170E-11   0.00000000000000E+00  -9.31990705449170E-11
      5.03796591316888E-18  -6.65381288783107E-01  -6.63128987615041E-01   0.00000000000000E+00   2.17101835028725E-13
     -1.49970633413856E-22  -7.15042951032435E-09  -7.15021240848947E-09  -4.12399139817452E-18
      9.27906604328085E-07
      0.00000000000000E+00  -1.14467932876485E-11   0.00000000000000E+00   1.04764510705255E-13   4.55963572569226E-22
      1.14466423602330E-08   1.14467471247441E-08  -8.61799653534147E-19  -1.92961100073828E-01  -1.92961100073719E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08628966365376E-10   0.00000000000000E+00  -1.08628966365376E-10
      4.82070798043813E-18  -6.61520781215207E-01  -6.57949277098903E-01   0.00000000000000E+00   2.84961582280399E-13
     -1.48839419840289E-22  -1.13384031199609E-08  -1.13381181583788E-08  -3.95890832690398E-18
      9.29906604328085E-07
      0.00000000000000E+00  -1.70458321572937E-11   0.00000000000000E+00   1.39124392902238E-13   4.57262427242205E-22
      1.70456910495942E-08   1.70458301739875E-08  -8.13229953636519E-19  -2.20155419768296E-01  -2.20155419768174E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21930459932083E-10   0.00000000000000E+00  -1.21930459932083E-10
      4.57684706057396E-18  -6.46908448633155E-01  -6.41577365432562E-01   0.00000000000000E+00   5.76916011252541E-13
     -1.46594210579943E-22  -1.69244766300666E-08  -1.69238997140554E-08  -3.76361710693744E-18
      9.31906604328085E-07
      0.00000000000000E+00  -2.43088221309277E-11   0.00000000000000E+00   1.80242315194625E-13   4.47736075564925E-22
      2.43086207479046E-08   2.43088009902203E-08  -7.66601397767338E-19  -2.46789659945454E-01  -2.46789659945322E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.31967362098197E-10   0.00000000000000E+00  -1.31967362098197E-10
      4.31291233637757E-18  -6.18516106700859E-01  -6.10900173478735E-01   0.00000000000000E+00   1.10511049027389E-12
     -1.42178755754422E-22  -2.41779387386122E-08  -2.41768336281221E-08  -3.54631093861024E-18
      9.33906604328085E-07
      0.00000000000000E+00  -3.35495966755886E-11   0.00000000000000E+00   2.29269024248104E-13   4.27127361864317E-22
      3.35493837741370E-08   3.35496130431617E-08  -7.20806077951739E-19  -2.72877435368772E-01  -2.72877435368632E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.39826346407711E-10   0.00000000000000E+00  -1.39826346407711E-10
      4.03325964356215E-18  -5.72757160896229E-01  -5.62232434684137E-01   0.00000000000000E+00   1.72057243431725E-12
     -1.34686850096490E-22  -3.34115072691882E-08  -3.34097866967540E-08  -3.31245356561041E-18
      9.35906604328085E-07
      0.00000000000000E+00  -4.48306102125775E-11   0.00000000000000E+00   2.80062230777344E-13   3.90220037481338E-22
      4.48302987678408E-08   4.48305788300720E-08  -6.75401375440894E-19  -2.98426723910597E-01  -2.98426723910449E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48580445672920E-10   0.00000000000000E+00  -1.48580445672920E-10
      3.73609875221631E-18  -5.05970431282920E-01  -4.91894197859719E-01   0.00000000000000E+00   2.10778268191714E-12
     -1.24260789738378E-22  -4.46841061670808E-08  -4.46819983843990E-08  -3.06069737677542E-18
      9.37906604328085E-07
      0.00000000000000E+00  -5.74656907102170E-11   0.00000000000000E+00   3.14119877494931E-13   3.23779334674461E-22
      5.74653861701922E-08   5.74657002900700E-08  -6.30483774210349E-19  -3.23440703414505E-01  -3.23440703414344E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.60794589329835E-10   0.00000000000000E+00  -1.60794589329835E-10
      3.41450957355664E-18  -4.15839849260445E-01  -3.97786307033174E-01   0.00000000000000E+00   2.05198542470940E-12
     -1.12599099043145E-22  -5.73069576861648E-08  -5.73049057007402E-08  -2.78402579934629E-18
      9.39906604328086E-07
      0.00000000000000E+00  -6.98932939465046E-11   0.00000000000000E+00   3.09557110757692E-13   2.52065425240444E-22
      6.98929616502074E-08   6.98932712073184E-08  -5.86066248651675E-19  -3.47927985884680E-01  -3.47927985884506E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.73776779087305E-10   0.00000000000000E+00  -1.73776779087305E-10
      3.06695601538203E-18  -3.03144061141966E-01  -2.81178616208014E-01   0.00000000000000E+00   1.75117603633510E-12
     -9.95612918814566E-23  -6.97212456042673E-08  -6.97194944282311E-08  -2.48088976673035E-18
      9.41906604328086E-07
      0.00000000000000E+00  -7.77315075092694E-11   0.00000000000000E+00   1.95741343044248E-13   1.77677445571248E-22
      7.77313297987673E-08   7.77315255401105E-08  -5.42679389554850E-19  -3.71881932663689E-01  -3.71881932663494E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.95289284908132E-10   0.00000000000000E+00  -1.95289284908132E-10
      2.67637744556577E-18  -1.77323025671278E-01  -1.52894264061209E-01   0.00000000000000E+00   1.16080647857471E-12
     -8.50381020626754E-23  -7.75373970616808E-08  -7.75362362552023E-08  -2.13369805601092E-18
      9.43906604328086E-07
      0.00000000000000E+00  -6.88984317530727E-11   0.00000000000000E+00  -2.19508001685523E-13   6.37581438797769E-23
      6.88986420288457E-08   6.88984225208440E-08  -4.97957181605392E-19  -3.95334422507475E-01  -3.95334422507270E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.05751170890713E-10   0.00000000000000E+00  -2.05751170890713E-10
      2.26487510378434E-18  -7.11422388828057E-02  -4.94994935346977E-02   0.00000000000000E+00   8.18879285309868E-13
     -5.40590728271380E-23  -6.86934902292386E-08  -6.86926713499533E-08  -1.76691792217895E-18
      9.45906604328086E-07
      0.00000000000000E+00  -3.79256310245784E-11   0.00000000000000E+00  -7.68172876239475E-13   1.80631549098174E-23
      3.79263752054623E-08   3.79256070325861E-08  -4.41801805907887E-19  -4.18440054608367E-01  -4.18440054608225E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42185723912557E-10   0.00000000000000E+00  -1.42185723912557E-10
      1.98050365595923E-18  -2.73676348196789E-02  -1.54633084442014E-02   0.00000000000000E+00   9.33341314770413E-13
     -1.81157667415024E-23  -3.77843546499883E-08  -3.77834213086736E-08  -1.53870185005134E-18
      9.47906604328086E-07
      0.00000000000000E+00  -2.26783943560197E-11   0.00000000000000E+00  -3.76544388632343E-13   7.61969848077302E-24
      2.26787421622343E-08   2.26783656178457E-08  -3.84612018129684E-19  -4.41150137027684E-01  -4.41150137027577E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06931375049936E-10   0.00000000000000E+00  -1.06931375049936E-10
      1.76664090585935E-18  -1.41361624240054E-02  -7.02462698275232E-03   0.00000000000000E+00   4.44178351997322E-13
     -8.34126457899037E-24  -2.25718784211477E-08  -2.25714342427958E-08  -1.38202888772967E-18
      9.48906604328086E-07
      0.00000000000000E+00  -1.89505083175034E-11   0.00000000000000E+00  -1.83676291135834E-13   5.60926479135588E-24
      1.89507365719283E-08   1.89505528956371E-08  -3.56747704287910E-19  -4.52395167250360E-01  -4.52395167250258E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01560199047418E-10   0.00000000000000E+00  -1.01560199047418E-10
      1.66508070681194E-18  -1.12503266984800E-02  -5.31160994871995E-03   0.00000000000000E+00   2.32907470460870E-13
     -6.33202967884902E-24  -1.88492256040602E-08  -1.88489926965897E-08  -1.30833300252403E-18
      9.50256604328086E-07
      0.00000000000000E+00  -1.72049072421372E-11   0.00000000000000E+00  -6.34459017693802E-14   4.49596471946724E-24
      1.72049623834926E-08   1.72048989375908E-08  -3.20359580572773E-19  -4.67370824488255E-01  -4.67370824488155E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.97653709611078E-11   0.00000000000000E+00  -9.97653709611078E-11
      1.53039745601444E-18  -9.70864282145727E-03  -4.31935719441283E-03   0.00000000000000E+00   1.04857496710282E-13
     -5.04527310056493E-24  -1.71052384241264E-08  -1.71051335666297E-08  -1.21003787544167E-18
      9.52079104328086E-07
      0.00000000000000E+00  -1.65280115289177E-11   0.00000000000000E+00  -1.79822749874141E-14   3.77161522687219E-24
      1.65279735363229E-08   1.65279555540480E-08  -2.73215556538993E-19  -4.87214504215281E-01  -4.87214504215181E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00872415349764E-10   0.00000000000000E+00  -1.00872415349764E-10
      1.34655747903950E-18  -8.85725170523945E-03  -3.68159471223227E-03   0.00000000000000E+00   5.38677331347470E-14
     -4.17213256500694E-24  -1.64271370064313E-08  -1.64270831386982E-08  -1.07334192250050E-18
      9.54079104328086E-07
      0.00000000000000E+00  -1.63004202701174E-11   0.00000000000000E+00  -5.30104117002359E-15   3.29909528729962E-24
      1.63004328990577E-08   1.63004275980166E-08  -2.23882415520781E-19  -5.08547721583351E-01  -5.08547721583248E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03193386657694E-10   0.00000000000000E+00  -1.03193386657694E-10
      1.14017070572411E-18  -8.37607287118813E-03  -3.27283075206462E-03   0.00000000000000E+00   3.67632796386271E-14
     -3.58618708326547E-24  -1.61972709746385E-08  -1.61972342113589E-08  -9.16288290203328E-19
      9.56079104328086E-07
      0.00000000000000E+00  -1.62118819434494E-11   0.00000000000000E+00  -1.90249908230941E-15   2.97594025800004E-24
      1.62119022528683E-08   1.62119003503692E-08  -1.76927263126884E-19  -5.29446525718317E-01  -5.29446525718212E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05404060012694E-10   0.00000000000000E+00  -1.05404060012694E-10
      9.29362585698720E-19  -8.07148787197004E-03  -2.99683160101308E-03   0.00000000000000E+00   2.98574579762813E-14
     -3.17462667107965E-24  -1.61065261478145E-08  -1.61064962903565E-08  -7.52435322571835E-19
      9.58079104328085E-07
      0.00000000000000E+00  -1.61675209353781E-11   0.00000000000000E+00  -8.38131342665997E-16   2.73692425895468E-24
      1.61675637951615E-08   1.61675629570301E-08  -1.32217781520511E-19  -5.49919327677462E-01  -5.49919327677355E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07064979618635E-10   0.00000000000000E+00  -1.07064979618635E-10
      7.15232626461450E-19  -7.85546123728079E-03  -2.79529564836497E-03   0.00000000000000E+00   2.59874755677256E-14
     -2.86506848955479E-24  -1.60605239648870E-08  -1.60604979774115E-08  -5.83014844940939E-19
      9.60079104328085E-07
      0.00000000000000E+00  -1.61408859615880E-11   0.00000000000000E+00  -4.23949591931392E-16   2.55161553240515E-24
      1.61408889223077E-08   1.61408884983581E-08  -8.95973512678540E-20  -5.69971736932042E-01  -5.69971736931933E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08160903979065E-10   0.00000000000000E+00  -1.08160903979065E-10
      4.98910818503319E-19  -7.69253779776358E-03  -2.64111993498464E-03   0.00000000000000E+00   2.32882894736321E-14
     -2.62359281659359E-24  -1.60327508826685E-08  -1.60327275943790E-08  -4.09313467235464E-19
      9.62079104328085E-07
      0.00000000000000E+00  -1.61229762378325E-11   0.00000000000000E+00  -2.26217598124463E-16   2.40334546847444E-24
      1.61229790060858E-08   1.61229787798682E-08  -4.89451355518270E-20  -5.89587394196997E-01  -5.89587394196888E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08624532866352E-10   0.00000000000000E+00  -1.08624532866352E-10
      2.81661752770614E-19  -7.56456529984954E-03  -2.51893462777816E-03   0.00000000000000E+00   2.11825866785386E-14
     -2.43029957754304E-24  -1.60143754295885E-08  -1.60143542470019E-08  -2.32716617218788E-19
      9.64079104328085E-07
      0.00000000000000E+00  -1.61088321483025E-11   0.00000000000000E+00  -3.65089822620697E-15   2.28268576197112E-24
      1.61088346593853E-08   1.61088310084870E-08  -1.05506202908438E-20  -6.08545695916460E-01  -6.08545695916353E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07349163980480E-10   0.00000000000000E+00  -1.07349163980480E-10
      6.69634248096542E-20  -7.46092560713356E-03  -2.41934815240151E-03   0.00000000000000E+00   2.27418382711512E-14
     -2.27365016510601E-24  -1.60015045863448E-08  -1.60014818445066E-08  -5.64128045188100E-20
      9.66079104328085E-07
      0.00000000000000E+00  -1.60839422245193E-11   0.00000000000000E+00  -4.35301240604037E-16   2.19458840602753E-24
      1.60839850030197E-08   1.60839845677185E-08   2.48065998933646E-20  -6.26357344356531E-01  -6.26357344356428E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02683554091856E-10   0.00000000000000E+00  -1.02683554091856E-10
     -1.38403683374057E-19  -7.39593729823164E-03  -2.36071818566318E-03   0.00000000000000E+00   1.73833477607950E-14
     -2.16125395083780E-24  -1.59813183969744E-08  -1.59813010136266E-08   1.13597083480694E-19
      9.68079104328085E-07
      0.00000000000000E+00  -1.60621750218011E-11   0.00000000000000E+00  -3.86392243489899E-16   2.12781103103704E-24
      1.60621364989511E-08   1.60621361125589E-08   5.58033389590144E-20  -6.42244241493046E-01  -6.42244241492953E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.29600270806572E-11   0.00000000000000E+00  -9.29600270806572E-11
     -3.24323737535372E-19  -7.35354317716763E-03  -2.32214330979235E-03   0.00000000000000E+00   1.47505352645643E-14
     -2.07721232067998E-24  -1.59691908360135E-08  -1.59691760854782E-08   2.68520398576358E-19
      9.70079104328085E-07
      0.00000000000000E+00  -1.60382035453899E-11   0.00000000000000E+00  -4.72484704202509E-16   2.07765179255013E-24
      1.60381807699327E-08   1.60381802974480E-08   8.02787464099694E-20  -6.54962710596445E-01  -6.54962710596370E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.52898962440677E-11   0.00000000000000E+00  -7.52898962440677E-11
     -4.74903530023507E-19  -7.32226675809137E-03  -2.29284658392136E-03   0.00000000000000E+00   1.13657429384439E-14
     -2.01549442321518E-24  -1.59629017669468E-08  -1.59628904012039E-08   3.94624783613537E-19
      9.72079104328085E-07
      0.00000000000000E+00  -1.60034862347255E-11   0.00000000000000E+00  -7.85254362897681E-16   2.04610399159187E-24
      1.60034622710748E-08   1.60034614858204E-08   9.51750714820624E-20  -6.62775097602391E-01  -6.62775097602344E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.66114627337171E-11   0.00000000000000E+00  -4.66114627337171E-11
     -5.68126455490941E-19  -7.30145045491069E-03  -2.27393297710021E-03   0.00000000000000E+00   6.89129546551283E-15
     -1.97925626433575E-24  -1.59568569143822E-08  -1.59568500230867E-08   4.72951384008878E-19
      9.74079104328085E-07
      0.00000000000000E+00  -1.59545329897939E-11   0.00000000000000E+00  -1.20044279870014E-15   2.03735097361529E-24
      1.59545352632999E-08   1.59545340628571E-08   9.67001503100119E-20  -6.63575408198102E-01  -6.63575408198097E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.81140083828700E-12   0.00000000000000E+00  -4.81140083828700E-12
     -5.77749257167515E-19  -7.29306461924371E-03  -2.26779270455138E-03   0.00000000000000E+00   8.64681749643861E-16
     -1.97441854286947E-24  -1.59497235267006E-08  -1.59497226620188E-08   4.81049106857503E-19
      9.76079104328085E-07
      0.00000000000000E+00  -1.58892313816393E-11   0.00000000000000E+00  -1.68940190027061E-15   2.05872441071503E-24
      1.58892418196964E-08   1.58892401302945E-08   8.03316589889004E-20  -6.54981976562748E-01  -6.54981976562799E-01
      0.00000000000000E+00   0.00000000000000E+00   5.12365844256124E-11   0.00000000000000E+00   5.12365844256124E-11
     -4.75276088316290E-19  -7.30108452842256E-03  -2.27872620161300E-03   0.00000000000000E+00  -7.17357251601676E-15
     -2.01158361813208E-24  -1.59404695411476E-08  -1.59404767147201E-08   3.94944429327390E-19
      9.78079104328085E-07
      0.00000000000000E+00  -1.58048260681456E-11   0.00000000000000E+00  -2.62856541123698E-15   2.12431997025029E-24
      1.58048619092871E-08   1.58048592807217E-08   4.02811000612940E-20  -6.34242035382969E-01  -6.34242035383091E-01
      0.00000000000000E+00   0.00000000000000E+00   1.22327960805302E-10   0.00000000000000E+00   1.22327960805302E-10
     -2.30620166705687E-19  -7.33318213181213E-03  -2.31501199023834E-03   0.00000000000000E+00  -1.77502178481407E-14
     -2.11229389295546E-24  -1.59271694913092E-08  -1.59271872415270E-08   1.90339066644394E-19
      9.80079104328085E-07
      0.00000000000000E+00  -1.56833154808201E-11   0.00000000000000E+00  -3.36644646901606E-15   2.27877656896217E-24
      1.56833273270650E-08   1.56833239606185E-08  -3.16378006424406E-20  -5.98057899106769E-01  -5.98057899106977E-01
      0.00000000000000E+00   0.00000000000000E+00   2.08240121773742E-10   0.00000000000000E+00   2.08240121773742E-10
      1.85860076841797E-19  -7.43263235731145E-03  -2.42568841355829E-03   0.00000000000000E+00  -3.35619299212593E-14
     -2.34767199875934E-24  -1.58915305204623E-08  -1.58915640823923E-08  -1.54222276199358E-19
      9.82079104328085E-07
      0.00000000000000E+00  -1.54812570589635E-11   0.00000000000000E+00  -3.19467548064769E-13   2.65979251822912E-24
      1.54812806387095E-08   1.54809611711614E-08  -1.47767145082505E-19  -5.42696976968811E-01  -5.42696976969114E-01
      0.00000000000000E+00   0.00000000000000E+00   3.02511737730267E-10   0.00000000000000E+00   3.02511737730267E-10
      7.90883552302330E-19  -7.73921532947407E-03  -2.76623339493207E-03   0.00000000000000E+00   2.56124276845351E-13
     -2.96494320326975E-24  -1.57837290331685E-08  -1.57834729088917E-08  -6.43116407219825E-19
      9.84079104328085E-07
      0.00000000000000E+00  -1.50441679545929E-11   0.00000000000000E+00  -1.19310401546889E-14   3.76363230676093E-24
      1.50441453927045E-08   1.50441334616643E-08  -3.25955698212633E-19  -4.64944288971762E-01  -4.64944288972142E-01
      0.00000000000000E+00   0.00000000000000E+00   3.79323230840958E-10   0.00000000000000E+00   3.79323230840958E-10
      1.54953001398425E-18  -8.74245572690723E-03  -3.88301330417382E-03   0.00000000000000E+00  -1.01781493322192E-13
     -5.01997306805916E-24  -1.54233549110120E-08  -1.54234566925053E-08  -1.22357431577162E-18
      9.86079104328085E-07
      0.00000000000000E+00  -1.25521446999411E-11   0.00000000000000E+00  -6.37391951214538E-14   6.05076279089813E-24
      1.25522042361578E-08   1.25521404969626E-08  -5.74944841067121E-19  -3.63655682525321E-01  -3.63655682525719E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98240638455022E-10   0.00000000000000E+00   3.98240638455022E-10
      2.34601129089429E-18  -1.45568451440677E-02  -1.04766123377836E-02   0.00000000000000E+00  -1.82381148353685E-13
     -2.18612504914837E-23  -1.29501987542693E-08  -1.29503811354177E-08  -1.77106644982717E-18
      9.88079104328085E-07
      0.00000000000000E+00  -2.79364137164134E-12   0.00000000000000E+00  -2.45690020110535E-13  -2.22559097975339E-23
      2.79390717784895E-09   2.79366148782881E-09  -8.42135423188304E-19  -2.42889144640737E-01  -2.42889144641146E-01
      0.00000000000000E+00   0.00000000000000E+00   4.08680304797374E-10   0.00000000000000E+00   4.08680304797374E-10
      3.16337190048904E-18  -3.92987246806443E-02  -3.82897854710964E-02   0.00000000000000E+00  -3.62391073700979E-13
     -7.86339979083401E-23  -3.20197940155241E-09  -3.20234179262619E-09  -2.32123647730073E-18
      9.90079104328085E-07
      0.00000000000000E+00  -1.95629290252032E-14   0.00000000000000E+00  -7.55094967070739E-14  -4.38569622119082E-23
      1.96177265876791E-11   1.95422170909282E-11  -1.09795408422743E-18  -1.18569205909305E-01  -1.18569205909678E-01
      0.00000000000000E+00   0.00000000000000E+00   3.72463941719174E-10   0.00000000000000E+00   3.72463941719174E-10
      3.90829978392739E-18  -6.90320183005483E-02  -6.89085127660837E-02   0.00000000000000E+00  -1.05388881869874E-12
     -9.31617437588933E-23  -3.90952269991309E-10  -3.92006158810101E-10  -2.81034569969995E-18
      9.92079104328084E-07
      0.00000000000000E+00   7.11796713358332E-14   0.00000000000000E+00  -7.76318532972304E-15  -4.60499073638255E-23
     -7.11937544943895E-11  -7.12015176797653E-11  -1.24674909317297E-18  -4.40645400673086E-02  -4.40645400675464E-02
      0.00000000000000E+00   0.00000000000000E+00   2.37755241062009E-10   0.00000000000000E+00   2.37755241062009E-10
      4.38381026605140E-18  -9.86052655026781E-02  -9.85527911333330E-02   0.00000000000000E+00  -1.12046789919852E-12
     -1.02387626717749E-22  -1.65433255482944E-10  -1.66553723382244E-10  -3.13706117287844E-18
      9.94079104328084E-07
      0.00000000000000E+00   2.46143895716172E-14   0.00000000000000E+00  -2.01335427416661E-16  -4.63946423719497E-23
     -2.46187217742844E-11  -2.46189231097582E-11  -1.29955377930448E-18  -1.90035447254903E-02  -1.90035447256171E-02
      0.00000000000000E+00   0.00000000000000E+00   1.26818590381345E-10   0.00000000000000E+00   1.26818590381345E-10
      4.63744744681410E-18  -1.27702095653794E-01  -1.27669896997654E-01   0.00000000000000E+00  -6.49206903246104E-13
     -1.06586477561370E-22  -1.01550460368235E-10  -1.02199667271587E-10  -3.33789366750961E-18
      9.94329104328084E-07
      0.00000000000000E+00   1.82771027042978E-14   0.00000000000000E+00   5.04375555047680E-16  -4.64145063234197E-23
     -1.82762220190938E-11  -1.82757176435851E-11  -1.30470412064780E-18  -1.66407076524668E-02  -1.66407076525802E-02
      0.00000000000000E+00   0.00000000000000E+00   1.13398322659563E-10   0.00000000000000E+00   1.13398322659563E-10
      4.66579702747899E-18  -1.31331291419345E-01  -1.31301322487961E-01   0.00000000000000E+00  -5.95069355165587E-13
     -1.07036398881452E-22  -9.45275356607137E-11  -9.51226050159864E-11  -3.36109290683119E-18
      9.94666604328084E-07
      0.00000000000000E+00   1.13887474137333E-14   0.00000000000000E+00   8.34956903026350E-16  -4.64127733319904E-23
     -1.13459424815567E-11  -1.13451075247000E-11  -1.30977039281957E-18  -1.44279805092088E-02  -1.44279805093089E-02
      0.00000000000000E+00   0.00000000000000E+00   1.00108487306032E-10   0.00000000000000E+00   1.00108487306032E-10
      4.69958364194477E-18  -1.36215439745429E-01  -1.36187474405838E-01   0.00000000000000E+00  -5.10110950775768E-13
     -1.07548993130812E-22  -8.82532688304430E-11  -8.87633797813263E-11  -3.38981324912521E-18
      9.95122229328084E-07
      0.00000000000000E+00   4.04116843713118E-15   0.00000000000000E+00   1.05479574799860E-15  -4.63752540228702E-23
     -3.99570900791819E-12  -3.99465421221657E-12  -1.31435176660742E-18  -1.25474272433006E-02  -1.25474272433879E-02
      0.00000000000000E+00   0.00000000000000E+00   8.73010191614710E-11   0.00000000000000E+00   8.73010191614710E-11
      4.73936016880022E-18  -1.42779855928982E-01  -1.42753609927376E-01   0.00000000000000E+00  -4.45952278739013E-13
     -1.08144760329501E-22  -8.28604126704090E-11  -8.33063649492561E-11  -3.42500840219280E-18
      9.95737323078084E-07
      0.00000000000000E+00  -3.67378948830107E-15   0.00000000000000E+00   1.12995118061627E-15  -4.62792721015379E-23
      3.67375550193270E-12   3.67488545306704E-12  -1.31807763200689E-18  -1.11014655286609E-02  -1.11014655287365E-02
      0.00000000000000E+00   0.00000000000000E+00   7.55892125296139E-11   0.00000000000000E+00   7.55892125296139E-11
      4.78585462099461E-18  -1.51586828451666E-01  -1.51561856057210E-01   0.00000000000000E+00  -4.07828265268121E-13
     -1.08869213997792E-22  -7.88562697173051E-11  -7.92640979826821E-11  -3.46777698898771E-18
      9.96567699640584E-07
      0.00000000000000E+00  -1.17561263625634E-14   0.00000000000000E+00   1.07248526011402E-15  -4.60774547677124E-23
      1.17508428848933E-11   1.17519153701074E-11  -1.32064263724367E-18  -1.00732175694464E-02  -1.00732175695115E-02
      0.00000000000000E+00   0.00000000000000E+00   6.51385439258362E-11   0.00000000000000E+00   6.51385439258362E-11
      4.83994414118600E-18  -1.63374285967453E-01  -1.63350061472393E-01   0.00000000000000E+00  -3.94870176623563E-13
     -1.09800465067721E-22  -7.64955891192102E-11  -7.68904592959436E-11  -3.51930150394232E-18
      9.97688707999959E-07
      0.00000000000000E+00  -2.04813763972785E-14   0.00000000000000E+00   9.23678704378788E-16  -4.56495028193758E-23
      2.04559402798377E-11   2.04568639584964E-11  -1.32177631413731E-18  -9.35291708795362E-03  -9.35291708800938E-03
      0.00000000000000E+00   0.00000000000000E+00   5.57554545001050E-11   0.00000000000000E+00   5.57554545001050E-11
      4.90244647176137E-18  -1.79101274663821E-01  -1.79077263912284E-01   0.00000000000000E+00  -4.00994199200739E-13
     -1.11051288643304E-22  -7.58113242592880E-11  -7.62123184585998E-11  -3.58067015762405E-18
      9.99202069285116E-07
      0.00000000000000E+00  -3.00332290668612E-14   0.00000000000000E+00   7.38303983748527E-16  -4.46734868143243E-23
      3.00097896299977E-11   3.00105279339368E-11  -1.32122014213234E-18  -8.81271573741680E-03  -8.81271573746403E-03
      0.00000000000000E+00   0.00000000000000E+00   4.72307320950136E-11   0.00000000000000E+00   4.72307320950136E-11
      4.97392363318355E-18  -1.99998043645322E-01  -1.99973708856802E-01   0.00000000000000E+00  -4.18242404694925E-13
     -1.12768105610904E-22  -7.68230176241428E-11  -7.72412600289505E-11  -3.65270349105120E-18
      1.00000000000000E-06
      0.00000000000000E+00  -3.47173106644451E-14   0.00000000000000E+00   6.55548705688125E-16  -4.38511432383004E-23
      3.47222930431484E-11   3.47229485918102E-11  -1.32051877983240E-18  -8.60169810974616E-03  -8.60169810978965E-03
      0.00000000000000E+00   0.00000000000000E+00   4.34954161965147E-11   0.00000000000000E+00   4.34954161965147E-11
      5.00862996172342E-18  -2.10923405851582E-01  -2.10898763296924E-01   0.00000000000000E+00  -4.32450390512795E-13
     -1.13686460737037E-22  -7.77859143976994E-11  -7.82183647883259E-11  -3.68811118189102E-18
}
